<?php

/**

 * lionfish 商城系统

 *

 * ==========================================================================

 * @link      http://www.liofis.com/

 * @copyright Copyright (c) 2015 liofis.com. 

 * @license   http://www.liofis.com/license.html License

 * ==========================================================================

 *

 * @author    fish

 * 处理订单相关内容

 */

namespace Home\Controller;



class ApiquanController extends CommonController {

    protected function _initialize()

    {

    	parent::_initialize();

        $this->cur_page = 'apiquan';


    }
	
	/**
		判断是否有发布圈子的权限
	**/
	public function get_quan_authority()
	{
		$token = I('get.token');
		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();
	    $member_id = $weprogram_token['member_id'];
		$member_info =  M('member')->where( array('member_id' => $member_id) )->find();
		
		if( empty($member_info) )
		{
			echo json_encode( array('code' => 1) );
			die();
		}
		
		$group_info = M('group')->where( array('seller_id' => 1) )->find();
		
		if( empty($group_info) )
		{
			echo json_encode( array('code' => 1,'msg'=>'未开放圈子功能') );
			die();
		}
		
		if($group_info['status'] == 0)
		{
			echo json_encode( array('code' => 1,'msg'=>'未开放圈子功能') );
			die();
		}
		if($group_info['limit_send_member'] == 1)
		{
			$member_ids = explode(',', $group_info['member_ids']);
			
			if( empty($member_ids) || !in_array($member_id, $member_ids) )
			{
				echo json_encode( array('code' => 1,'msg'=>'没有发布权限') );
				die();
			}
		}
		
		echo json_encode( array('code' => 0) );
		die();
		
	}
	
	/**
		发布帖子
	**/
	public function post_group()
	{
		$token = I('get.token');

		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();
	    $member_id = $weprogram_token['member_id'];
		$member_info =  M('member')->where( array('member_id' => $member_id) )->find();
		
		if( empty($member_info) )
		{
			echo json_encode( array('code' => 1,'msg' => '您未登录') );
			die();
		}
		
		$data_json = file_get_contents('php://input');		
		$data = json_decode($data_json, true);
		
		
		$data = $data;
		
		$group_id = $data['group_id'];
		$goods_id = $data['goods_id'];
		$is_share = $data['is_share'];
		$content = htmlspecialchars($data['content']);
		$pics = $data['pics'];
		
		
		//模拟数据begin
		//$group_id = 1;
		//$goods_id = 85;
		//$content = '测试发布圈子';
		//$pics = array();
		//模拟数据end
		
		$quan_model = D('Home/Quan');
		
		$post_data['member_id'] = $member_id;
		$post_data['group_id'] = $group_id;
		$post_data['goods_id'] = $goods_id;
		$post_data['title'] = $content;
		$post_data['is_share'] = $is_share;
		$post_data['content'] = serialize($pics);
		
		$rs =  $quan_model->send_group_post($post_data);
		
		if($rs)
		{
			echo json_encode( array('code' => 0) );
			die();
		} else{
			echo json_encode( array('code' => 1) );
			die();
		}
	}
	
	
	/**
		获取圈子信息
	**/
	public function get_quan_info()
	{
		$seller_id = I('get.seller_id', 1);
		
		$group_info = M('group')->where( array('seller_id' => $seller_id) )->find();
		
		if( empty($group_info) )
		{
			echo json_encode( array('code' => 1) );
			die();
		}
		
		$data = array();
		$data['group_id'] = $group_info['id'];
		$data['quan_name'] = $group_info['title'];
		$data['post_count'] = $group_info['post_count'];
		$data['status'] = $group_info['status'];
		$data['quan_share'] = $group_info['quan_share'];
		$data['quan_logo'] = C('SITE_URL').'Uploads/image/'. $group_info['quan_logo'];
		$data['quan_banner'] = C('SITE_URL').'Uploads/image/'. $group_info['quan_banner'];
		
		echo json_encode( array('code' =>0 , 'data' => $data) );
		die();
		
	}
	
	/**
		赞帖子/取消赞帖子
	**/
	public function member_fav_post()
	{
		$token = I('get.token');

		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();

	    $member_id = $weprogram_token['member_id'];

		if(empty($member_id))
		{
			echo json_encode( array('code' => 0) );//未登录
			die();
		}
		
		//code = 1 喜欢成功 code =2 取消喜欢
		$post_id = I('post.post_id',1);
		$quan_model = D('Home/Quan');
		
		$res = $quan_model->member_fav_post($member_id,$post_id);
		echo json_encode( $res );
		die();
	}
	
	/**
		对帖子进行评价
	**/
	public function comment_group_post()
	{
		$token = I('get.token');

		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();

	    $member_id = $weprogram_token['member_id'];

		if(empty($member_id))
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );//未登录
			die();
		}
		
		
		$data_json = file_get_contents('php://input');		
		$data = json_decode($data_json, true);
		
		
		$post_id = $data['post_id'];
		$content = $data['content'];
		$to_member_id = $data['reply_id'];
		
		if( empty($post_id) )
		{
			echo json_encode( array('code' => 1, 'msg' => '数据错误，未选择帖子') );//未登录
			die();
		}
		
		if( empty($content) )
		{
			echo json_encode( array('code' => 1, 'msg' => '请填写评价内容') );//未登录
			die();
		}
		
		
		$quan_model = D('Home/Quan');
		
		$last_post_id = $quan_model->comment_group_post($post_id,$content,$member_id,$to_member_id);
		
		echo json_encode( array('code' => 0,'member_id' => $member_id,'last_post_id' => $last_post_id) );
		die();
	}
	
	/**
		删除评论
	*/
	public function del_post_comment()
	{
		$token = I('get.token');
		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();
	    $member_id = $weprogram_token['member_id'];
		
		if( empty($member_id) )
		{
			echo json_encode( array('code' => 1, 'msg' =>'请先登录') );
			die();
		}
		
		$post_id = I('post.post_id');
		$comment_id = I('post.comment_id');
		
		
		$rs = M('group_lzl_reply')->where( array('post_id' => $post_id,'id' => $comment_id,'member_id' => $member_id) )->delete();
		
		if($rs)
		{
			echo json_encode(array('code' => 0));
			die();
		}else{
			echo json_encode(array('code' => 1, 'msg' =>'删除失败' ));
			die();	
		}
		
		
	}
	
	/**
		加载数据
		@param group_id 群组id
		@param post_id 帖子id
		@param up_down 加载方向：1 底部加载， 2顶部加载
		@param limit 加载10
	**/
	public function load()
	{
		//load_group_post($group_id,$post_id,$up_down,$limit=10)
		$group_id = I('get.group_id',1);
		$post_id = I('get.post_id',1);
		$up_down = I('get.up_down',0);
		$ht_s = I('get.ht_s',1);
		$limit = 10;
		
		$quan_model = D('Home/Quan');
		$list = $quan_model->load_group_post($group_id,$post_id,$up_down,10);
		
		
		if( empty($list) )
		{
			echo json_encode( array('code' => 1) );
			die();
		} else{
			
			reset($list);
			if($up_down == 1)
			{
				$end = current($list);
				$first = end($list);
				
			}else{
				$end = current($list);
				$first = end($list);
			}
			$this->ht_s = $ht_s/3;
			
			
			
			
			//up_post_id, down_post_id
			
			echo json_encode( array('code' => 0,'down_post_id'=>$first['id'],'up_post_id' => $end['id'] ,'list' => $list) );
			die();
		}
	}
	
	/**
		发布页加载商品列表数据
		@param id 商家id
		@param limit 加载10
	**/
	public function load_fabu_goods()
	{
		$pre_page = 10;
		
		$data_json = file_get_contents('php://input');		
		$data = json_decode($data_json, true);
		
		
		$page = isset($data['page']) ? $data['page']:1; //I('post.page',1);
		
		$seller_id = I('get.id',0);
		$order_by = 'sort_order asc';
		if(empty($seller_id))
		{
			$seller_id = isset($data['id']) ? $data['id']:0; 
		}
		
		
		$condition= " status=1 and quantity > 0 and type != 'lottery' and type != 'bargain' and type != 'integral' ";
		
		$goods_model = D('Home/Goods');
		$offset = ($page -1) * $pre_page;
		
		$list = M('goods')->field('seller_count,virtual_count,goods_id,name,image,fan_image')->where($condition)->order($order_by)->limit($offset,$pre_page)->select();
		
		if(!empty($list)) {
			foreach($list as $key => $v){
				unset($v['virtual_count']);
				
				$price_arr = $goods_model->get_goods_price($v['goods_id']);
		
				$list[$key]['pin_price'] = $price_arr['pin_price'];
				$list[$key]['danprice'] = $price_arr['danprice'];
				$list[$key]['price'] = $price_arr['price'];
		
				$list[$key]['seller_count'] += $v['virtual_count'];
				
				if(!empty($v['fan_image'])){
					$list[$key]['image']= C('SITE_URL'). resize($v['fan_image'], C('common_image_thumb_width'), C('common_image_thumb_height'));
				}
			}
		}

		if( empty($list) )
		{
			echo json_encode( array('code' => 1) );
			die();
		} else {
			$this->list = $list;
			echo json_encode( array('code' => 0, 'list' => $list) );
			die();
		}
	}
	
	public function get_user_info()
	{

		$token = I('get.token');

		$weprogram_token = M('weprogram_token')->field('member_id')->where( array('token' =>$token) )->find();

	    $member_id = $weprogram_token['member_id'];

		$member_info =  M('member')->field('name,avatar,score,member_id,comsiss_flag,level_id,account_money')->where( array('member_id' => $member_id) )->find();

		
		
		
		echo json_encode( array('code' => 0,'member_level_list' => $member_level_list,'level_name' => $level_name,'member_level_is_open' => $member_level_is_open_arr['value'],'is_yue_open' => $config_name['value'], 'opencommiss' => $opencommiss,'data' =>$member_info ,'is_open_integral' => $is_open_integral) );
		die();

	}


}