<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    cy(694418550@qq.com) 2021-03-11
 *
 */
namespace Home\Controller;

/**
 * 邀新有礼
 * Class InvitegiftController
 * @package Home\Controller
 */
class InvitegiftController extends CommonController {
	
	protected function _initialize(){
		parent::_initialize();
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 邀新有礼页面
	 */
	public function index(){
		$_GPC = I('request.');
		$token =  $_GPC['token'];

		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$data = array();
		$data = D('Home/Invitegift')->getInvitegiftInfo($member_id);
		echo json_encode( array('code' => 0, 'data' => $data) );
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 邀请好友列表
	 */
	public function getInvitegiftRecord(){
		$_GPC = I('request.');

		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$page = !empty($_GPC['page']) ? $_GPC['page'] : 1;
		$type = !empty($_GPC['type']) ? $_GPC['type'] : 'invite';//invite 已邀请好友，success 邀请成功好友

		$record_list = D('Home/Invitegift')->getInvitegiftRecordList( $member_id , $type, $page, 10 );
		echo json_encode( array('code' => 0, 'data' => $record_list) );
	}
	/**
	 * @author cy 2021-03-11
	 * @desc 新用户推荐有礼页面
	 */
	public function invitegiftIndex(){
		$_GPC = I('request.');

		$token =  $_GPC['token'];
		$member_id = 0;
		if(!empty($token)){
			$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
			$member_id = $weprogram_token['member_id'];
		}
		$suid = $_GPC['suid'];
		if(empty($suid)){
			echo json_encode( array('code' => 2, 'msg' => '参数不能为空') );
			die();
		}
		$member_info = M('lionfish_comshop_member')->where(array('member_id'=>$suid))->find();
		if(empty($member_info)){
			echo json_encode( array('code' => 3, 'msg' => '邀请人不存在') );
			die();
		}
		$need_data = D('Home/Invitegift')->getInvitegiftIndex();
		if(empty($need_data)){
			echo json_encode( array('code' => 4, 'msg' => '活动不存在') );
			die();
		}
		//老用户保存邀新记录
		if(!empty($member_id)){
			$members = M('lionfish_comshop_member')->where(array('member_id'=>$member_id))->find();
			if (empty($members['share_id'])) {
				if (intval($suid) > 0 && $suid != $member_id) {
					M('lionfish_comshop_member')->where( array('member_id' => $member_id ) )->save(array('share_id'=>$suid));
					D('Home/Invitegift')->insertInvitegiftRecord($suid, $member_id, 1);
				}
			}
		}
		$need_data['suid'] = $suid;

		echo json_encode( array('code' => 0, 'data' => $need_data) );
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 新用户领取礼包
	 * @return mixed
	 */
	public function collectInvitegift(){
		$_GPC = I('request.');

		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$data = D('Home/Invitegift')->collectInvitegift( $member_id );
		if($data['code'] == 0){
			echo json_encode( array('code' => 0, 'data' => $data) );
		}else{
			echo json_encode( array('code' => 2, 'msg' => $data['message']) );
		}
	}

	/**
	 *  @author cy 2021-03-12
	 *  @desc 立即邀请判断
	 */
	public function checkInvitegift(){
		$_GPC = I('request.');
		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$data = D('Home/Invitegift')->checkInvitegift( $member_id );
		if($data['code'] == 0){
			echo json_encode( array('code' => 0) );
		}else{
			echo json_encode( array('code' => 2, 'msg' => $data['message']) );
		}
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请优惠券列表
	 */
	public function getInvitegiftCouponList(){
		$_GPC = I('request.');
		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$page = !empty($_GPC['page']) ? $_GPC['page'] : 1;
		$coupon_list = D('Home/Invitegift')->getInvitegiftCouponList( $member_id , $page, 10 );

		echo json_encode( array('code' => 0,  'data'=>$coupon_list) );
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请积分数记录
	 * @return mixed
	 */
	public function getInvitegiftPoints(){
		$_GPC = I('request.');
		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];
		//总积分
		$total_points = D('Home/Invitegift')->getInvitegiftPointsTotal($member_id);
		$need_data['total_points'] = $total_points;

		echo json_encode( array('code' => 0,  'data'=>$need_data) );
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请积分明细列表
	 */
	public function getInvitegiftPointsList(){
		$_GPC = I('request.');
		$token =  $_GPC['token'];
		$weprogram_token = M('lionfish_comshop_weprogram_token')->field('member_id')->where( array('token' => $token) )->find();
		if(  empty($weprogram_token) ||  empty($weprogram_token['member_id']) )
		{
			echo json_encode( array('code' => 1, 'msg' => '未登录') );
			die();
		}
		$member_id = $weprogram_token['member_id'];

		$page = !empty($_GPC['page']) ? $_GPC['page'] : 1;
		$point_list = D('Home/Invitegift')->getInvitegiftPointsList( $member_id , $page, 10 );

		echo json_encode( array('code' => 0,  'data'=>$point_list) );
	}
}