<?php
namespace Home\Model;
use Think\Model;
/**
 * 邀新有礼模块
 * @author cy 2021-03-11
 *
 */
class InvitegiftModel{

	public function getInvitegiftInfo($member_id){
		$need_data = [];
		//邀新有礼配置信息
		$config_data = $this->getInvitegiftConfig();
		if(isset($config_data['is_invite_open_status']) && $config_data['is_invite_open_status'] == 1){
			//邀新有礼活动顶部背景图
			$need_data['invite_activity_topback_img'] = $config_data['invite_activity_topback_img'];
			//分享标题
			$need_data['invite_share_title'] = $config_data['invite_share_title'];
			//分享图片
			$need_data['invite_share_img'] = $config_data['invite_share_img'];
			//邀请下单分享标题
			$need_data['invite_order_share_title'] = $config_data['invite_order_share_title'];
			//邀请下单分享图片
			$need_data['invite_order_share_img'] = $config_data['invite_order_share_img'];
			//活动规则
			$need_data['invite_activity_rules'] = $config_data['invite_activity_rules'];

			//邀新有礼海报配置
			//背景    0、纯色背景，1、背景图片
			$need_data['invite_poster_back_type'] = $config_data['invite_poster_back_type'];
			//背景颜色
			$need_data['invite_poster_back_color'] = $config_data['invite_poster_back_color'];
			//背景图片
			$need_data['invite_poster_back_img'] = $config_data['invite_poster_back_img'];
			//二维码图片
			$need_data['invite_poster_qrcode_img'] = $this->getInvitegiftWxQrcode($member_id, $config_data);

			//二维码背景色
			$need_data['invite_poster_qrcode_backcolor'] = $config_data['invite_poster_qrcode_backcolor'];
			//二维码线条色
			$need_data['invite_poster_qrcode_linecolor'] = $config_data['invite_poster_qrcode_linecolor'];
			//二维码边角类型：0、圆角，1、直角
			$need_data['invite_poster_qrcode_corner_type'] = $config_data['invite_poster_qrcode_corner_type'];
			//二维码大小
			$need_data['invite_poster_qrcode_size'] = $config_data['invite_poster_qrcode_size'];
			//二维码边框状态：1、开启，0、关闭
			$need_data['invite_poster_qrcode_border_status'] = $config_data['invite_poster_qrcode_border_status'];
			//二维码边框颜色
			$need_data['invite_poster_qrcode_bordercolor'] = $config_data['invite_poster_qrcode_bordercolor'];
			//二维码距画布顶部位置
			$need_data['invite_poster_qrcode_top'] = $config_data['invite_poster_qrcode_top'];
			//二维码距画布左侧位置
			$need_data['invite_poster_qrcode_left'] = $config_data['invite_poster_qrcode_left'];
		}
		//我的活动收益
		$invitegift_data = $this->getMyInvitegiftIncome($member_id);
		$need_data['income'] = $invitegift_data;
		$need_data['suid'] = $member_id;
		return $need_data;
	}

	/**
	 * @author cy 2021-03-18
	 * @desc 获取会员的邀请有礼小程序码
	 * @param $member_id
	 * @param $config_data
	 */
	public function getInvitegiftWxQrcode($member_id, $config_data){
		$invite_poster_update_time = $config_data['invite_poster_update_time'];
		$member_invitegift = M('lionfish_comshop_member_invitegift')->where(array('member_id'=>$member_id))->find();
		$load_new = false;
		if( empty($member_invitegift) )
		{
			$load_new = true;
		}else {
			if( $member_invitegift['invite_addtime'] < $invite_poster_update_time )
			{
				$load_new = true;
			}
		}
		if( $load_new )
		{
			$qrcode_image = D('Home/Pingoods')->_get_invite_wxqrcode("lionfish_comshop/moduleB/invite/share", $member_id ,$config_data['invite_poster_qrcode_backcolor'],$config_data['invite_poster_qrcode_linecolor']);
			$data = array();
			$data['image_path']  = $qrcode_image;
			$ed_time = time() + 5;
			$js_arr = array('member_id' => $member_id,'invite_addtime' => $ed_time,'invite_image_path' => $data['image_path'] );
			M('lionfish_comshop_member_invitegift')->add($js_arr);
		}else{
			$data = array();
			$data['image_path']  = $member_invitegift['invite_image_path'];
		}
		return tomedia($data['image_path']);
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 我的活动收益
	 * @param int $user_id
	 * @return array
	 */
	public function getMyInvitegiftIncome($user_id){
		$income_data = [];
		//邀请成功人数（已领取的被邀请人数）
		$invitee_succ_count = $this->getInviteeSuccCout($user_id);
		//累计邀请人数（已邀请的被邀请人数）
		$invitee_count = $this->getInviteeCout($user_id);
		//累计奖励（邀请者已领取的奖励次数）
		$inviter_total_count = $this->getInviterTotalCout($user_id);

		$income_data['invitee_succ_count'] = $invitee_succ_count;
		$income_data['invitee_count'] = $invitee_count;
		$income_data['inviter_total_count'] = $inviter_total_count;
		return $income_data;
	}

	/**
	 * @author cy 2021-02-18
	 * @desc 邀请成功人数（已领取的被邀请人数）
	 * @param unknown $user_id
	 * @param unknown $city_id
	 * @return number
	 */
	public function getInviteeSuccCout($user_id){
		$condition['user_id']  = $user_id;
		$condition['invitee_status'] = 1;
		$count = $this->getInvitegiftRecordCount($condition);
		return $count;
	}

	/**
	 * @author cy 2021-02-18
	 * @desc 累计邀请人数（已邀请的被邀请人数）
	 * @param unknown $user_id
	 * @param unknown $city_id
	 * @return number
	 */
	public function getInviteeCout($user_id){
		$condition['user_id']  = $user_id;
		$count = $this->getInvitegiftRecordCount($condition);
		return $count;
	}
	/**
	 * @author cy 2021-02-18
	 * @desc 累计奖励（邀请者已领取的奖励次数）
	 * @param unknown $user_id
	 * @param unknown $city_id
	 * @return number
	 */
	public function getInviterTotalCout($user_id){
		$condition['user_id']  = $user_id;
		$condition['status']  = 1;
		$count = $this->getInvitegiftRecordCount($condition);
		return $count;
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 根据条件获取邀新有礼记录数
	 * @param unknown $condition
	 * @return number
	 */
	public function getInvitegiftRecordCount($condition){
		$count = M('lionfish_comshop_invitegift_record')->where($condition)->count();
		return !empty($count) ? $count : 0;
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 邀新有礼配置信息
	 * @return array
	 */
	public function getInvitegiftConfig(){
		$invitegift_config = array();
		$city_config = D('Seller/Config')->get_all_config();

		if(!empty($city_config['is_invite_open_status'])){
			//邀新有礼开启状态
			$invitegift_config['is_invite_open_status'] = $city_config['is_invite_open_status'];
			//邀请者奖励类型
			$invitegift_config['inviter_reward_type'] = $city_config['inviter_reward_type'];
			//邀请者奖励优惠券id
			$invitegift_config['inviter_reward_couponid'] = $city_config['inviter_reward_couponid'];
			//邀请者奖励积分数
			$invitegift_config['inviter_reward_point'] = $city_config['inviter_reward_point'];

			//被邀请者奖励类型
			$invitegift_config['invitees_reward_type'] = $city_config['invitees_reward_type'];
			//被邀请者新人注册（授权登录）奖励类型
			$invitegift_config['invitees_register_reward_type'] = $city_config['invitees_register_reward_type'];
			//被邀请者新人注册（授权登录）奖励优惠券id
			$invitegift_config['invitees_register_reward_couponid'] = $city_config['invitees_register_reward_couponid'];
			//被邀请者新人注册（授权登录）奖励积分数
			$invitegift_config['invitees_register_reward_point'] = $city_config['invitees_register_reward_point'];

			//被邀请者下单完成奖励类型
			$invitegift_config['invitees_order_reward_type'] = $city_config['invitees_order_reward_type'];
			//被邀请者下单完成奖励优惠券id
			$invitegift_config['invitees_order_reward_couponid'] = $city_config['invitees_order_reward_couponid'];
			//被邀请者下单完成奖励积分数
			$invitegift_config['invitees_order_reward_point'] = $city_config['invitees_order_reward_point'];
			//被邀请者下单完成活动奖励时间：0、下单支付完成获得奖励，1、订单售后期结束获得奖励
			$invitegift_config['invite_activity_reward_type'] = $city_config['invite_activity_reward_type'];

			//是否开启邀请人数限制:1、开启，0、关闭
			$invitegift_config['is_open_invitation_limit'] = $city_config['is_open_invitation_limit'];
			//邀请人数限制人数
			$invitegift_config['invitation_limit_person'] = $city_config['invitation_limit_person'];

			//邀新有礼活动顶部背景图
			if(!empty($city_config['invite_activity_topback_img'])){
				$invitegift_config['invite_activity_topback_img'] = tomedia($city_config['invite_activity_topback_img']);
			}else{
				$invitegift_config['invite_activity_topback_img'] = "";
			}
			//活动打开页面顶部背景图
			if(!empty($city_config['invite_activity_open_topback_img'])){
				$invitegift_config['invite_activity_open_topback_img'] = tomedia($city_config['invite_activity_open_topback_img']);
			}else{
				$invitegift_config['invite_activity_open_topback_img'] = "";
			}
			//活动积分/优惠卷使用规则
			$invitegift_config['invite_activity_use_rules'] = htmlspecialchars_decode($city_config['invite_activity_use_rules']);
			//分享标题
			$invitegift_config['invite_share_title'] = $city_config['invite_share_title'];
			//分享图片
			if(!empty($city_config['invite_share_img'])){
				$invitegift_config['invite_share_img'] = tomedia($city_config['invite_share_img']);
			}else{
				$invitegift_config['invite_share_img'] = "";
			}
			//邀请下单分享标题
			$invitegift_config['invite_order_share_title'] = $city_config['invite_order_share_title'];
			//邀请下单分享图片
			if(!empty($city_config['invite_order_share_img'])){
				$invitegift_config['invite_order_share_img'] = tomedia($city_config['invite_order_share_img']);
			}else{
				$invitegift_config['invite_order_share_img'] = "";
			}
			//活动规则
			$invitegift_config['invite_activity_rules'] = htmlspecialchars_decode($city_config['invite_activity_rules']);

			//邀新有礼海报配置
			//背景    0、纯色背景，1、背景图片
			$invitegift_config['invite_poster_back_type'] = $city_config['invite_poster_back_type'];
			//背景颜色
			$invitegift_config['invite_poster_back_color'] = $city_config['invite_poster_back_color'];
			//背景图片
			if(!empty($city_config['invite_poster_back_img'])){
				$invitegift_config['invite_poster_back_img'] = tomedia($city_config['invite_poster_back_img']);
			}else{
				$invitegift_config['invite_poster_back_img'] = "";
			}
			//二维码
			if(!empty($city_config['invite_poster_qrcode_img'])){
				$invitegift_config['invite_poster_qrcode_img'] = tomedia($city_config['invite_poster_qrcode_img']);
			}else{
				$invitegift_config['invite_poster_qrcode_img'] = "";
			}
			//二维码背景颜色
			$invitegift_config['invite_poster_qrcode_backcolor'] = $city_config['invite_poster_qrcode_backcolor'];
			//二维码线条颜色
			$invitegift_config['invite_poster_qrcode_linecolor'] = $city_config['invite_poster_qrcode_linecolor'];
			//二维码边角类型：0、圆角，1、直角
			$invitegift_config['invite_poster_qrcode_corner_type'] = $city_config['invite_poster_qrcode_corner_type'];
			//二维码大小
			$invitegift_config['invite_poster_qrcode_size'] = $city_config['invite_poster_qrcode_size'];
			//二维码边框状态：1、开启，0、关闭
			$invitegift_config['invite_poster_qrcode_border_status'] = $city_config['invite_poster_qrcode_border_status'];
			//二维码边框颜色
			$invitegift_config['invite_poster_qrcode_bordercolor'] = $city_config['invite_poster_qrcode_bordercolor'];
			//二维码距画布顶部
			$invitegift_config['invite_poster_qrcode_top'] = $city_config['invite_poster_qrcode_top'];
			//二维码距画布左侧
			$invitegift_config['invite_poster_qrcode_left'] = $city_config['invite_poster_qrcode_left'];
			//二维码更新时间
			$invitegift_config['invite_poster_update_time'] = $city_config['invite_poster_update_time'];
		}
		return $invitegift_config;
	}

	/**
	 * @author cy 2021-03-11
	 * @desc 邀请好友列表
	 * @param $member_id
	 * @param string $type
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	public function getInvitegiftRecordList($member_id , $type = '', $page = 1, $perpage = 10){
		$condition = " a.user_id = {$member_id} ";

		if(!empty($type)){
			if($type == 'success'){
				$condition .= " and a.is_old = 0 and invitee_status = 1 ";
			}
		}

		$offset = ($page - 1) * $perpage;

		$sql = "select a.* from ".C('DB_PREFIX')."lionfish_comshop_invitegift_record as a where $condition order by a.addtime desc limit {$offset},{$perpage} ";

		$list = M()->query( $sql );
		$need_data = [];
		if( !empty($list) )
		{
			foreach( $list as &$v )
			{
				$tmp_arr = $this->getInvitegiftRecordDetail($v);
				$need_data[] = $tmp_arr;
			}
		}
		return $need_data;
	}

	/**
	 * @author cy 2021-02-18
	 * @desc 获取单条邀新有礼记录信息
	 * @param array $collect
	 */
	public function getInvitegiftRecordDetail($invitegift_record){
		$tmp_arr = [];
		$member_info = M('lionfish_comshop_member')->where(array('member_id'=>$invitegift_record['invitee_userid']))->field('avatar,username')->find();
		$tmp_arr['invitee_userid'] = $invitegift_record['invitee_userid'];
		$tmp_arr['avatar'] = isset($member_info['avatar']) ? $member_info['avatar'] : '';
		$tmp_arr['nickname'] = isset($member_info['username']) ? $member_info['username'] : '';
		if($invitegift_record['is_old'] == 1){
			$tmp_arr['user_type'] = 'old';
			$tmp_arr['invite_type'] = 'old';
			$tmp_arr['reward_content'] = '无奖励';
			$tmp_arr['receive_content'] = '暂不参与';
		}else{
			$tmp_arr['user_type'] = 'new';
			if($invitegift_record['invitee_status'] == 1){//已领取
				$tmp_arr['reward_content'] = '奖励已到账';
				$tmp_arr['receive_content'] = '邀请成功';
				$tmp_arr['invite_type'] = 'success';
			}else{//未领取
				$tmp_arr['invite_type'] = 'wait';
				if($invitegift_record['invitees_reward_type'] == 1){//新人注册（授权登录）即奖励
					$tmp_arr['reward_content'] = '奖励待到账';
					$tmp_arr['receive_content'] = '注册成功登录后即奖励';
					$tmp_arr['invite_order_btn'] = 0;
				}else{
					if($invitegift_record['invitees_reward_type'] == 2){//新人注册（授权登录）并且下单奖励
						$tmp_arr['reward_content'] = '邀请下单';
						$tmp_arr['receive_content'] = '注册成功，受邀人下单后即为邀请成功';
						$tmp_arr['invite_order_btn'] = 1;
					}else if($invitegift_record['invitees_reward_type'] == 0){//新人注册（授权登录）和下单分别奖励
						$tmp_arr['reward_content'] = '邀请下单';
						$tmp_arr['receive_content'] = '注册成功，下单后继续奖励';
						$tmp_arr['invite_order_btn'] = 1;
					}
					if($invitegift_record['invite_activity_reward_type'] == 1){//订单售后期结束获得奖励
						//会员已付款订单数
						$success_where = " and member_id = ".$invitegift_record['invitee_userid']." and order_status_id in (1,4,6,7,11,14) and type <> 'integral' ";
						$order_count =  D('Seller/Order')->get_order_count($success_where);

						//会员退款订单数
						$refund_cancel_where = " and member_id = ".$invitegift_record['invitee_userid']." and order_status_id in (7) and type <> 'integral' ";
						$pay_refund_count = D('Seller/Order')->get_order_count($refund_cancel_where);

						if($order_count > 0){
							if($order_count > $pay_refund_count){
								$tmp_arr['invite_order_btn'] = 0;
								$tmp_arr['reward_content'] = '奖励待到账';
								$tmp_arr['reward_tip'] = '被邀请人的订单在售后期内，需要等待售后期结束才能获得活动奖励';
							}else{
								$tmp_arr['invite_type'] = 'invalid';
								$tmp_arr['reward_content'] = '奖励失效';
								$tmp_arr['invite_order_btn'] = 1;
								$tmp_arr['reward_tip'] = '被邀请人的订单在售后期内发生退款，需要被邀请人重新下单才可获得奖励';
							}
						}
					}
				}
			}
		}
		$tmp_arr['addtime'] = date('Y-m-d H:i',$invitegift_record['addtime']);
		return $tmp_arr;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 推荐有礼页面
	 */
	public function getInvitegiftIndex($member_id){
		$need_data = [];
		$config_data = $this->getInvitegiftConfig();
		if(isset($config_data['is_invite_open_status']) && $config_data['is_invite_open_status'] == 1){
			//活动打开页面顶部背景图
			$need_data['invite_activity_open_topback_img'] = $config_data['invite_activity_open_topback_img'];
			//活动规则
			$need_data['invite_activity_rules'] = $config_data['invite_activity_rules'];
			//活动积分/优惠卷使用规则
			$need_data['invite_activity_use_rules'] = $config_data['invite_activity_use_rules'];
		}
		return $need_data;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 保存邀请记录并返回是否可以领取礼包
	 * @param $share_id 邀请人
	 * @param $member_id 被邀请人
	 * @param $is_old   是否老用户：1、是，0、不是
	 * @return int  1、可以领取，0、不能领取，2、老用户不能领取
	 */
	public function insertInvitegiftRecord($share_id,$member_id, $is_old){
		$is_can_collect_gift = 0;

		$city_config = $this->getInvitegiftConfig();
		if(isset($city_config['is_invite_open_status']) && $city_config['is_invite_open_status'] == 1){
			$insert_data = [];
			$insert_data['user_id'] = $share_id;
			$insert_data['invitee_userid'] = $member_id;
			$insert_data['is_old'] = $is_old;

			$insert_data['inviter_reward_type'] = $city_config['inviter_reward_type'];
			$insert_data['inviter_reward_couponid'] = $city_config['inviter_reward_couponid'];
			$insert_data['inviter_reward_point'] = $city_config['inviter_reward_point'];

			$insert_data['invitees_reward_type'] = $city_config['invitees_reward_type'];
			$insert_data['invitees_register_reward_type'] = $city_config['invitees_register_reward_type'];
			$insert_data['invitees_register_reward_couponid'] = $city_config['invitees_register_reward_couponid'];
			$insert_data['invitees_register_reward_point'] = $city_config['invitees_register_reward_point'];
			$insert_data['invitees_order_reward_type'] = $city_config['invitees_order_reward_type'];
			$insert_data['invitees_order_reward_couponid'] = $city_config['invitees_order_reward_couponid'];

			$insert_data['invitees_order_reward_point'] = $city_config['invitees_order_reward_point'];
			$insert_data['invite_activity_reward_type'] = $city_config['invite_activity_reward_type'];
			$insert_data['addtime'] = time();
			if($is_old == 1){//老用户默认已领取
				$insert_data['invitee_status'] = 1;
				$insert_data['invitee_register_status'] = 1;
				$insert_data['status'] = 1;
			}
			$this->addInvitegiftRecord($insert_data);
			if($is_old == 1){
				$is_can_collect_gift = 2;
			}else{
				//1、新人注册（授权登录）即奖励  0、新人注册（授权登录）和下单分别奖励
				if($city_config['invitees_reward_type'] == 1 || $city_config['invitees_reward_type'] == 0){
					$is_can_collect_gift = 1;
				}else{
					$is_can_collect_gift = 0;
				}
			}
		}
		return $is_can_collect_gift;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 添加邀新有礼记录
	 * @param $data
	 * @return int
	 */
	public function addInvitegiftRecord( $data )
	{
		$id = M('lionfish_comshop_invitegift_record')->add( $data );
		return $id;
	}

	/************************************领取邀新礼包 begin*********************************************/
	/**
	 * @author cy 2021-03-12
	 * @desc 新用户领取礼包
	 * @param $user_id
	 * @return array
	 */
	public function collectInvitegift( $user_id ){
		$need_data = [];
		M()->startTrans();
		$invitegift_record = $this->getInvitegiftRecordCollect($user_id);
		if(!empty($invitegift_record)){
			//被邀请者未领取礼包
			if($invitegift_record['invitee_status'] == 0){
				if($invitegift_record['invitees_reward_type'] == 0 && $invitegift_record['invitee_register_status'] == 1){
					// 事务回滚
					M()->rollback();
					return ['code'=>4 ,'message'=>'已领取新人礼包，下单后继续领取'];
					//新人注册（授权登录）和下单分别奖励
				}else if($invitegift_record['invitees_reward_type'] == 0 && 	$invitegift_record['invitee_register_status'] == 0){
					//新人注册（授权登录）奖励
					$gift_data = $this->receiveRegisterInvitegift($invitegift_record);
					//更新被邀请者已领取
					$this->updateInvitegiftRecord($invitegift_record['id'], array('invitee_register_status'=>1));
					$need_data['coupon_info'] = $gift_data['coupon_info'];
					$need_data['point'] = $gift_data['point'];
					//新人注册（授权登录）即奖励
				}else if($invitegift_record['invitees_reward_type'] == 1){
					//新人注册（授权登录）奖励
					$gift_data = $this->receiveRegisterInvitegift($invitegift_record);
					//更新被邀请者已领取
					$this->updateInvitegiftRecord($invitegift_record['id'], array('invitee_status'=>1,'invitee_register_status'=>1));
					//邀请者领取礼包
					$this->inviterReceiveInvitegift($invitegift_record);
					$need_data['coupon_info'] = $gift_data['coupon_info'];
					$need_data['point'] = $gift_data['point'];
					//新人注册（授权登录）并且下单奖励 暂不领取
				}else if($invitegift_record['invitees_reward_type'] == 2){
					// 事务回滚
					M()->rollback();
					return ['code'=>3,'message'=>'下单后才能领取礼包'];
				}
			}else{
				// 事务回滚
				M()->rollback();
				return ['code'=>2,'message'=>'礼包已领取过'];
			}
		}else{
			// 事务回滚
			M()->rollback();
			return ['code'=>1,'message'=>'没有未领取礼包'];
		}
		M()->commit();
		$need_data['code'] = 0;
		return $need_data;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 新人注册即奖励
	 * @param $invitegift_record
	 */
	public function receiveRegisterInvitegift($invitegift_record){
		$need_data = [];
		//被邀请者新人注册（授权登录）奖励类型
		//赠送优惠券id
		$couponid = $invitegift_record['invitees_register_reward_couponid'];
		//赠送积分数
		$point = $invitegift_record['invitees_register_reward_point'];
		//0 送优惠券和积分
		if($invitegift_record['invitees_register_reward_type'] == 0){
			//新人送优惠券
			$need_data['coupon_info'] = $this->sendInvitegiftCoupon($couponid, $invitegift_record['invitee_userid'], $invitegift_record['id'], 'invitegift_new');
			//新人送积分
			$this->sendInvitegiftPoint($point, $invitegift_record['invitee_userid'], $invitegift_record['id'], 'invitegift_new');
			$need_data['point'] = $point;
			//1 送优惠券
		}else if($invitegift_record['invitees_register_reward_type'] == 1){
			//新人送优惠券
			$need_data['coupon_info'] = $this->sendInvitegiftCoupon($couponid, $invitegift_record['invitee_userid'],  $invitegift_record['id'],'invitegift_new');
			$need_data['point'] = 0;
			//2 送积分
		}else if($invitegift_record['invitees_register_reward_type'] == 2){
			//新人送积分
			$this->sendInvitegiftPoint($point, $invitegift_record['invitee_userid'], $invitegift_record['id'],  'invitegift_new');
			$need_data['point'] = $point;

			$need_data['coupon_info'] = [];
		}
		return  $need_data;
	}

	/**
	 * @author cy 2021-02-20
	 * @desc 邀请者领取礼包
	 * @param $invitegift_record
	 */
	public function inviterReceiveInvitegift($invitegift_record){
		//优惠券
		$couponid = $invitegift_record['inviter_reward_couponid'];
		//积分
		$point = $invitegift_record['inviter_reward_point'];
		//送优惠券和积分
		if($invitegift_record['inviter_reward_type'] == 0){
			$this->sendInvitegiftCoupon($couponid, $invitegift_record['user_id'], $invitegift_record['id'], 'invitegift');
			$this->sendInvitegiftPoint($point, $invitegift_record['user_id'], $invitegift_record['id'], 'invitegift');
			//送优惠券
		}else if($invitegift_record['inviter_reward_type'] == 1){
			$this->sendInvitegiftCoupon($couponid, $invitegift_record['user_id'], $invitegift_record['id'], 'invitegift');
			//送积分
		}else if($invitegift_record['inviter_reward_type'] == 2){
			$this->sendInvitegiftPoint($point, $invitegift_record['user_id'], $invitegift_record['id'], 'invitegift');
		}
		//更新邀请者已领取
		$this->updateInvitegiftRecord($invitegift_record['id'],array('status'=>1));
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀新有礼送优惠券
	 * @param $couponid
	 * @param $user_id
	 * @param $receive_type invitegift_new 被邀请者，invitegift 邀请者
	 */
	public function sendInvitegiftCoupon($couponid, $user_id , $invite_id, $receive_type){
		//发放优惠券
		$result = D('Home/Voucher')->send_invitegift_coupon_byId($couponid ,$user_id, $invite_id ,$receive_type);
		if($result['code'] == 0){
			$coupons = M('lionfish_comshop_coupon_list')->where( array('id' => $result['id']) )->find();
			$coupons['begin_time'] = date('Y-m-d H:i:s',$coupons['begin_time']);
			$coupons['end_time'] = date('Y-m-d H:i:s',$coupons['end_time']);
			return $coupons;
		}else{
			return array();
		}
	}

	/**
	 * @author cy 2021-02-20
	 * @desc 邀新有礼送积分
	 * @param $point
	 * @param $user_id
	 * @param $receive_type invitegift_new 被邀请者，invitegift 邀请者
	 */
	public function sendInvitegiftPoint($point, $user_id , $invite_id,$receive_type){
		$order_model = D('Seller/Order');
		$order_model->charge_member_score( $user_id , $point,'in', $receive_type, $invite_id);
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 更新邀新有礼记录表
	 * @param $id
	 * @param $data
	 * @return mixed
	 */
	public function updateInvitegiftRecord($id,$data){
		return M('lionfish_comshop_invitegift_record')->where(array('id'=>$id))->save($data);
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 通过被邀请人获取邀新有礼记录
	 * @param $user_id
	 * @return mixed
	 */
	public function getInvitegiftRecordCollect($user_id){
		$collect = M('lionfish_comshop_invitegift_record')->where(array('invitee_userid'=>$user_id))->find();
		return $collect;
	}
	/************************************领取邀新礼包 end*********************************************/

	/**
	 * @author cy 2021-03-12
	 * @desc 立即邀请判断
	 * @param $user_id
	 * @return array
	 */
	public function checkInvitegift($member_id){
		$result = [];
		$result['code'] = 0;
		$member_info = M('lionfish_comshop_member')->where(array('member_id'=>$member_id))->field('share_status')->find();
		if($member_info['share_status'] == 0){
			$result['code'] = 1;
			$result['message'] = "邀请人数超过活动限制";
		}else{
			$config_data = $this->getInvitegiftConfig();
			//是否开启邀请人数限制:1、开启，0、关闭
			$is_open_invitation_limit = $config_data['is_open_invitation_limit'];
			//邀请人数限制人数
			$invitation_limit_person = $config_data['invitation_limit_person'];
			if($is_open_invitation_limit == 1){
				$count = $this->getInviteeCout($member_id);
				if($count >= $invitation_limit_person){
					$result['code'] = 1;
					$result['message'] = "邀请人数超过活动限制";
				}
			}
		}
		return $result;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请优惠券列表
	 * @param $member_id
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	public function getInvitegiftCouponList( $member_id , $page = 1, $perpage = 10 ){
		$offset = ($page - 1)*$perpage;

		$condition = " user_id=".$member_id." and receive_type in ('invitegift','invitegift_new') ";
		//未使用
		$condition .= " and consume= 'N' and end_time> ".time();

		$coupon_list = M('lionfish_comshop_coupon_list')->where($condition)->order('add_time desc')->limit($offset,$perpage)->select();

		foreach($coupon_list as $k=>&$v){
			$v['begin_time'] = date('Y-m-d H:i:s', $v['begin_time']);
			$v['end_time'] = date('Y-m-d H:i:s', $v['end_time']);
		}
		return $coupon_list;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请积分明细列表
	 * @param $user_id
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	public function getInvitegiftPointsList( $member_id , $page = 1, $perpage = 10 ){

		$offset = ($page - 1)*$perpage;

		$condition = " member_id=".$member_id." and type in ('invitegift_new','invitegift')";

		$point_list = M('lionfish_comshop_member_integral_flow')->where($condition)->order('addtime desc')->limit($offset,$perpage)->select();

		if( !empty($point_list) )
		{
			foreach($point_list as &$collect )
			{
				$collect['addtime'] = date('Y-m-d H:i:s', $collect['addtime']);
			}
		}
		return $point_list;
	}

	/**
	 * @author cy 2021-03-12
	 * @desc 邀请总积分
	 * @param $member_id
	 * @return int
	 */
	public function getInvitegiftPointsTotal($member_id){
		$condition = " member_id=".$member_id." and type in ('invitegift_new','invitegift')";
		$total_point = M('lionfish_comshop_member_integral_flow')->where($condition)->sum('score');
		return empty($total_point) ? 0 : $total_point;
	}

	/**
	 * @author cy 2021-03-18
	 * @desc 新用户下单后领取礼包
	 * @param $order_collect
	 * @param $order_type
	 * @return array
	 */
	public function collectInvitegiftAfterOrder( $order_info, $order_type ){
		$need_data = [];
		$user_id = $order_info['member_id'];
		$invitegift_record = $this->getInvitegiftRecordCollect($user_id);
		if(!empty($invitegift_record)){
			//被邀请者未领取礼包
			if($invitegift_record['invitee_status'] == 0){
				//活动奖励：0、下单支付完成获得奖励，1、订单售后期结束获得奖励
				$invite_activity_reward_type = $invitegift_record['invite_activity_reward_type'];
				//0、新人注册（授权登录）和下单分别奖励 或者 2、新人注册（授权登录）并且下单奖励
				if($invitegift_record['invitees_reward_type'] == 0 || $invitegift_record['invitees_reward_type'] == 2){
					//0、下单支付完成获得奖励，1、订单售后期结束获得奖励
					if(($invite_activity_reward_type == 0 && $order_type == 'orderpay') || ($invite_activity_reward_type == 1 && $order_type == 'aftersaletime')){
						//下单完成奖励
						$gift_data = $this->receiveOrderInvitegift($invitegift_record);
						//更新被邀请者已领取
						$this->updateInvitegiftRecord($invitegift_record['id'],['invitee_status'=>1]);
						//邀请者领取礼包
						$this->inviterReceiveInvitegift($invitegift_record);
						$need_data['coupon_info'] = $gift_data['coupon_info'];
						$need_data['point'] = $gift_data['point'];
					}else{
						return ['code'=>3,'message'=>'礼包未达领取条件'];
					}
				}else{
					return ['code'=>3,'message'=>'礼包未达领取条件'];
				}
			}else{
				return ['code'=>2,'message'=>'礼包已领取过'];
			}
		}else{
			return ['code'=>1,'message'=>'没有未领取礼包'];
		}
		$need_data['code'] = 0;
		return $need_data;
	}

	/**
	 * @author cy 2021-02-22
	 * @desc 下单完成即奖励
	 * @param $invitegift_record
	 */
	public function receiveOrderInvitegift($invitegift_record){
		$need_data = [];
		//被邀请者下单完成奖励类型
		//赠送优惠券id
		$couponid = $invitegift_record['invitees_order_reward_couponid'];
		//赠送积分数
		$point = $invitegift_record['invitees_order_reward_point'];
		//0 送优惠券和积分
		if($invitegift_record['invitees_order_reward_type'] == 0){
			//新人送优惠券
			$need_data['coupon_info'] = $this->sendInvitegiftCoupon($couponid, $invitegift_record['invitee_userid'], $invitegift_record['id'], 'invitegift_new');
			//新人送积分
			$this->sendInvitegiftPoint($point, $invitegift_record['invitee_userid'], $invitegift_record['id'],'invitegift_new');
			$need_data['point'] = $point;
			//1 送优惠券
		}else if($invitegift_record['invitees_order_reward_type'] == 1){
			//新人送优惠券
			$need_data['coupon_info'] = $this->sendInvitegiftCoupon($couponid, $invitegift_record['invitee_userid'],  $invitegift_record['id'], 'invitegift_new');
			$need_data['point'] = 0;
			//2 送积分
		}else if($invitegift_record['invitees_order_reward_type'] == 2){
			//新人送积分
			$this->sendInvitegiftPoint($point, $invitegift_record['invitee_userid'], $invitegift_record['id'],'invitegift_new');
			$need_data['point'] = $point;

			$need_data['coupon_info'] = [];
		}
		return  $need_data;
	}
}