<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    fish
 *
 */
namespace Seller\Controller;

class PlatformmobileController extends CommonController{
	protected $menu;
	protected function _initialize(){
		parent::_initialize();

		$menu = array(
            'title'    => '平台手机端',
            'subtitle' => '平台手机端',
            'route' => 'mptradecomponts/index',
            'items'    => array(

                array('title' => '设置', 'route' => 'platformmobile/config'),            )
        );

        $perm_url = strtolower(CONTROLLER_NAME) .'/'. strtolower(ACTION_NAME);
        $this->assign('perm_url', $perm_url );

		//组件权限方法===begin
        if(SELLERUID != 1)
        {
            $seller_info = M('seller')->field('s_role_id')->where( array('s_id' => SELLERUID ) )->find();

            $perm_role = M('lionfish_comshop_perm_role')->where( array('id' => $seller_info['s_role_id']) )->find();

            $perms_str = $perm_role['perms2'];

            $items = [];
            $can_use_routearr = [];

            foreach( $menu['items'] as $val )
            {
                $val_route =  str_replace('/','.', $val['route']);

                if( strpos($perms_str, '.'.$val_route) !== false )
                {
                    $items[] = $val;
                    $can_use_routearr[] = strtolower($val['route']);
                }
            }
            $menu['items'] = $items;
            if( empty($can_use_routearr) )
            {
                $this->redirect( 'application/index', [], 1,'您没有当前应用权限' );
            }else if( !in_array($perm_url , $can_use_routearr ) )
            {
                $this->redirect( $can_use_routearr[0]  );
            }
        }
        //组件方法end
		$this->menu = $menu;
		$this->assign('menu', $menu );
	}



	public function config()
    {
        $_GPC = I('request.');



        //提交更新
        if(IS_POST)
        {
            //获取选中的会员id
            $data = array();
            $data['userids'] = $_GPC['limit_user_list'];



            $platform = array();
            $platform['platform_admin_member']= $data['userids'];
            $platform['isopen_admin_managefront']= $_GPC['isopen_admin_managefront'];

            D('Seller/Config')->update($platform);

            show_json(1, array('url' => $_SERVER['HTTP_REFERER']));
        }

        $data = D('Seller/Config')->get_all_config();

        //查询下会员id
        if(!empty($data['platform_admin_member'])){

            //in语句查询会员对应信息
            $list = array();
            if( !empty($data['platform_admin_member']) )
            {
                $list = M('lionfish_comshop_member')->field('member_id, username as nickname,avatar')->where('member_id in('.$data['platform_admin_member'].')')->select();
            }

            //组合
            foreach($list as $key => $vv){
                $userall =array(
                    'member_id' => $vv[member_id],
                    'nickname' => $vv[nickname],
                    'avatar' => tomedia($vv[avatar]),
                );
                $user_list[$key]=$userall;
            }
        }else{

            $user_list = array();
        }



        $data = D('Seller/Config')->get_all_config();
        $this->data = $data;
        $this->user_list = $user_list;

        $this->display();
    }

}
?>