<?php
/**
 * lionfish 商城系统
 *
 * ==========================================================================
 * @link      http://www.liofis.com/
 * @copyright Copyright (c) 2015 liofis.com. 
 * @license   http://www.liofis.com/license.html License
 * ==========================================================================
 *
 * @author    fish
 *
 */
namespace Seller\Controller;

class PresaleController extends CommonController{
	
	protected function _initialize(){
		parent::_initialize();

	}


	public function index()
    {
        $_GET['goods_type'] = 'presale';

        $Goods_controller = A('Goods');

        $Goods_controller->index();

    }

    /**
     * @author yj
     * @desc 预售配置
     */
	public function config()
    {
        $_GPC = I('request.');

        if (IS_POST) {

            $data = ((is_array($_GPC['parameter']) ? $_GPC['parameter'] : array()));

            $data['isopen_presale'] = isset($data['isopen_presale']) ? $data['isopen_presale']:0;

            $data['presale_layout'] = isset($data['presale_layout']) ? $data['presale_layout']:0;
            $data['is_open_presale_show'] = isset($data['is_open_presale_show']) ? $data['is_open_presale_show']:0;
            $data['iscan_presale_dingrefund'] = isset($data['iscan_presale_dingrefund']) ? $data['iscan_presale_dingrefund']:0;
            $data['presale_name_modify'] = isset($data['presale_name_modify']) ? $data['presale_name_modify']:'';
            $data['presale_share_title'] = isset($data['presale_share_title']) ? $data['presale_share_title']:'';
            $data['presale_share_img'] = isset($data['presale_share_img']) ? $data['presale_share_img']:'';
            $data['presale_publish'] = isset($data['presale_publish']) ? $data['presale_publish']:'';

            D('Seller/Config')->update($data);

            show_json(1,  array('url' => $_SERVER['HTTP_REFERER']) );
            die();

        }

        $data = D('Seller/Config')->get_all_config();
        $this->data = $data;

        $this->display();
    }

    /**
     * @author yj
     * @desc 预售订阅消息
     */
    public function templatemsg()
    {
        $_GPC = I('request.');

        if (IS_POST) {

            $data = ((is_array($_GPC['parameter']) ? $_GPC['parameter'] : array()));

            $data['isopen_presale'] = isset($data['isopen_presale']) ? $data['isopen_presale']:0;
            $data['presale_layout'] = isset($data['presale_layout']) ? $data['presale_layout']:0;

            D('Seller/Config')->update($data);

            show_json(1,  array('url' => $_SERVER['HTTP_REFERER']) );
            die();

        }

        $data = D('Seller/Config')->get_all_config();
        $this->data = $data;

        $this->display();
    }

    public function addgoods()
    {
        $_GET['goods_type'] = 'presale';

        $Goods_controller = A('Goods');

        $Goods_controller->addgoods();
    }

    public function edit()
    {
        $_GET['goods_type'] = 'presale';

        $Goods_controller = A('Goods');

        $Goods_controller->edit();
    }

    public function order()
    {
        $_GET['presale_order'] = '1';

        $Goods_controller = A('Order');

        $Goods_controller->index();
    }

    public function statistics()
    {
        $_GPC = I('request.');
        $pindex    = I('request.page', 1);
        $psize     = 20;
        //商品名称
        $keyword = I('get.keyword','','addslashes');
        $keyword2 = stripslashes($keyword);
        $this->keyword = $keyword2;

        $condition = " and og.cost_price is not NULL ";
        if (!empty($keyword)) {
            $condition .= " and og.name like '%".$keyword."%' ";
        }
        $starttime = strtotime( date('Y-m-d').' 00:00:00' );
        $endtime   = $starttime + 86400;
        $searchtime = $_GPC['searchtime'];


        if( !empty($searchtime) )
        {
            $starttime = isset($_GPC['time']['start']) ? strtotime($_GPC['time']['start']) : strtotime(date('Y-m-d'.' 00:00:00'));
            $endtime = isset($_GPC['time']['end']) ? strtotime($_GPC['time']['end']) : strtotime(date('Y-m-d'.' 23:59:59'));
            $condition .= " and op.presale_sendorder_datetime >= {$starttime} and op.presale_sendorder_datetime <= {$endtime} ";
        }else{
           // $condition .= " and op.presale_sendorder_datetime >= {$starttime} and op.presale_sendorder_datetime <= {$endtime} ";
        }
        $this->starttime = $starttime;
        $this->endtime = $endtime;
        $this->searchtime = $searchtime;



        $sql = " SELECT og.goods_id,og.order_id,og.name,og.rela_goodsoption_valueid,og.price,og.cost_price,SUM( og.quantity ) as quantity, "
            . " SUM( og.quantity * og.price ) as total_price,SUM( og.quantity * og.cost_price ) as cost_total_price,sum(og.profit_total) as profit_total "
            . " FROM ". C('DB_PREFIX'). "lionfish_comshop_order_presale as op "
            . " , ". C('DB_PREFIX'). "lionfish_comshop_order_goods as og "
            . " , ". C('DB_PREFIX'). "lionfish_comshop_order as o  "
            . " WHERE og.order_id = op.order_id and og.order_id=o.order_id and o.order_status_id in (1)  "
            . $condition . " group by og.goods_id, og.name, og.rela_goodsoption_valueid,og.price ";


        if( isset($_GPC['export']) && $_GPC['export'] == 1 )
        {
            $t_sql = " select * from ( " .$sql. " ) t "
                . " order by profit_total desc ";
            $list = M()->query($t_sql);
            $i = 1;
            foreach ($list as $k=>$v) {
                $list[$k]['rank'] = $i;
                $list[$k]['profit_fee'] = round($v['profit_total']/$v['total_price']*100,2);
                $order_goods_info = M('lionfish_comshop_order_goods')->where(array('goods_id'=>$v['goods_id'],'rela_goodsoption_valueid'=>$v['rela_goodsoption_valueid']))->find();
                $list[$k]['option_sku'] = D('Seller/Order')->get_order_option_sku($order_goods_info['order_id'], $order_goods_info['order_goods_id']);
                //商品名称
                /*$goods_info = M('lionfish_comshop_goods')->where(array('id'=>$v['goods_id']))->field('goodsname')->find();
                if(!empty($goods_info)){
                    $list[$k]['name'] = $goods_info['goodsname'];
                }*/
                $i++;
            }
            $columns = array(
                array('title' => '排名', 'field' => 'rank', 'width' => 32),
                array('title' => '商品名称', 'field' => 'name', 'width' => 32),
                array('title' => '规格', 'field' => 'option_sku', 'width' => 32),
                array('title' => '商城售价(元)', 'field' => 'price', 'width' => 32),
                //array('title' => '成本价(元)', 'field' => 'cost_price', 'width' => 32),
                array('title' => '商品销量', 'field' => 'quantity', 'width' => 32),
                //array('title' => '商品销量总价(元) ', 'field' => 'total_price', 'width' => 32),
                //array('title' => '商品销量成本总价(元)', 'field' => 'cost_total_price', 'width' => 32),
                //array('title' => '毛利额', 'field' => 'profit_total', 'width' => 32),
                //array('title' => '毛利率(%)', 'field' => 'profit_fee', 'width' => 32),
            );
            $data = array();
            foreach($list as $k=>$v){
                $tmp = array();
                $tmp['rank'] = $v['rank'];
                $tmp['name'] = $v['name'];
                $tmp['option_sku'] = $v['option_sku'];
                $tmp['price'] = $v['price'];
                //$tmp['cost_price'] = $v['cost_price'];
                $tmp['quantity'] = $v['quantity'];
               // $tmp['total_price'] = $v['total_price'];
                //$tmp['cost_total_price'] = $v['cost_total_price'];
               // $tmp['profit_total'] = $v['profit_total'];
               // $tmp['profit_fee'] = $v['profit_fee'];
                $data[] = $tmp;
            }
            $title = '预售统计';
            D('Seller/Excel')->export($data, array('title' => $title, 'columns' => $columns));
        }else{

            $t_sql = " select * from ( " .$sql. " ) t "
                . " order by profit_total desc limit " . (($pindex - 1) * $psize) . "," . $psize;

            $list = M()->query($t_sql);

            $total_list = M()->query("select count(1) as count from (".$sql.") as t");
            $total = $total_list[0]['count'];
            $pager = pagination2($total, $pindex, $psize);

            foreach($list as $k=>$v){
                $tmp = array();
                $tmp['rank'] = $v['rank'];
                $tmp['name'] = $v['name'];
                $tmp['option_sku'] = $v['option_sku'];
                $tmp['price'] = $v['price'];
                //$tmp['cost_price'] = $v['cost_price'];
                $tmp['quantity'] = $v['quantity'];
                // $tmp['total_price'] = $v['total_price'];
                //$tmp['cost_total_price'] = $v['cost_total_price'];
                // $tmp['profit_total'] = $v['profit_total'];
                // $tmp['profit_fee'] = $v['profit_fee'];
                $data[] = $tmp;
            }
            $this->list = $list;

            $this->all_quantity = !empty($all_list[0]['quantity']) ? $all_list[0]['quantity'] : 0;
            $this->all_total = !empty($all_list[0]['total_price']) ? $all_list[0]['total_price'] : 0;

            $this->pager = $pager;
            $this->gpc = $_GPC;
            $this->display();
        }
    }

    /**
     * @author yj
     * @desc 幻灯片
     */
    public function slider()
    {
        $_GPC = I('request.');

        $condition = ' and type="presale" ';
        $pindex    = max(1, intval($_GPC['page']));
        $psize     = 20;

        if (!empty($_GPC['keyword'])) {
            $_GPC['keyword'] = trim($_GPC['keyword']);
            $condition .= ' and advname like "%'.$_GPC['keyword'].'%"';
        }

        if (isset($_GPC['enabled']) && $_GPC['enabled'] >= 0) {
            $_GPC['enabled'] = trim($_GPC['enabled']);
            $condition .= ' and enabled = ' . $_GPC['enabled'];
        } else {
            $_GPC['enabled'] = -1;
        }

        $list = M()->query('SELECT id,advname,thumb,link,type,displayorder,enabled FROM ' . C('DB_PREFIX') . "lionfish_comshop_adv 
			WHERE 1  " . $condition . ' order by displayorder desc, id desc limit ' . (($pindex - 1) * $psize) . ',' . $psize);


        $total_arr = M()->query('SELECT count(1) as count FROM ' . C('DB_PREFIX'). 'lionfish_comshop_adv WHERE 1  ' . $condition );

        $total = $total_arr[0]['count'];

        $pager = pagination2($total, $pindex, $psize);

        $this->list = $list;
        $this->pager = $pager;
        $this->_GPC = $_GPC;

        include $this->display();
    }

    public function addslider()
    {

        $id = I('request.id');
        if (!empty($id)) {
            $item = M('lionfish_comshop_adv')->where( array('id' => $id) )->find();
            $this->item = $item;
        }

        if (IS_POST) {
            $data = I('request.data');

            D('Seller/Adv')->update($data ,'presale');
            show_json(1, array('url' => U('presale.slider') ));
        }

        $this->display();
    }

}
?>