﻿Ext.define('cubedrive.sheet.CONFIG', {	
	singleton : true,	
	constructor : function() {		
		this.callParent(arguments);		
        this.setupDir(parent.window.path + '/Plugins/');        
		Ext.apply(this, {
		    // please select one of the following currency code:
			//    'usd', 'rmb', 'eur', 'ars' , 'aud', 'brl', 'cad', 'clp', 'cop', 'dkk', 'hkd', 'isk', 'inr', 'idr', 'ils', 'jpy'		
			//	  'won', 'mxn', 'myr', 'nzd', 'nok', 'pln', 'rub', 'sar', 'sgd', 'zar', 'sek', 'chf', 'twd', 'try', 'gbp', 'afn'
			//    'bob', 'bgn', 'egp', 'ltl', 'vnd', 'uah', 'irr', 'huf', 'cup', 'ron', 'jmd', 'kzt', 'lbp', 'thb', 'ngn', 'zwd'
			//    'all', 
			default_currency: 'usd',			
			// Please select one of the following items:
			//       english_us, chinese
			default_locale: 'english_us',			
			// Please contact us for add more date, time format
            english_us_moreDateTimeFm: ['M d, Y, H:i:s', 'M d, Y, H:i', 'M d, Y, g:i:s A', 'l, M d, Y, g:i:s A', 'Y/m/d H:i', 'Y/m/d H:i:s'],
            chinese_moreDateTimeFm: ['Y\u5E74m\u6708j\u65E5', 'y\u5E74m\u6708j\u65E5', 'm\u6708j\u65E5', 'Y\u5E74m\u6708j\u65E5 G\u70B9i\u5206', 'Y\u5E74m\u6708j\u65E5 H\u70B9i\u5206', 'Y\u5E74m\u6708j\u65E5 G\u70B9i\u5206s\u79D2',
                                     'M d, Y, H:i:s', 'M d, Y, H:i', 'M d, Y, g:i:s A', 'l, M d, Y, g:i:s A', 'Y/m/d H:i', 'Y/m/d H:i:s'],                                     
            // set sheet tab bar position: top OR bottom
            sheet_tab_bar_position: 'top',            
            // set help menu hide or not: true or false - this is only work for commercial version
            help_menu_hide: false,             
            // hide or show language menu
            language_menu_hide: true,            
            // disable file menu if set as false
            file_menu_hide: true,            
            // disable import / export
            enableExport : false,
            enableImport : false,            
            // this flag is set to see whether it is standalone version - only js code
            js_standalone: true
		})
	},    
    setupDir : function(dir){
        Ext.apply(this, {
            baseDir: dir,                  
            IMAGES_PATH : dir+'eSheet/images',                     
            ICONS_PATH : dir+'eSheet/images/icons',                     
            urls: {
                'list': dir+'document/list',
                'changeFileName': dir+'document/changeFileName',
                'changeFileStared': dir+'document/changeFileStared',
                'createFile': dir+'document/createFile',
                'updateLang': dir + 'userSetting/updateLang',                     
                'findCells': dir+'eSheet/findCells',
                'loadCells': dir+'eSheet/loadCells',
                'loadSheet': dir+'eSheet/loadSheet',
                'loadActivedSheetOfFile': dir+'eSheet/loadActivedSheetOfFile',
                'loadSheetsOfFile': dir+'eSheet/loadSheetsOfFile',
                'loadCellOnDemand': dir+'eSheet/loadCellOnDemand',
                'loadCalCellOnDemand': dir+'eSheet/loadCalCellOnDemand',
                'loadFile': dir+'eSheet/loadFile',
                'copyFromTpl': dir+'eSheet/copyFromTpl',
                'importExcelUpload': dir+'eSheet/uploadFile',
                'exportExcel': dir+'eSheet/export',                     
                'update': dir+'sheetCell/updateBatchCells',
                'createSheet': dir+'sheetTab/create',
                'renameSheet': dir+'sheetTab/renameSheet',
                'changeSheetColor': dir+'sheetTab/changeSheetColor',
                'deleteSheet': dir+'sheetTab/deleteSheet',
                'copySheet': dir+'sheetTab/copySheet',
                'changeSheetOrder': dir+'sheetTab/changeSheetOrder',                     
                'listCustom': dir+'sheetCustom/list',
                'addCustom': dir+'sheetCustom/create',
                'deleteCustom': dir+'sheetCustom/delete',
                'listDataset': dir+'sheetDropdown/list',
                'createDataset': dir+'sheetDropdown/createUpdate',
                'loadDataset': dir+'sheetDropdown/load',
                'deleteDataset': dir+'sheetDropdown/delete',
                'saveJsonFile': dir+'sheetapi/saveJsonFile',
                'saveFileAs': dir+'eSheet/saveFileAs',
                'loadRange': dir+'eSheet/loadRange'
            }
        });
    }
}, function(){
	SCONFIG = cubedrive.sheet.CONFIG;	
});
