import os
import sys
import time
import glob
if sys.version_info >= (3, 0):
    from http.cookiejar import *
else:
    from cookielib import *
import tempfile
from ctypes import *
import re

needLogging = False
if needLogging:
    import logging
    log_file=r'/Users/admin/Desktop/123/1.log'
    logging.basicConfig(filename=log_file,level=logging.DEBUG)

def debugEx(obj):
    if needLogging:
        import logging
        logging.debug(obj)

debugEx(sys.path)
scriptPath = sys.path[0]
#print scriptPath
try:
    import json
except ImportError:
    import simplejson as json


if sys.platform == 'win32':
    debugEx('-------CDLL(sqlite3.dll)------------')
    debugEx(scriptPath)
    sys.path.insert(0, os.path.join(scriptPath, r'Cookies\win32crypt'))
    sys.path.insert(0, os.path.join(scriptPath, r'Cookies'))
    filePath = os.path.join(scriptPath, r'Cookies\sqlite\sqlite3.dll')
    debugEx(filePath)
    if os.path.isfile(filePath):
        if sys.version_info < (3, 0):
            CDLL(filePath)
        debugEx('load success')
    else:
        debugEx('load fail')

    import sqlite3
    debugEx(sqlite3.sqlite_version)
else:
    # for item in sys.path:
    #     if item.find('/MediaDownloader.bundle/') > -1:
    #         scriptPath = item
    # sys.path.insert(0, os.path.join(scriptPath, 'Cookies'))
    # try:
    #     import pysqlite2.dbapi2 as sqlite3
    # except ImportError:
    #     debugEx("Couldn't import module pysqlite2.dbapi2. try to import sqlite3\n")
    import sqlite3
    debugEx(sqlite3.sqlite_version)
debugEx('--------------------------------------------------------------')

if sys.platform == 'win32':
    try:
        import win32crypt
    except ImportError:
        debugEx("Couldn't import module 'win32crypt'; cookie decryption on Windows disabled.\n")
    debugEx('win32 --------------------------------------------------------------')


class BrowserCookieError(Exception):
    pass

def create_local_copy(cookie_file):
    """Make a local copy of the sqlite cookie database and return the new filename.
    This is necessary in case this database is still being written to while the user browses
    to avoid sqlite locking errors.
    """
    # check if cookie file exists
    if os.path.exists(cookie_file):
        from shutil import copyfile
        # copy to random name in tmp folder
        tmp_cookie_file = tempfile.NamedTemporaryFile(suffix='.sqlite').name
        copyfile(cookie_file, tmp_cookie_file)
        return tmp_cookie_file
    else:
        raise BrowserCookieError('Can not find cookie file at: ' + cookie_file)

class Chrome:
    tmp_cookie_file = None
    def __init__(self, cookie_file=None):
        salt = b'saltysalt'
        length = 16
        my_pass = None
        if sys.platform == 'win32':
            appdata = os.getenv('APPDATA')
            chromeDefaultPath = r'%s\..\Local\Google\Chrome\User Data\Default' % (appdata)
            cookie_file = '%s%s' % (chromeDefaultPath, '\cookies')

            if not os.path.isfile(cookie_file):
                chromeDefaultPath = r'%s\..\Local\Google\Chrome\User Data\Profile 1' % (appdata)
                cookie_file = '%s%s' % (chromeDefaultPath, '\cookies')

            if not os.path.isfile(cookie_file):
                appdata = os.getenv('USERPROFILE')
                chromeDefaultPath = r'%s\Local Settings\Application Data\Google\Chrome\User Data\Default' % (appdata)
                cookie_file = '%s%s' % (chromeDefaultPath, '\cookies')
        else:
            # 使用自带的 keyring 解决打包无法使用问题
            # "No recommended backend was available. Install the keyrings.alt package if you want to use the non-recommended backends. See README.rst for details."
            from .keyring import get_password
            # import keyring
            if sys.platform == 'darwin':
                cookie_file = cookie_file or os.path.expanduser('~/Library/Application Support/Google/Chrome/Default/Cookies')
                if not os.path.exists(cookie_file):
                    cookie_file = cookie_file or os.path.expanduser('~/Library/Application Support/Google/Chrome/Profile 1/Cookies')
                if os.path.exists(cookie_file):
                # running Chrome on OSX
                    my_pass = get_password('Chrome Safe Storage', 'Chrome')
                # my_pass = keyring.get_password('Chrome Safe Storage', 'Chrome')
                    my_pass = my_pass.encode('utf8')
                    iterations = 1003
                else:
                    raise Exception('not install chrome')
            elif sys.platform.startswith('linux'):
                # running Chrome on Linux
                my_pass = 'peanuts'.encode('utf8')
                iterations = 1
                cookie_file = cookie_file or os.path.expanduser('~/.config/google-chrome/Default/Cookies') or \
                                             os.path.expanduser('~/.config/chromium/Default/Cookies')
            if my_pass:
                from Crypto.Protocol.KDF import PBKDF2
                self.key = PBKDF2(my_pass, salt, length, iterations)
        debugEx(cookie_file)
        self.tmp_cookie_file = create_local_copy(cookie_file)

    def __del__(self):
        # remove temporary backup of sqlite cookie database
        os.remove(self.tmp_cookie_file)

    def __str__(self):
        return 'chrome'

    def load(self):
        """Load sqlite cookies into a cookiejar
        """
        con = sqlite3.connect(self.tmp_cookie_file)
        cur = con.cursor()
        try:
            cur.execute('SELECT host_key, path, secure, expires_utc, name, value, encrypted_value FROM cookies;')
        except:
            cur.execute('SELECT host_key, path, is_secure, expires_utc, name, value, encrypted_value FROM cookies;')
        cj = CookieJar()
        for item in cur.fetchall():
            try:
                host, path, secure, expires, name = item[:5]
                #if host.find('vimeo.com') == -1: continue
                value = self._decrypt(item[5], item[6])
                if not value: 
                    continue
                if isinstance(value, bytes):
                    value = value.decode('utf-8')
                c = create_cookie(host, path, secure, expires, name, value)
                cj.set_cookie(c)
            except Exception as ex:
                pass
        con.close()
        return cj
  
    def get_key_from_local_state(self):
        jsn = None
        with open(os.path.join(os.environ['LOCALAPPDATA'],
            r"Google\Chrome\User Data\Local State"),encoding='utf-8',mode ="r") as f:
            jsn = json.loads(str(f.readline()))
        return jsn["os_crypt"]["encrypted_key"]

    def aes_decrypt(self, encrypted_txt):
        if sys.platform != 'win32':
            return encrypted_txt
        import aesgcm 
        import base64
        encoded_key = self.get_key_from_local_state()
        encrypted_key = base64.b64decode(encoded_key.encode())
        #remove prefix 'DPAPI'
        encrypted_key = encrypted_key[5:]
        key = win32crypt.CryptUnprotectData(encrypted_key, None, None, None, 0)[1]
        #key = dpapi_decrypt(encrypted_key)
        #get nonce. ignore prefix 'v10', length is 12 bytes.
        nonce = encrypted_txt[3:15]
        cipher = aesgcm.get_cipher(key)
        return aesgcm.decrypt(cipher,encrypted_txt[15:],nonce)[:-16].decode()   

    def chrome_decrypt(self, value, encrypted_value):
        from Crypto.Cipher import AES
        if value or (encrypted_value[:3] != b'v10'):
            return value

        # Encrypted cookies should be prefixed with 'v10' according to the
        # Chromium code. Strip it off.
        encrypted_value = encrypted_value[3:]

        # Strip padding by taking off number indicated by padding
        # eg if last is '\x0e' then ord('\x0e') == 14, so take off 14.
        # You'll need to change this function to use ord() for python2.
        def clean(x):
            last = x[-1]
            if isinstance(last, int):
                return x[:-last].decode('utf-8')
            else:
                return x[:-ord(last)].decode('utf-8')

        iv = b' ' * 16
        cipher = AES.new(self.key, AES.MODE_CBC, IV=iv)
        decrypted = cipher.decrypt(encrypted_value)
        return clean(decrypted)

    def _decrypt(self, value, encrypted_value):
        if sys.platform == 'win32':
            try:
                if encrypted_value[:3] == b'v10':
                    return self.aes_decrypt(encrypted_value)                
                else:
                    return win32crypt.CryptUnprotectData(encrypted_value, None, None, None, 0)[1]
            except Exception as ex:
                print('-----------------------------------------')
                print(ex)

                print('-----------------------------------------')                
                return "<encrypted>"
        else:
            return self.chrome_decrypt(value, encrypted_value)


class Firefox:
    tmp_cookie_file = None

    def __init__(self, cookie_file=None):
        cookie_file = cookie_file or self.find_cookie_file()
        self.tmp_cookie_file = create_local_copy(cookie_file)
        # current sessions are saved in sessionstore.js
        self.session_file = os.path.join(os.path.dirname(cookie_file), 'sessionstore.js')
        self.new_session_file = os.path.join(os.path.dirname(cookie_file), 'sessionstore-backups', 'recovery.jsonlz4')
        self.session_file2 = os.path.join(os.path.dirname(cookie_file), 'sessionstore.jsonlz4')

    def __del__(self):
        # remove temporary backup of sqlite cookie database
        os.remove(self.tmp_cookie_file)

    def __str__(self):
        return 'firefox'


    def find_cookie_file(self):
        if sys.platform == 'darwin':
            cookie_files = glob.glob(os.path.expanduser('~/Library/Application Support/Firefox/Profiles/*.default*/cookies.sqlite'))
        elif sys.platform.startswith('linux'):
            cookie_files = glob.glob(os.path.expanduser('~/.mozilla/firefox/*.default*/cookies.sqlite'))
        elif sys.platform == 'win32':
            cookie_files = glob.glob(os.path.join(os.getenv('PROGRAMFILES', ''), 'Mozilla Firefox/profile/cookies.sqlite')) or \
                           glob.glob(os.path.join(os.getenv('PROGRAMFILES(X86)', ''), 'Mozilla Firefox/profile/cookies.sqlite')) or \
                           glob.glob(os.path.join(os.getenv('APPDATA', ''), 'Mozilla/Firefox/Profiles/*.default/cookies.sqlite'))
            print(os.path.join(os.getenv('APPDATA', '')))
            if (len(cookie_files)>1) or not cookie_files:
                config = glob.glob(os.path.join(os.getenv('APPDATA', ''), 'Mozilla/Firefox/profiles.ini'))
                import configparser
                cf = configparser.ConfigParser()
                cf.read(config)
                sections = cf.sections()
                
                Profiles = [section for section in sections if section.find('Install')>-1]
                
                if Profiles:
                    cookie_files = glob.glob(os.path.join(os.getenv('APPDATA', ''), 'Mozilla/Firefox/%s/cookies.sqlite' % cf.get(Profiles[0], 'Default')))                    

                if (not cookie_files) or (not os.path.exists(cookie_files[0])):
                    Profiles = [section for section in sections if section.find('Profile')>-1]
                    print(Profiles)
                    for Profile in Profiles:
                        if cf.get(Profile, 'Default') == '1':
                            cookie_files = glob.glob(os.path.join(os.getenv('APPDATA', ''), 'Mozilla/Firefox/%s/cookies.sqlite' % cf.get(Profile, 'Path')))
                            break
                    print(cookie_files)
        else:
            raise BrowserCookieError('Unsupported operating system: ' + sys.platform)
        if cookie_files:
            return cookie_files[0]
        else:
            raise BrowserCookieError('Failed to find Firefox cookie')

    def extreactSessionCookie(self, sessionFile, cj):
      try:
        import lz4.block
        in_file = open(sessionFile, "rb")
        data = lz4.block.decompress(in_file.read()) if in_file.read(8) == b"mozLz40\0" else b'{}'
        in_file.close()
        jsonData = json.loads(data.decode('utf-8'))
        cookies = jsonData.get('cookies', {})
        expires = str(int(time.time()) + 3600 * 24 * 7)
        
        for cookie in cookies:
          c = create_cookie(cookie.get('host', ''), cookie.get('path', ''), False, expires, cookie.get('name', ''), cookie.get('value', ''))
          cj.set_cookie(c)      
      except Exception as ex:
        print(ex)


    def load(self):
        print('firefox', self.tmp_cookie_file)
        cj = CookieJar()
        try:
            con = sqlite3.connect(self.tmp_cookie_file)
            cur = con.cursor()
            cur.execute('select host, path, isSecure, expiry, name, value from moz_cookies')

            for item in cur.fetchall():
                c = create_cookie(*item)
                cj.set_cookie(c)
            con.close()
        except Exception as e:
            debugEx(e)

        if os.path.exists(self.session_file):
            try:
                json_data = json.loads(open(self.session_file, 'rb').read())
            except ValueError as e:
                debugEx('Error parsing firefox session JSON: %s' % str(e))
            else:
                expires = str(int(time.time()) + 3600 * 24 * 7)
                for window in json_data.get('windows', []):
                    for cookie in window.get('cookies', []):
                        c = create_cookie(cookie.get('host', ''), cookie.get('path', ''), False, expires, cookie.get('name', ''), cookie.get('value', ''))
                        cj.set_cookie(c)
        elif os.path.exists(self.new_session_file):
            print(self.new_session_file)
            self.extreactSessionCookie(self.new_session_file, cj)
        elif os.path.exists(self.session_file2):
            print(self.session_file2)
            self.extreactSessionCookie(self.session_file2, cj)
        else:
            print('Firefox session filename does not exist: %s' % self.session_file)

        return cj

class Safari:
    def __init__(self, cookie_file=None):
        import logging
        # Logger setup
        self.log = logging.getLogger(__name__)
        self.log.setLevel(logging.WARNING)

        handler = logging.StreamHandler()
        handler.setFormatter(logging.Formatter('%(levelname)s: %(message)s'))

        self.log.addHandler(handler)
        if sys.platform == 'win32':
            self.cookie_file = cookie_file or (os.path.join(os.getenv('APPDATA', ''), 'Apple Computer\Safari\Cookies\Cookies.binarycookies'))
        else:
            self.cookie_file = cookie_file or os.path.expanduser('~/Library/Cookies/Cookies.binarycookies')

    def load(self):
        from io import BytesIO
        from struct import pack, unpack
        cj = CookieJar()
        file = open(self.cookie_file, 'rb')
        try:
            cookies = []

            self.log.info('Parsing %s', file.name)

            # File Magic String:cook
            magic = file.read(4)

            if magic != b'cook':
                self.log.exception('File is not a binary cookie valid format')
                return cookies

            # Number of pages in the binary file: 4 bytes
            num_pages = unpack('>i', file.read(4))[0]

            # Each page size: 4 bytes * number of pages
            page_sizes = []
            for _ in range(num_pages):
                page_sizes.append(unpack('>i', file.read(4))[0])

            # Grab individual pages and each page will contain >= one cookie
            pages = []
            for ps in page_sizes:
                pages.append(file.read(ps))

            # page header: 4 bytes: Always 00000100.
            # Number of cookies in each page,
            # first 4 bytes after the page header in every page.
            for page in pages:
                page = BytesIO(page)
                page.read(4)
                num_cookies = unpack('<i', page.read(4))[0]

                # Every page contains >= one cookie.
                # Fetch cookie starting point from page starting byte
                cookie_offsets = []
                for _ in range(num_cookies):
                    cookie_offsets.append(unpack('<i', page.read(4))[0])

                # end of page header: Always 00000000
                page.read(4)

                for offset in cookie_offsets:
                    content = {}

                    # Move the page pointer to the cookie starting point
                    # fetch cookie size
                    # read the complete cookie
                    page.seek(offset)
                    content['size'] = unpack('<i', page.read(4))[0]
                    cookie = BytesIO(page.read(content['size']))

                    # Unknown 4 null bytes
                    cookie.read(4)

                    # Flags
                    content['flags'] = unpack('<i', cookie.read(4))[0]

                    # Unknown 4 null bytes
                    cookie.read(4)

                    if sys.platform == 'win32':
                        keys = ('name', 'value', 'domain', 'path')
                    else:
                        keys = ('domain', 'name', 'path', 'value')
                    for key in keys:
                        content[key + '_offset'] = unpack('<i', cookie.read(4))[0]

                    # End of cookie
                    cookie.read(8)

                    # Date is in Mac epoch format: starts from 1/Jan/2001
                    content['expiry_date'] = unpack('<d', cookie.read(8))[0]
                    content['creation_date'] = unpack('<d', cookie.read(8))[0]

                    # fetch values

                    for i in keys:
                        n = cookie.read(1)
                        value = []
                        while unpack('<b', n)[0] != 0:
                            value.append(n.decode('utf8'))
                            n = cookie.read(1)
                        content[i] = ''.join(value)
                    cookies.append(content)
                    cj.set_cookie(create_cookie(content['domain'], content['path'], content['flags'], content['expiry_date'], content['name'], content['value']))
            return cj
        finally:
            file.close()

class IE():
    def __init__(self, cookie_file=None):
        pass

    def load(self):
        def get_cookiedir():
            if sys.version_info >= (3, 0):
                import winreg
            else:
                import _winreg as winreg
            path = r'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders'
            with winreg.OpenKey(winreg.HKEY_CURRENT_USER, path) as key:
                return winreg.QueryValueEx(key, 'Cookies')[0]
        cj = CookieJar()
        pattern = '*.txt'
        dirname = get_cookiedir()
        files = glob.glob(os.path.join(dirname, pattern))
        files += glob.glob(os.path.join(dirname, 'Low', pattern))
        for fname in files:
            with open(fname) as fp:
                for chunk in zip(*[fp] * 9):
                    name = chunk[0][:-1]
                    value = chunk[1][:-1]
                    host, path = chunk[2][:-1].split('/', 1)
                    path = '/' + path
                    flag = int(chunk[3])
                    secure = bool(flag & 1)
                    expires_nt = (int(chunk[5]) << 32) + int(chunk[4])
                    expires = expires_nt / 10000000 - 11644473600
                    c = create_cookie(host, path, secure, expires, name, value)
                    cj.set_cookie(c)
        return cj

def create_cookie(host, path, secure, expires, name, value):
    return Cookie(0, name, value, None, False, host, host.startswith('.'), host.startswith('.'), path, True, secure, expires, False, None, None, {})


class CookiesJar:

    def getCookies(self, domain, browser):
        def formatResult(cookies, domain):
            result = ''
            for key in cookies:
                if re.search(domain, key):
                    c = cookies[key]
                    for sd in c:
                        for k in c[sd]:
                            try:
                                v = c[sd][k].value
                                str = '%s=%s;' % (k, v)
                                result = '%s%s' % (result, str)
                            except Exception as e:
                                #logging.debug(str(e))
                                pass
                    #result = '%s%s' % (result, reduce((lambda x, y: x + y), ('%s=%s;' % (k, c[sd][k].value) for sd in c for k in c[sd])))
            return result

        # url = re.sub(r'http://|https://', '', url)
        # list = url.split('/')[0].split('.')
        # domain = '%s.%s' % (list[-2], list[-1])
        result = ''
        try:
            if browser == 'chrome':
                c = Chrome()
            elif browser == 'firefox':
                c = Firefox()
            elif browser == 'IE':
                c = IE()
            else:
                c = Safari()
            cj = c.load()
            if cj:
                result = formatResult(cj._cookies, domain)
            else:
                result = ''
            return result
        except Exception as e:
            print(e)
            return ''
            #logging.debug(str(cj))
            #logging.exception("exception")


def createInstance(className):
    if className == 'CookiesJar':
        return CookiesJar()


if __name__ == "__main__":
    debugEx('--------------IE--------------------------')
    #debugEx(createInstance('CookiesJar').getCookies('www.facebook.com', 'IE'))
    debugEx('--------------chrome--------------------------')
    #debugEx(createInstance('CookiesJar').getCookies('https://www.youtube.com/', 'chrome'))
    debugEx('--------------firefox--------------------------')
    debugEx(createInstance('CookiesJar').getCookies('https://vimeo.com/138676914', 'firefox'))
    debugEx('--------------Safari-------------------------')
    #debugEx(createInstance('CookiesJar').getCookies('https://vimeo.com/138676914', 'Safari'))