# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
# 2017-10-18 win下加入import win_subprocess，以使Popen()支持unicode字串
# 2018-01-07 音视频分离者先下视频，因为验证YouTube视频下载速度远大于音频，传于界面显示好看些
from __future__ import unicode_literals

import os, sys
import re
import shutil
import traceback
import threading
import gaid
from youtube_dl.downloader.http import HttpFD, HttpNeedQueryRedirectFD
from youtube_dl.downloader.hls import HlsFD
from youtube_dl.downloader.M3u8Downloader import FFmpegFD as FFmpegFDEx
from youtube_dl.downloader.OldM3u8Downloader import WSM3u8FD as WSM3u8FD
from youtube_dl.downloader.external import FFmpegFD
from youtube_dl.downloader.httpCrul import HttpCurl
from youtube_dl.downloader.http_hb import HttpHB
if sys.platform == 'win32':
    from youtube_dl.downloader.chrome_downloader import powtoonDownloader
from youtube_dl.utilsEX import (
    get_top_host,
    sleep,
    GoogleAnalytics,
    sandboxEnable
)

import youtube_dl
from youtube_dl.compat import (
    compat_str,
)
from youtube_dl.WS_Extractor import (
    YoutubeDLPatch4Single
)
try:
    from urllib.parse import urlparse
except ImportError:
    from urlparse import urlparse



class downloader:
    def buildOptions(self, verbose=False):
        ydl_opts = {}
        ydl_opts['debug_printtraffic'] = self._infos['url'].find('www.edddh.com')==-1
        ydl_opts['playlistend'] =  1
        #ydl_opts['socket_timeout'] = 600
        #2017.08.10
        if not sandboxEnable():
            ydl_opts['source_address'] = '0.0.0.0'
        ydl_opts['verbose'] = 1
        ydl_opts['continuedl'] = 1
        ydl_opts['nopart'] = True
        ydl_opts['skip_unavailable_fragments'] = self._infos['url'].find('bbc.co.uk')!=-1
        ydl_opts['fragment_retries']  = 10
        ffmpeg_name = os.getenv('KVFfmpegPath')
        if ffmpeg_name is None:
            debug('get KVFfmpegPath failed')
            debug('Try Get KVFfmpegPath Begin----------------------------------------------------')
            if sys.platform == 'win32':
                ffmpeg_name = r'DownloadRes\ffmpeg.exe' if os.path.exists(r'DownloadRes\ffmpeg.exe') else 'ffmpeg.exe'
            else:
                ffmpeg_name = 'ffmpeg'
            try:
                # 日文路径，os.path.join(os.path.abspath(os.curdir), ffmpeg_name)会出异常，所以用相对路径置之
                try:
                    ydl_opts['ffmpeg_location'] = os.path.join(os.path.abspath(os.curdir), ffmpeg_name)
                except:
                    ydl_opts['ffmpeg_location'] = ffmpeg_name

                if not os.path.exists(ydl_opts['ffmpeg_location']):
                    debug('_file__Begin')
                    debug(__file__)
                    ydl_opts['ffmpeg_location'] = os.path.join(os.path.abspath(os.path.dirname(__file__)), ffmpeg_name)
                    debug('_file__End')
                debug(ydl_opts['ffmpeg_location'])
            except:
                pass
            debug('Try Get KVFfmpegPath End----------------------------------------------------')
        else:
            debug('get KVFfmpegPath:' + ffmpeg_name)
            ydl_opts['ffmpeg_location'] = ffmpeg_name
        return ydl_opts

    def __init__(self, callback, infos):
        self._callback = callback
        self._imageSavePath = infos['imageSavePath']
        self._infos = infos
        self._cancel = False
        self._subtitleFile = ''
        self._downloadingFile = ''
        self._ydl = YoutubeDLPatch4Single(self.buildOptions(False))
        self._GA = GoogleAnalytics(gaid.ga2)        

    #下载进度回调钩子
    def progress_hook(self, s):
        if self._cancel:
            raise Exception('cancel')

        if self.downloadThumbailAndIcon:
            return

        def safeGetValue(dict, key, default):
            value = dict.get(key, default)
            return  value if value else default

        if s['status'] == 'downloading':
            downloaded_bytes = safeGetValue(s, 'downloaded_bytes', 0)
            total_bytes = safeGetValue(s, 'total_bytes', 0) if ('total_bytes' in s) else  safeGetValue(s, 'total_bytes_estimate', 0)
            self._infos['downloadingFiles'][self._downloadingFile]['downloadedSize'] = downloaded_bytes
            total_bytes = total_bytes if total_bytes else 1024 * 1024 * 1024 * 2
            if total_bytes < (downloaded_bytes-1024):
                print('total_bytes < downloaded_bytes total_bytes：%d downloaded_bytes：%d' % (total_bytes, downloaded_bytes))
                total_bytes = downloaded_bytes + 50 * 1024 * 1024
            self._infos['downloadingFiles'][self._downloadingFile]['fileSize'] = total_bytes
            downloaded_bytes = total_bytes = 0
            for item in self._infos['downloadingFiles'].values():
                downloaded_bytes += safeGetValue(item, 'downloadedSize', 0)
                total_bytes += safeGetValue(item, 'fileSize', 0)

            msg = {
                'event': 'downloading',
                'fileSize': total_bytes,
                'downloadedSize': downloaded_bytes,
            }

            if s.get('speed', None):
                msg['speed'] = s['speed']

            if self._callback:
                self._callback(msg)

    def testDownloader(self, func, info, fileName = None):
        if fileName:
            self.downloaderTestResult = func(info, fileName)
        else:
            self.downloaderTestResult = func(info)


    #真实下载
    def get_suitable_downloader(self, filename, info):
        params = self._ydl.params
        if info.get('SpecialDownloader', None) and (sys.platform == 'win32'):
            fd = powtoonDownloader(self._ydl, params)
            fd.merge_WEBM = self.merge4Powtoon
        else:
            fd = youtube_dl.downloader.get_suitable_downloader(info, {})(self._ydl, params)
        if type(fd) == HttpFD and (not info.get('decryptMethod', None)):            
            #如果目标路径下存在该文件那么说明使用的是httpFD
            if not os.path.exists(filename):
                debug('-----------------------Test HttpCurl------------------')
                hc = HttpCurl(self._ydl, params)
                self.downloaderTestResult = False
                t = threading.Thread(target=self.testDownloader, args=(hc.testUrl, info))
                t.start()
                t.join(10)
                if self.downloaderTestResult:
                    fd = hc
                    if self._infos.get('speedUp', 'False') == 'True':
                        fd.openSpeedup()
                debug('-----------------------Test HttpCurl %s------------------' % ('success' if type(fd) ==HttpCurl else 'fail'))
            #需要心跳指令
            if 'heartbeat_url' in info:
                fd = HttpHB(self._ydl, params)
        elif type(fd) == HttpFD and info.get('decryptMethod', None) and info.get('needQueryRedirect', False):   
            fd = HttpNeedQueryRedirectFD(self._ydl, params)
        elif type(fd) in [FFmpegFD, HlsFD]:
            if self._infos.get('url', '').find('youku') > -1 or self._infos.get('url', '').find('tudou') > -1 or \
                self._infos.get('url', '').find('iview.abc.net.au')>-1 or \
                    self._infos.get('url', '').find('fox.com')>-1 or \
                    self._infos.get('url', '').find('nbc.com')>-1 or \
                    self._infos.get('url', '').find('vrt.be') > -1 or \
                    self._infos.get('url', '').find('51cto.com') > -1 or \
                    self._infos.get('url', '').find('imooc.com') > -1 or \
                    self._infos.get('url', '').find('gaia.com') > -1 or \
                    self._infos.get('url', '').find('twitch.tv')>-1 or \
                    self._infos.get('url', '').find('bbc.co.uk') > -1 or \
                    self._infos.get('url', '').find('crunchyroll.com')>-1 or \
                    self._infos.get('url', '').find('viki.com')>-1 or \
                    self._infos.get('url', '').find('zee5.com')>-1 or \
                    self._infos.get('url', '').find('tlc.com')>-1: #or self._infos.get('url', '').find('fox.com')>-1:
                return HlsFD(self._ydl, params)
            try:
                if 'http_headers' in info and info['http_headers'] and 'Accept-Encoding' in info['http_headers']:
                    info['http_headers'].pop('Accept-Encoding')
            except:
                pass
            debug('-----------------------Select M3u8 Download Begin------------------')
            if self._infos.get('url', '').find('gem.cbc.ca') > -1:                
                return FFmpegFDEx(self._ydl, params)         
            #目标下存在DS后缀的同名文件，且文件大小大于20K，那么就直接使用WSM3u8FD
            tempFileName = '%s.ds' % filename
            if os.path.exists(tempFileName) and os.path.getsize(tempFileName) > 1024 * 20:
                debug('-----------------------Select M3u8 Download Use WSM3u8FD------------------')
                dl = WSM3u8FD(self._ydl, params)

            elif os.path.exists(filename):
                debug('-----------------------Select M3u8 Download Use FFmpegFDEx------------------')
                #或者如果存在不包含DS的目标文件，那么说明使用了FFMEPG
                dl = FFmpegFDEx(self._ydl, params)
            else:
                debug('-----------------------Test WSM3u8FD------------------')
                dl = WSM3u8FD(self._ydl, params)
                if not dl.testUrl(filename, info):
                    dl = None
                debug('-----------------------Test WSM3u8FD %s------------------' % ('success' if dl else 'fail'))
                if not dl:
                    dl = FFmpegFDEx(self._ydl, params)

            debug('-----------------------Select M3u8 Download End------------------')
            fd = dl
        debug(fd)
        return fd

    def _beforeDownload(self, filename, info):
        debug('_download begin %s' % filename)
        debug('......info......')
        debug(info)
        debug('......info......')
        if type(filename) != compat_str:
            try:
                filename = unicode(filename)
            except:
                filename = filename.decode('utf-8')
        if not os.path.exists(os.path.dirname(filename)):
            os.makedirs(os.path.dirname(filename))
        return filename

    def _download(self, filename, info):
        filename = self._beforeDownload(filename, info)
        if type(info) is not dict:
            info = eval(info)
            #'protocol': 'http_dash_segments',
        url = self._infos.get('url', None)
        host = get_top_host(url) if url else ''
        for i in range(3):
            try:
                debug('downloader.py _download try %d' % i)
                if 'fragments' in info:
                    info['protocol'] = 'http_dash_segments'
                fd = self.get_suitable_downloader(filename, info)
                fd.add_progress_hook(self.progress_hook)
                if fd.download(filename, info):
                    try:
                        url = self._infos.get('url', None)
                        url = get_top_host(url) if url else ''
                        
                    except:
                        pass
                    break
                else:
                    raise Exception('downloadFail')
            except:
                if self._cancel:
                    break
                debug(traceback.format_exc())
                if i == 2:
                    raise Exception(traceback.format_exc())
                else:
                    sleep(1)
        debug('_download end')

    def downloadSubtitle(self):
        try:
            if ('subtitleUrl' not in self._infos  or self._infos.get('subtitleUrl', None) == None):
                if ('subtitle_data' not in self._infos or self._infos.get('subtitle_data', None) == None):
                    return

            self._subtitleFile = os.path.join(self._downloadtempPath, '%s.srt' % self._infos['fileNameWithoutExt'])
            if os.path.exists(self._subtitleFile):
                return

            if 'subtitleUrl' in self._infos:
                subtitleUrl = self._infos.get('subtitleUrl')
                from sniffer import (
                    YoutubeSubtitle
                )
                s = YoutubeSubtitle(self._ydl).getSubtitleContent(subtitleUrl)
            else:
                s = self._infos['subtitle_data']

            if s != '':
                f = open(self._subtitleFile, 'wb')
                if sys.version_info >= (3, 0) and isinstance(s, str):
                    s = s.encode('utf-8')
                f.write(s)
                f.close()

            if os.path.exists(self._subtitleFile):
                msg = {
                    'event':'download_Subtitle',
                    'filePath': self._subtitleFile
                }
                if self._callback:
                    self._callback(msg)
        except Exception as e:
            print(e)
            pass

    def downloadWebSiteIcon(self, url, savePath):
        if url == '':
            return
        if os.getenv('SkipThumbnailAndIco'):
            return            
        old = self._ydl._socket_timeout
        debug('downloadWebSiteIcon begin')
        try:
            if (not re.search(r'//', url)):
                url = 'http://' + url
            o = urlparse(url)
            fileName = os.path.join(savePath, '%s.ico' % o.netloc)
            if not os.path.exists(fileName):
                
                self._ydl._socket_timeout = 10                 
                webpage = self._ydl.urlopen(url).read().decode('utf-8')
                mobj = re.search(r'<link rel="shortcut icon"\s*href="([^\"]+)"', webpage)
                faviconURL = ''
                if mobj:
                    faviconURL = mobj.group(1)

                    if (not re.search(r'//', faviconURL)):
                        if faviconURL.find(r'/') == 0:
                            faviconURL = 'http://'+ o.netloc + faviconURL
                        else:
                            faviconURL = 'http://' + faviconURL

                if not os.path.exists(fileName) and faviconURL != '':
                    info = {'url':faviconURL}
                    self._downloadSmallFile(fileName, info)

                if not os.path.exists(fileName):
                    faviconURL = '%s://%s/favicon.ico' % (o.scheme, o.netloc)
                    self._downloadSmallFile(faviconURL, fileName)

            if os.path.exists(fileName):
                msg = {
                    'event':'download_icon',
                    'filePath': fileName
                }
                if self._callback:
                    self._callback(msg)
        except:
            debug(traceback.format_exc())
            pass
        finally:
            self._ydl._socket_timeout = old   
        debug('downloadWebSiteIcon end')

    def downloadThumbnail(self, url, fileName):
        debug('downloadThumbnail begin')
        try:
            # 置位，以便于ffmpeg获取
            self._infos['thumbnail_filename'] = fileName
            if not url or url == '':
                return

            if os.getenv('SkipThumbnailAndIco'):
                return                
                
            if not os.path.exists(fileName):
                self._downloadSmallFile(url, fileName)

            if os.path.exists(fileName):
                msg = {
                    'event':'download_thumbnail',
                    'filePath': fileName
                }
                if self._callback:
                    self._callback(msg)
        except:
            debug(traceback.format_exc())
            pass
        debug('downloadThumbnail end')


    def downloadThumbnailAndIcon(self, title):
        self.downloadThumbailAndIcon = True
        try:
            self.downloadWebSiteIcon(self._infos.get('url'), self._infos['imageSavePath'])
            thumbnailFilename = os.path.join(self._infos['imageSavePath'], '%s.jpg' % title)
            self.downloadThumbnail(self._infos.get('thumbnail', ''), thumbnailFilename)
        except:
            pass
        finally:
            self.downloadThumbailAndIcon = False

    def _downloadSmallFile(self, url, filename):
        debug('begin _downloadSmallFile')
        try:
            if not os.path.exists(os.path.dirname(filename)):
                os.makedirs(os.path.dirname(filename))
            for proto in ['http', 'https']:
                if re.match(r'http', url):
                    tempUrl = url
                else:
                    if re.match(r'://', url):
                        tempUrl = '%s%s' % (proto , url)
                    elif re.match(r'//', url):
                        tempUrl = '%s:%s' % (proto , url)
                    else:
                        tempUrl = '%s://%s' % (proto , url)
                try:
                    webpage = self._ydl.urlopen(tempUrl).read()
                    f = open(filename, 'wb')
                    f.write(webpage)
                    f.close()
                    debug('end _downloadSmallFile Sucess')
                    break
                except Exception as e:
                    if re.match(r'http', url):#原来就有http头的就不要重试了
                        raise e
                    else:
                        debug(e)
        except Exception as e:
            debug('end _downloadSmallFile fail Exception:')
            debug(e)

    def prepareData(self):
        # 准备路径
        downloadtempPath = self._infos.get('downloadTempPath')
        if not os.path.exists(downloadtempPath):
            os.makedirs(downloadtempPath)

        self._downloadtempPath = downloadtempPath
        #开始下载
        if not self._infos.get('downloadingFiles'):
            fileName = '%s.%s' % (self._infos['fileNameWithoutExt'], self._infos['ext'])
            self._infos['destFileName'] = os.path.join(self._infos.get('downloadDestPath'), fileName)
            downloadFiles = {}
            for i, item in enumerate(self._infos['formats']):
                template = '%d.%s'
                fileName = os.path.join(downloadtempPath, template % (i, item['ext']))
                downloadFiles[fileName] = {'downloadedSize': 0, 'fileSize': item.get('filesize', 0), 'format': item, 'order': i}
            self._infos['downloadingFiles'] = downloadFiles
            self._infos.pop('formats')

            msg = {
                'event': 'download_start',
                'quality': self._infos.get('quality'),
                'data': self._infos
            }

            if self._callback:
                self._callback(msg)

    def fix_dest_filename(self):
        if os.path.exists(self._infos['destFileName']):
            for i in range(100):
                fileName = '%s(%d).%s' % (self._infos['fileNameWithoutExt'], i, self._infos['ext'])
                destfileName = os.path.join(self._infos.get('downloadDestPath'), fileName)
                if not os.path.exists(destfileName) or i == 99:
                    self._infos['destFileName'] = destfileName
                    break

    def fixModifyTime(self, fileName):
        if sys.platform == 'win32':
            fixFileTimeInfo = self._ydl.params['ffmpeg_location'].replace('ffmpeg.exe', 'fixFileTimeInfo.exe')
            try:
                subprocess.Popen([fixFileTimeInfo, fileName], startupinfo=get_startinfo())
            except Exception as e:
                debug(e)                

    def move_to_dest(self, source):
        debug('Copy file to dest dir!')
        try:
            # 拷贝字幕
            if os.path.exists(self._subtitleFile):
                subtitle_ext = os.path.splitext(self._subtitleFile)[1]
                dst_subtitle = os.path.splitext(self._infos['destFileName'])[0] + subtitle_ext
                try:
                    debug('Move Subtitle to Dest Begin...')
                    os.rename(self._subtitleFile, dst_subtitle)
                    debug('Move Subtitle to Dest End')
                except WindowsError as e:
                    debug('Move Subtitle to Dest Fail: ' + str(e) + ', Use Copy Command')
                    # 源文件占用，调用系统copy命令继续
                    if e.winerror == 32:
                        copy = 'copy' if sys.platform == 'win32' else 'cp'
                        os.system('%s "%s" "%s"' % (copy, self._subtitleFile, dst_subtitle))
                    else:
                        pass
            # copy视频
            self.fix_dest_filename()
            os.chdir(os.path.dirname(source))
            dest = self._infos['destFileName']
            # 它会有资源占用可能，原因未知，比如：https://www.bbc.co.uk/iplayer/episode/b0bs47xf/top-of-the-pops-18091986 其下载后，文件被python.exe占用
            try:
                os.rename(source, dest)
            except WindowsError as e:
                debug('Move File to Dest Fail: ' + str(e) + ', Use Copy Command')
                # 源文件占用，调用系统copy命令继续
                if e.winerror == 32:
                    copy = 'copy' if sys.platform == 'win32' else 'cp'
                    os.system('%s "%s" "%s"' % (copy, source, dest))
                else:
                    raise e
            self.fixModifyTime(dest)
            sleep(2)
        except Exception as e:
            debug(e)
        try:
            shutil.rmtree(self._infos.get('downloadTempPath'))
        except:
            pass

    def run(self):
        try:
            self.prepareData()
            debug('downloadSubtitle')
            self.downloadSubtitle()
            debug('downloadThumbnailAndIcon')
            self.downloadThumbnailAndIcon(self._infos['fileNameWithoutExt'])
            # YouTube视频下载快于音频10倍，若先下载音频，用户感觉慢，因此给视频提前，感觉上下载快些
            src_medias = sorted(self._infos['downloadingFiles'].items(), key=lambda item: item[1]['order'])
            for key, value in src_medias:
                if self._cancel:
                    raise Exception('download cancel.')
                   
                self._downloadingFile = key
                self._download(key, value['format'])
            if self._cancel:
                raise Exception('download cancel.')

            # 传与界面，需要原始顺序
            src_files = [item[0] for item in src_medias]
            msg = {
                'event': 'download_complete',
                'sourceFiles': src_files, #文件名
                'destFile': self._infos['destFileName'],
                'nextAction':  self._infos.get('action', 'none'), # 应用层在下载完成之后需要响应的行为包括:"dash_merge(音视频合并), multi_video_merge（多段合并）, convert_to_mp3（转换成mp3）, none(不需要其他附加行为)"
                'thumbnail': self._infos['thumbnail_filename'] if os.path.exists(self._infos['thumbnail_filename']) else ''
            }

            if os.path.exists(self._subtitleFile):
                msg['subtitle'] =  self._subtitleFile,
            debug('------------------download complete-------------------')
            debug(msg)
            debug('------------------download complete-------------------')

            # mac系统，沿用旧逻辑
            if sys.platform != 'win32':
                # 正常结束，不需要额外工作
                if self._infos.get('action', 'none') == 'none':
                    self.move_to_dest(list(self._infos['downloadingFiles'].keys())[0])
                    msg['destFile'] = self._infos['destFileName']
                elif self._infos.get('action', 'none') in ['dash_convert']:
                    debug('------------------download dash_convert Begin-------------------')
                    self.dash_merge_WEBM()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
                    debug('------------------download dash_convert End-------------------')
                elif self._infos.get('action', 'none') in ['fixM3u8']:
                    # 先发消息给产品，以更新其界面显示
                    if self._callback:
                        msg['nextAction'] = 'convert_progress'
                        self._callback(msg)
                    debug('------------------FFmpeg fixup m3u8 start-------------------')
                    self.fixup_m3u8()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
                    debug('------------------FFmpeg fixup m3u8 end-------------------')
            # windows系统，底层处理界面逻辑
            else:
                # 正常结束，不需要额外工作
                if self._infos.get('action', 'none') == 'none':
                    self.move_to_dest(list(self._infos['downloadingFiles'].keys())[0])
                    msg['destFile'] = self._infos['destFileName']
                elif self._infos.get('action', 'none') in ['dash_convert', 'dash_merge']:
                    # 先发消息给产品，以更新其界面显示
                    if self._callback:
                        msg['nextAction'] = 'merge_progress' if  msg['nextAction'] == 'dash_merge' else 'convert_progress'
                        self._callback(msg)
                    debug('------------------download dash_convert Begin-------------------')
                    self.dash_merge_WEBM()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
                    debug('------------------download dash_convert End-------------------')
                # 多段视频连接
                elif self._infos.get('action', 'none') in ['multi_video_merge']:
                    # 先发消息给产品，以更新其界面显示
                    if self._callback:
                        action = 'convert_progress' if 'mp3' in self._infos['ext'] else 'merge_progress'
                        msg['nextAction'] = action
                        self._callback(msg)
                    debug('------------------multi video merge start-------------------')
                    self.multi_video_concat()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
                    debug('------------------multi video merge end-------------------')
                elif self._infos.get('action', 'none') in ['convert2Mp3']:
                    # 因为ffmpeg库精简，去除一些插件，可能导致其它格式转换mp3失败，因此交由界面去转
                    # 先发消息给产品，以更新其界面显示
                    # if self._callback:
                    #     msg['nextAction'] = 'convert_progress'
                    #     self._callback(msg)
                    # debug('------------------convert to mp3 start-------------------')
                    # self.convert_to_mp3()
                    # msg['destFile'] = self._infos['destFileName']
                    # msg['nextAction'] = 'none'
                    # debug('------------------convert to mp3 end-------------------')

                    if self._callback:
                        msg['nextAction'] = 'convert_progress'
                        self._callback(msg)

                    # 先以底层去转，若失败再由应用层转
                    debug('------------------convert to mp3 start-------------------')
                    if self.convert_to_mp3():
                        msg['destFile'] = self._infos['destFileName']
                        msg['nextAction'] = 'none'
                        debug('------------------convert to mp3 end-------------------')
                    else:
                        debug('------------------convert to mp3 fail, continue covert by application-------------------')
                        msg['nextAction'] = 'convert2Mp3'

                elif self._infos.get('action', 'none') in ['fixM3u8']:
                    # 先发消息给产品，以更新其界面显示
                    if self._callback:
                        msg['nextAction'] = 'convert_progress'
                        self._callback(msg)
                    debug('------------------FFmpeg fixup m3u8 start-------------------')
                    self.fixup_m3u8()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
                    debug('------------------FFmpeg fixup m3u8 end-------------------')

                # 如果正常结束，即'event'为'None'，windows这一支获取媒体文件信息
                if msg.get('nextAction', 'none') == 'none':
                    debug('------------------get_mediainfo start-------------------')
                    self.get_mediainfo(msg)
                    debug('------------------get_mediainfo end-------------------')

            if self._infos.get('action', 'none') in ['convertF4MToMP4']:
                    if self._callback:
                        msg['nextAction'] = 'convert_progress'
                        self._callback(msg)
                    debug('------------------FFmpeg convertF4MToMP4 start-------------------')
                    self.convertF4MToMP4()
                    msg['destFile'] = self._infos['destFileName']
                    msg['nextAction'] = 'none'
        except:
            if self._cancel:
                msg = {
                    'event': 'download_cancel',
                    'quality': self._infos.get('quality'),
                    'data': self._infos
                }
            else:
                error = traceback.format_exc()
                debug(error)
                msg = {
                    'event': 'download_error',
                    'error': error,
                }
                try:
                    self._GA.send('event', 'downloadFail', self._infos['url'], error[len(error)-200:])
                except:
                    pass
                debug('downloader error!')

        if self._callback:
            self._callback(msg)


    def merge4Powtoon(self, video, audio, subtitle=None, duration=None):
        
        try:                     
            info_dict = {}
            merger = FFmpegMergerPP(self._ydl)
            merger.shortest = True
            dest_filename = '%s\youtube_meger%s' % (os.path.dirname(video), os.path.splitext(video)[1])
            info_dict['__files_to_merge'] = [video, audio]
            info_dict['filepath'] = dest_filename
            merger.run(info_dict)
            time.sleep(3)
            if os.path.exists(video):
                os.remove(video)
            os.rename(dest_filename, video)
        except Exception as e:
            #self._GA.send('event', 'dash_merge_WEBM', 'fail', traceback.format_exc())
            debug(traceback.format_exc())        

    def dash_merge_WEBM(self):
        try:            
            
            info_dict = {}
            isAudioWebM = False
            isVideoWebM = False
            for key, value in self._infos['downloadingFiles'].items():
                if re.search(r'opus|vorbis|m4a', key) or (value.get('format', {}).get('format_note', '') == 'DASH audio'):
                    audio = key
                    isAudioWebM = re.search('opus|vorbis', key)
                else:
                    video = key     
                    isVideoWebM = re.search('webm', key)

            merger = FFmpegMergerPP(self._ydl)
            
            if ((isVideoWebM and (not isAudioWebM)) or 
                (not isVideoWebM and isAudioWebM)):            
                merger = FFmpegMergerWebMAndM4aPP(self._ydl)
                            
            dest_filename = '%s\youtube_meger%s' % (os.path.dirname(video), os.path.splitext(video)[1])
            info_dict['__files_to_merge'] = [video, audio]
            info_dict['filepath'] = dest_filename
            merger.run(info_dict)
            self.move_to_dest(dest_filename)            
        except Exception as e:
            #self._GA.send('event', 'dash_merge_WEBM', 'fail', traceback.format_exc())
            debug(traceback.format_exc())

    def multi_video_concat(self):
        try:
            concater = FFmpegConcatMultiVideo(self._ydl, self._infos['quality'])
            info_dict = {}
            # 源文件
            dt = sorted(self._infos['downloadingFiles'].items(), key=lambda item:item[1]['order'])
            src_files = [item[0] for item in dt]
            info_dict['__files_to_concat'] = src_files
            # 目标文件
            dest_filename = '%s\youtube_concat%s' % (self._downloadtempPath, os.path.splitext(self._infos['destFileName'])[1])
            info_dict['destpath'] = dest_filename
            concater.run(info_dict)
            self.move_to_dest(dest_filename)            
        except Exception as e:
            #self._GA.send('event', 'multi_video_merge', 'fail', traceback.format_exc())
            debug(traceback.format_exc())

    def convert_to_mp3(self):
        try:
            converter = FFmpegExtractMp3(self._ydl, preferredquality=self._infos['quality'])
            info_dict = {}
            # 源文件
            info_dict['filepath'] = list(self._infos['downloadingFiles'].keys())[0]
            # 目标文件
            dest_filename = '%s\youtube_audio%s' % (self._downloadtempPath, os.path.splitext(self._infos['destFileName'])[1])
            info_dict['destpath'] = dest_filename
            info_dict['filetime'] = self._infos.get('last-modified', None)
            converter.run(info_dict)
            self.move_to_dest(dest_filename)
            
            return True
        except Exception as e:
            #self._GA.send('event', 'convert_to_mp3', 'fail', traceback.format_exc())
            debug(traceback.format_exc())
            # 抛由界面去转
            return False

    def fixup_m3u8(self):
        try:
            converter = FFmpegFixupM3u8PPForToggle(self._ydl)
            info_dict = {}
            # 源文件
            info_dict['filepath'] = list(self._infos['downloadingFiles'].keys())[0]
            # 目标文件
            dest_filename = '%s\m3u8_fix%s' % (self._downloadtempPath, os.path.splitext(self._infos['destFileName'])[1])
            info_dict['destpath'] = dest_filename
            converter.run(info_dict)
            self.move_to_dest(dest_filename)
            
        except Exception as e:
            #self._GA.send('event', 'fixup_m3u8', 'fail', traceback.format_exc())
            debug(traceback.format_exc())

    def convertF4MToMP4(self):
        try:
            FFmpegConvertF4MToMp4 = FFmpegFixupM3u8PPForToggle
            converter = FFmpegConvertF4MToMp4(self._ydl)
            info_dict = {}
            info_dict['filepath'] = list(self._infos['downloadingFiles'].keys())[0]
            dest_filename = '%s\\f4m_fix.mp4' % (self._downloadtempPath)
            info_dict['destpath'] = dest_filename
            converter.run(info_dict)
            self._infos['destFileName'] = os.path.splitext(self._infos['destFileName'])[0] + '.mp4'
            self.move_to_dest(dest_filename)            
        except Exception as e:
            # 有异常，直接改名处理
            self._infos['destFileName'] = os.path.splitext(self._infos['destFileName'])[0] + '.mp4'
            self.move_to_dest(info_dict['filepath'])
            #self._GA.send('event', 'convertF4MToMP4', 'fail', traceback.format_exc())
            debug(traceback.format_exc())

    def get_mediainfo(self, msg):
        filename = msg['destFile']
        if not os.path.exists(filename):
            return

        try:
            ffpp = FFmpegPostProcessor(downloader=self._ydl)
            args = [ffpp.executable]
            args += ['-i', filename]
            p = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=subprocess.PIPE, startupinfo=get_startinfo())
            stdout, stderr = p.communicate()
            # 获取成功
            if p.returncode != 0:
                stderr = stderr.decode('utf-8', 'replace')
                # 时长
                m = re.search(r'Duration\:\s*((?:\d\d[.:]){3}\d\d)', stderr)
                if m:
                    duration = m.group(1)
                    h, m, s = duration.strip().split(':')
                    msg['duration'] = int(h) * 3600 + int(m) * 60 + float(s)
                # 分辨率
                m = re.search(r'\d{2,}x\d{2,}', stderr)
                if m:
                    msg['resolution'] = m.group()

                # 缩略图
                thumb = msg.get('thumbnail', '')
                if thumb != '' and not os.path.exists(thumb):
                    msg['thumbnail'] = thumb
                    start_pos = random.uniform(5, 20)
                    if msg.get('duration', 0) < start_pos:
                        start_pos = 0;
                    start_pos = str(start_pos);
                    try:
                        args = [ffpp.executable]
                        args += ['-ss', start_pos]
                        args += ['-i', filename]
                        args += ['-f', 'image2']
                        args += ['-y', thumb]
                        p = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=subprocess.PIPE, startupinfo=get_startinfo())
                        p.communicate()
                    except:
                        msg.pop('thumbnail')

        except Exception as e:
            debug(traceback.format_exc())


    def delete_tempfiles(self):
        if 'downloadingFiles' in self._infos:
            for item in self._infos['downloadingFiles'].keys():
                try:
                    os.remove(item)
                    tempfile = '%s.part' % item
                    if os.path.exists(tempfile):
                        os.remove(tempfile)
                except:
                    pass

    def cancel(self):
        self._cancel = True

        msg = {
            'event': 'download_cancel',
            'quality': self._infos.get('quality'),
            'data': self._infos
        }
        if self._callback:
            self._callback(msg)


# mp3转换、多段合并。独立抽出来，以避免修改ffmpeg这个文件
import time
import tempfile
import random
import subprocess
if sys.platform == 'win32' and sys.version_info < (3, 0):
    import win_subprocess
from youtube_dl.postprocessor import FFmpegPostProcessor
from youtube_dl.postprocessor.ffmpeg import (
    FFmpegPostProcessorError,
    get_startinfo,
    FFmpegFixupM3u8PP,
    FFmpegMergerPP
)

from youtube_dl.postprocessor.common import AudioConversionError
from youtube_dl.utils import (
    PostProcessingError,
    prepend_extension
)
from youtube_dl.utilsEX import debug

# 多段合并...ffmpeg在这里不识路径中[【双语・纪实72小时】黄金炸串店_20170303【秋秋】]这样的字符，而[一面湖水]这样的可识，劳动下临时目录，曲线救下国吧！
class FFmpegConcatMultiVideo(FFmpegPostProcessor):
    def __init__(self, downloader=None, quality=0):
        self._quality = quality
        FFmpegPostProcessor.__init__(self, downloader)

    def run(self, information):
        destpath = information['destpath']
        if os.path.exists(destpath):
            os.remove(destpath)
        input_paths = information['__files_to_concat']
        oldest_mtime = min(os.stat(path).st_mtime for path in input_paths)

        # 构建文件列表文件
        input_txtfile = os.path.join(tempfile.gettempdir(), 'input_list.txt')
        if os.path.exists(input_txtfile):
            os.remove(input_txtfile)
        inputf = open(input_txtfile, 'w')
        for i, file in enumerate(input_paths):
            line = 'file \'%s\'' % file
            if i < len(input_paths) - 1:
                line += '\n'
            inputf.writelines(line)
        inputf.close()

        # 构建参数
        args = [self.executable]
        args += ['-f', 'concat']
        #Unsafe file name '/tmp/temp/Watch Naruto Shippuden Season 17
        args += ['-safe', '-1']
        args += ['-i', input_txtfile]
        args += ['-c', 'copy']
        # 置同一磁盘中，rename会很快，如同盘剪切...若是mp3，则需要再转换
        filename, ext = os.path.splitext(destpath)
        is_audio = 'mp3' in ext.lower()
        if is_audio:
            ext = '.mp4'
        # 若是音频，则置为mp4然后再转
        destpath_new = filename + ext
        args += [destpath_new]

        try:
            p = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=subprocess.PIPE, startupinfo=get_startinfo())
            stdout, stderr = p.communicate()
            if p.returncode != 0:
                stderr = stderr.decode('utf-8', 'replace')
                msg = stderr.strip().split('\n')[-1]
                raise FFmpegPostProcessorError(msg)

            # 若是mp3，需要再次转换
            if is_audio:
                converter = FFmpegExtractMp3(self._downloader, preferredquality=self._quality)
                info_dict = {}
                # 源文件
                info_dict['filepath'] = destpath_new
                # 目标文件
                info_dict['destpath'] = destpath
                converter.run(info_dict)
                os.remove(destpath_new)

            self.try_utime(destpath, oldest_mtime, oldest_mtime)
        except Exception as ex:
            debug('multi_video_concat error:')
            debug(ex)
            if is_audio:
                os.remove(destpath_new)
            raise ex
        finally:
            os.remove(input_txtfile)

# 抽取mp3
class FFmpegExtractMp3(FFmpegPostProcessor):
    def __init__(self, downloader=None, preferredquality='320'):
        FFmpegPostProcessor.__init__(self, downloader)
        self._preferredquality = preferredquality
        if int(self._preferredquality) == 0:
            self._preferredquality = '320'

    def run_ffmpeg(self, path, out_path, codec, more_opts):
        if codec is None:
            acodec_opts = []
        else:
            acodec_opts = ['-acodec', codec]
        opts = ['-vn'] + acodec_opts + more_opts
        try:
            FFmpegPostProcessor.run_ffmpeg(self, path, out_path, opts)
        except FFmpegPostProcessorError as err:
            raise AudioConversionError(err.msg)

    def run(self, information):
        src_path = information['filepath']
        acodec = 'libmp3lame'
        extension = 'mp3'
        more_opts = []
        if self._preferredquality is not None:
            if int(self._preferredquality) < 10:
                more_opts += ['-q:a', self._preferredquality]
            else:
                more_opts += ['-b:a', self._preferredquality + 'k']
        dst_path = information['destpath']
        information['ext'] = extension

        # If we download foo.mp3 and convert it to... foo.mp3, then don't delete foo.mp3, silly.
        if dst_path == src_path:
            if self._downloader:
                self._downloader.to_screen('[ffmpeg] Post-process file %s exists, skipping' % dst_path)
            return

        try:
            if self._downloader:
                self._downloader.to_screen('[ffmpeg] Destination: ' + dst_path)
            self.run_ffmpeg(src_path, dst_path, acodec, more_opts)
        except AudioConversionError as e:
            raise PostProcessingError(
                'audio conversion failed: ' + e.msg)
        except Exception as ex:
            raise PostProcessingError('error running ' + self.basename)

        # Try to update the date time for extracted audio file.
        if information.get('filetime') is not None:
            self.try_utime(
                dst_path, time.time(), information['filetime'],
                errnote='Cannot update utime of audio file')


class FFmpegFixupM3u8PPForToggle(FFmpegFixupM3u8PP):
    def get_audio_codec(self, path):
        return 'aac'

    def run(self, info):
        filename = info['filepath']
        if self.get_audio_codec(filename) == 'aac':
            destpath = info['destpath']

            options = ['-c', 'copy', '-f', 'mp4', '-bsf:a', 'aac_adtstoasc']
            self._downloader.to_screen('[ffmpeg] Fixing malformed AAC bitstream in "%s"' % filename)
            self.run_ffmpeg(filename, destpath, options)

            os.remove(filename)
        return [], info


class FFmpegMergerWebMAndM4aPP(FFmpegMergerPP):
    def run(self, info):
        filename = info['filepath']
        temp_filename = prepend_extension(filename, 'temp')
        args = ['-vcodec', 'copy']
        self._downloader.to_screen('[ffmpeg] Merging formats into "%s"' % filename)
        self.run_ffmpeg_multiple_files(info['__files_to_merge'], temp_filename, args)
        sleep(5)
        os.rename(temp_filename, filename)
        return info['__files_to_merge'], info