# -*- coding: utf-8 -*-
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import os
import re
import sys
import ctypes
import time, datetime
import json
import threading
import traceback
import gaid
from ctypes import *

from youtube_dl.utilsEX import (
    debug,
    sleep,
    validFileName as vfn,
    GoogleAnalytics,
    get_top_host
)

from sniffer import (
    singleSinffer,
    snifferPlayList,
    accountTest
)

from downloader import (
    downloader
)

class supportCallbackObjct(object):
    def __init__(self):
        self.callback = None
        self.userObj = None
        self.pyCallback = None

    # 设置回调
    def setCallback(self, c_callback):
        if not c_callback:
            return
        
        debug('setCallback begin')
        # 3.0，api改了
        if sys.version_info >= (3, 0):
            PyCapsule_GetPointer = PYFUNCTYPE(c_void_p, py_object)(('PyCapsule_GetPointer', pythonapi))
            PyCapsule_GetName = PYFUNCTYPE(c_void_p, py_object)(('PyCapsule_GetName', pythonapi))
            c_callbackaddr = PyCapsule_GetPointer(c_callback, PyCapsule_GetName(c_callback))
        else:
            PyCObject_AsVoidPtr = PYFUNCTYPE(c_void_p, py_object)(('PyCObject_AsVoidPtr', pythonapi))
            c_callbackaddr = PyCObject_AsVoidPtr(c_callback)

        CALLBACKFUNC_T = CFUNCTYPE(c_long, c_char_p, c_long)
        self.callback = CALLBACKFUNC_T(c_callbackaddr)
        debug('setCallback end')

    def setPyCallback(self, callback):
        self.pyCallback = callback

    def setUserObj(self, userObj):
        debug('setUserObj Begin %d' % userObj)
        self.userObj = userObj
        debug('setUserObj End %d' % userObj)

    # 回调给外部
    def sendMessage(self, msg):
        # if msg and ('download_error' in msg or 'sniffer_error' in msg):
        #    debug(msg)
        try:
            if self.callback:
                debug('.............................self.callback: %s' % msg)
                self.callback(c_char_p(msg.encode('utf-8')), c_long(int(self.userObj)))
            if self.pyCallback:
                self.pyCallback(msg)
        except:
            debug(traceback.format_exc())


class Interface(supportCallbackObjct):
    pass


class MyEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, bytes):
            return str(obj, encoding='utf-8');
        return json.JSONEncoder.default(self, obj)


class VideoDownloader(Interface):
    def readVersion(self):
        if sys.platform == 'win32':
            try:
                fileName = os.path.join(os.path.abspath(os.path.dirname(__file__)), 'version.ini')
                try:
                    import configparser
                except ImportError:
                    import ConfigParser as configparser
                config = configparser.ConfigParser()
                if sys.version_info >= (3, 0):
                    config.read_file(open(fileName))
                else:
                    config.readfp(open(fileName))
                return config.get("info", "version").replace('.', '_')
            except Exception as e:
                debug(e)
                return '99_99_99_99'
        else:
            return '99_99_99_99'

    def init(self, url, browser=None):
        self._url = url
        self._browser = browser
        self._cancel = False
        self._running = None
        self._sniffer = None
        self._downloader = None
        self._needReSniffer = False
        self._retry = False
        debug('PythonCoreVersion:' + self.readVersion())
        self._GA = GoogleAnalytics(gaid.ga1)                

    def sendMessage(self, msg):
        try:
            if re.search(r'download_error|sniffer_error|download_complete|sniffer', msg):
                host = self._url
                try:
                    def getdomain(url):
                        return get_top_host(url)
                        # from youtube_dl.tld import get_tld
                        # host = get_tld(self._url)

                    host = getdomain(self._url)
                except:
                    pass
                if re.search(r'download_error|sniffer_error', msg):
                    jsondata = json.loads(msg)

                    if jsondata['event'] == 'download_error':
                        self._GA.sendDownloadResult('downloadFail', host, self._url)
                    else:
                        self._GA.sendDownloadResult('analyticsFail', host, self._url)

                elif re.search(r'download_complete', msg):
                    self._GA.sendDownloadResult('downloadSuccess', host, self._url)
                elif re.search(r'sniffer', msg):
                    pass
                    # self._GA.send('Sniffer', 'sniffer_success', host)
        except:
            debug(traceback.format_exc())
        super(VideoDownloader, self).sendMessage(msg)

    def singleSnifferCallback(self, data):
        self.sendMessage(json.dumps(data, cls=MyEncoder))

    def downloadCallback(self, data):
        if 'event' in data and data['event'] == 'download_error' and not self._retry:
            debug('downloadCallback retry begin')
            self._needReSniffer = True
            self._retry = True
            debug('downloadCallback retry end')
        else:
            if 'event' in data and data['event'] == 'download_error':
                # 处理磁盘空间不够导致失败，统一类型
                def get_free_space_mb(dirname):
                    """Return folder/drive free space (in megabytes)."""
                    if sys.platform == 'win32':
                        free_bytes = ctypes.c_ulonglong(0)
                        ctypes.windll.kernel32.GetDiskFreeSpaceExW(ctypes.c_wchar_p(dirname), None, None,
                                                                   ctypes.pointer(free_bytes))
                        return free_bytes.value
                    else:
                        st = os.statvfs(dirname)
                        return st.f_bavail * st.f_frsize

                if self.infos:
                    try:
                        dirName = self.infos['dir'] if 'dir' in self.infos else self.infos['downloadDestPath']
                        size = get_free_space_mb(dirName)
                        if size < 1024 * 1024 * 10:
                            data['error'] = 'No space left on device!'
                    except Exception as e:
                        debug(e)
                        pass

            self.sendMessage(json.dumps(data, cls=MyEncoder))

    def sniffer(self, asynchronous='True'):

        debug('----------------------------------Begin Sniffer---------------------------------- Begin')
        self._sniffer = singleSinffer(self._url, self._browser, self.singleSnifferCallback)
        self._sniffer.QuickMode = asynchronous == 'True'
        self._running = self._sniffer
        t = threading.Thread(target=lambda: self._sniffer.run())
        t.start()
        if asynchronous != 'True':
            # timeOut = False
            startTick = time.time()
            while t.isAlive() and (not self._cancel):
                if time.time() - startTick > 3000:
                    # timeOut = True
                    break
                t.join(1)
        debug('----------------------------------Begin Sniffer---------------------------------- End')

    def getSnifferResult(self):
        return self._sniffer.getFormats()

    def safeMakeDirs(self, path):
        for i in range(2):
            try:
                os.makedirs(path)
                return True
            except:
                continue
        return False

    def run(self, data):

        debug('----------------------------------Task Main Run---------------------------------- Begin')
        self._cancel = False
        self._retry = False
        try:
            self._hasTrySinffer = False
            self.infos = json.loads(data)

            debug(self.infos)
            for i in range(2):
                debug('----------------------------Task Main Run _try %d-----------------------------------' % i)
                self._needReSniffer = False
                if not (self.infos.get('formats') or self.infos.get('entries') or self.infos.get(
                        'downloadingFiles')):  # 没有做过分析那么先做分析
                    formats = self._sniffer.getFormats() if self._sniffer else None
                    formats = formats if formats and formats.get('result') else None
                    if not formats:
                        debug('main.py call sniffer!')
                        self.sniffer(asynchronous='False')
                        formats = self._sniffer.getFormats()

                    if self._cancel:
                        debug('main.py cancel by user')
                        return

                    if not formats.get('result'):
                        # debug('main.py sniffer error!')
                        # self.sendMessage(json.dumps({'event': 'sniffer_error', 'error': formats.get('error')}))
                        return

                    # 若重试，youtube类，下载失败，则去除音视频一体的支路，走dash合成的。视频以av01编码的，下载下来不能播放，也删除
                    # https://www.youtube.com/watch?v=Mn4AwineA5o这一个，22支路下载一点点就失败
                    if 'youtube' in self._url or 'youtu.be' in self._url: # 倒序删除
                        for i in range(len(formats['result']['formats']) - 1, -1, -1):
                            format = formats['result']['formats'][i]
                            try:
                                if 'vcodec' in format and 'av01' in format['vcodec'] or self._retry and int(format['format_id']) <= 78:
                                    formats['result']['formats'].remove(format)
                            except:
                                continue

                    # 选择需要的资源
                    selectors = self._sniffer.format_selector(self.infos['quality'], self.infos.get('ext', ''),
                                                              self.infos.get('subtitleLang', ''))
                    if selectors.get('error'):
                        debug('main.py format_selector error!')
                        selectors['event'] = 'download_error'
                        selectors['error'] = 'main.py format_selector error!'
                        self.sendMessage(json.dumps(selectors))
                        return
                    else:
                        # 选择完毕
                        selectors['downloadDestPath'] = self.infos['dir'] if 'dir' in self.infos else self.infos[
                            'downloadDestPath']
                        if 'downloadTempPath' in self.infos:
                            selectors['downloadTempPath'] = self.infos['downloadTempPath']
                        else:
                            selectors['downloadTempPath'] = os.path.join(selectors['downloadDestPath'], 'temp')
                        selectors['imageSavePath'] = self.infos['imageSavePath']
                        selectors['url'] = self.infos.get('url', self._url)
                        if 'fileNameWithoutExt' in self.infos:
                            selectors['fileNameWithoutExt'] = self.infos['fileNameWithoutExt']
                        if 'speedUp' in self.infos:
                            selectors['speedUp'] = self.infos['speedUp']
                else:
                    selectors = self.infos

                if not selectors.get('fileNameWithoutExt'):
                    # todo:这个地方title要优化下
                    selectors['fileNameWithoutExt'] = vfn(selectors['title']).strip('. ')  # 去除文件名中前后.以避免win系统中创建目录失败
                    tempPath = selectors['downloadTempPath']
                    selectors['downloadTempPath'] = os.path.join(tempPath, '%s_%s' % (
                        selectors['fileNameWithoutExt'], datetime.datetime.now().strftime('%f')))
                    if 'formats' in selectors:
                        # 为避免字串处理异常，皆以此类目录存临时文件，操作结束copy回去
                        selectors['downloadTempPath'] = os.path.join(tempPath,
                                                                     '%s' % (datetime.datetime.now().strftime('%f')))
                    if not os.path.exists(selectors['downloadTempPath']):
                        if not (self.safeMakeDirs(selectors['downloadTempPath'])):
                            raise Exception('safeMakeDirs(selectors[\'downloadTempPath\']) fail')
                        
                if (selectors.get('formats') or selectors.get('entries') or self.infos.get('downloadingFiles')):
                    self._downloader = downloader(self.downloadCallback, selectors)
                    # mp3转换传入其码率
                    if 'mp3' in self.infos.get('ext', '').lower():
                        self._downloader._infos['quality'] = self.infos['quality']
                    self._running = self._downloader
                    debug('----------------------Begin Download-----------------------------------')
                    self._downloader.run()
                    debug('----------------------End Download-----------------------------------')
                    if self._needReSniffer and i == 0:
                        debug('_needReSniffer 1')
                        if 'formats' in self.infos:
                            self.infos.pop('formats')
                        if 'entries' in self.infos:
                            self.infos.pop('entries')
                        if 'downloadingFiles' in self.infos:
                            self.infos.pop('downloadingFiles')
                        self.infos['fileNameWithoutExt'] = selectors['fileNameWithoutExt']
                        self.infos['downloadTempPath'] = selectors['downloadTempPath']
                        debug('----------------------Resniffer-----------------------------------')
                        debug(self.infos)
                        debug('----------------------Resniffer-----------------------------------')
                        self._sniffer = None
                        debug('_needReSniffer 2')
                    else:
                        debug('.......................................')
                        break
        except:
            debug('')
            msg = {'event': 'download_error', 'error': traceback.format_exc()}
            self.sendMessage(json.dumps(msg, cls=MyEncoder))
        finally:
            debug('----------------------------------Task Main Run---------------------------------- End')

    def resumeDownload(self, data):
        debug('-------------------------------------Resume task-------------------------------')
        threading.Thread(target=self.run, args=(data,)).start()

    def download(self, dir, imageSavePath, quality, ext, subtitleLang, speedUp='False'):
        debug('-------------------------------------Begin Task--------------------------------')
        dir = dir.strip(' ')
        ext = ext.strip('.')
        data = json.dumps({'quality': quality, 'dir': dir, 'imageSavePath': imageSavePath, 'ext': ext,
                           'subtitleLang': subtitleLang, 'speedUp': speedUp})
        threading.Thread(target=self.run, args=(data,)).start()

    def cancel(self):
        debug('-------------------------------------cancel task------------------------------')
        if self._running:
            self._cancel = True
            self._running.cancel()

    def deleteTempFiles(self):
        if self._running and self._running is self._downloader:
            self._downloader.cancel()
            self._downloader.delete_tempfiles()


class playlistSnifferWapper(Interface):
    def init(self, url, browser=None):
        print('playlistSnifferWapper init begin')
        self._url = url
        self._browser = browser
        self._cancel = False
        self._running = snifferPlayList(self._url, self._browser, self.snifferCallback)
        print('playlistSnifferWapper init end')

    def snifferCallback(self, data):
        self.sendMessage(json.dumps(data, cls=MyEncoder))

    def run(self):
        self._running.run()

    def cancel(self):
        if self._running:
            self._cancel = True
            self._running.cancel()

    def support(self):
        debug('playlistSnifferWapper support begin')
        try:
            return self._running.support()
        except Exception as e:
            debug(e)
        finally:
            debug('playlistSnifferWapper support end')


class searchMusic(playlistSnifferWapper):
    def init(self, metaTitle, metaArtist, duration):
        url = 'searchMusic://metaTitle=%s&metaArtist=%s&duration=%s' % (metaTitle, metaArtist, duration)
        super(searchMusic, self).init(url)


# class browserlessServer(Interface):
#
#     def run(self):
#         from youtube_dl.browserless.server import start
#         threading.Thread(target=start, args=()).start()
#
#     def cancel(self):
#         from youtube_dl.browserless.server import cancel
#         cancel()


class accountTestWapper(Interface):
    def init(self, site, username, password):
        print('accountTestWapper init begin')
        self._running = accountTest(site, username, password, callback = self.snifferCallback)
        print('accountTestWapper init end')

    def snifferCallback(self, data):
        self.sendMessage(json.dumps(data, cls=MyEncoder))

    def run(self):
        self._running.run()

    def cancel(self):
        if self._running:
            self._cancel = True
            self._running.cancel()


pausedata = None

def single_callback(str):
    debug(str)
    data = json.loads(str)
    print(data)

def playlist_callback(str):
    debug(str)
    data = json.loads(str)
    if data.get('event', None) == 'download_cancel':
        global pausedata
        debug(data['data'])
        pausedata = data['data']


def playlist(url):
    ps = playlistSnifferWapper()
    ps.setPyCallback(playlist_callback)
    ps.setCallback(None)
    # ps.init('https://youtu.be/2uOyfqVuonQ?list=PLFgquLnL59al3xxBPyZoIx_TLAauFp4Rq')
    ps.init(url)
    print(ps.support())
    ps.run()
    sleep(10000)


def AccountCallback(str):
    global pausedata
    pausedata = json.loads(str)

def Account():
    ps = accountTestWapper()
    ps.setPyCallback(AccountCallback)
    global pausedata
    for item in [
                ('youtube.com', 'keepvidpro@gmail.com', 'keep123456'),                
                 ]:
        try:
            pausedata = None
            ps.init(item[0], item[1], item[2])
            startTick = time.time()
            ps.run()
            while(time.time() - startTick <= 1000) :
                if pausedata:
                    break
                sleep(10)
            print('=========================================================%s login result: %s=====================================' % (item[0], pausedata['event']))
        except:
            pass


if __name__ == "__main__":
    # import urllib2
    # def open(url):
    #     req=urllib2.Request(url)
    #     req.add_header('User-Agent',"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36")
    #     response=urllib2.urlopen(req)
    #     return response.read()
    # webpage =  open('https://vimeo.com/log_in')




    #ps
    #Account()
    #playlist('https://www.youtube.com/channel/UCkHZgnbqED3OBkZogvfE4Bw')
    #exit(0);

    # sm = searchMusic()
    # sm.init("Where Are Ü Now-Skrillex", "Diplo", "4:12")
    # sm.run()
    # time.sleep(10)
    # exit(0)
    #
    # if sys.platform == 'win32':
    #     browserlessServer().run()
    os.environ['KVFfmpegPath'] = r'C:\Program Files (x86)\Wondershare\UniConverter\DownloadRes'
    VD = VideoDownloader()
    url = 'http://123movies.sc/watch-clouds-of-sils-maria-2014-123movies.html/watching.html'
    url = 'http://www.lynda.com/course-tutorials/3ds-Max-V-Ray-Residential-Exterior-Materials/734636-2/5016618-4.html'
    url = 'https://www.pornhub.com/view_video.php?viewkey=ph58ecf6232ae10'
    url = 'https://www.sonycrackle.com/10-items-or-less/2479495'
    url = 'https://www.youtube.com/watch?v=rPT93PV3Udg'
    # url = 'https://www.youtube.com/watch?v=Wlc5LkTerSo'
    url = 'https://www.youtube.com/watch?v=_ykHR9W6Q_8'
    url = 'http://www.crunchyroll.com/naruto-shippuden/episode-456-itachis-story-light-and-darkness-the-darkness-of-the-akatsuki-696221'

    url = 'https://streamango.com/f/cbtacrbftstpantb/FT036ITA_flv_mp4'
    url = 'https://youtu.be/3bIEYZHJRUU'
    url = 'http://www.history.com/topics/valentines-day/history-of-valentines-day/videos/bet-you-didnt-know-valentines-day?m=528e394da93ae&s=undefined&f=1&free=false'
    url = 'http://www.dailymotion.com/video/x3ltvxv_neighbours-episode-1174-neighbours-season-eposide-watch_tv'
    url = 'https://www.bbc.co.uk/iplayer/episode/p06jcn8k/doctor-who-series-11-1-the-woman-who-fell-to-earth'

    url = 'https://www.bbc.co.uk/news/uk-46967689'
    url = 'https://www.jw.org/en/bible-teachings/teenagers/ask/pressured-for-sex/'
    url = 'https://www.jw.org/en/bible-teachings/teenagers/whiteboard-animations/whats-a-real-friend/'
    url = 'https://www.manoramamax.com/details/_6093706115001'
    url = 'https://www.orztoons.com/clip/3988575/'
    url = 'https://courses.platzi.com/classes/54-startup-class/2440-startup-advice-brief-2/'
    url = 'https://www.educba.com/my-courses/pnn.php?id=li_topic_18&xcdi=290'    
    url = 'https://www.soap2day.com/movie_aTo1NzAwOw.html'
    url = 'https://www.soap2day.com/movie_aTo2MzM3Ow.html'
    url = 'https://www.jibjab.com/view/make/funky_ghost/6ef752dc-7c61-40e4-95e4-69f2711c4e51'
    url = 'https://www.mediasetplay.mediaset.it/video/rosyabatesecondastagione/quarta-puntata_F309356101000401'
    url = 'https://mediaspace.gatech.edu/media/Bill+Campbell+-+Astral+TravelingA+Exploring+Afro+Past%2C+Present%2C+and+Futures/1_st6k4thu'
    url = 'https://vimeo.com/ondemand/heavenonearthrevealed/247214014?autoplay=1'
    url = 'https://de.redtube.com/1483367'
    url = 'https://www.stockfeel.com.tw/video_page/?watch=VVd5eWx1aUljc1g5SURhM1V2T1pBYVV3VjdQbUh1QlNTb0dmRTJoSkJEND0='
    url = 'https://tw.iqiyi.com/v_19rujllml8.html'
    
    url = 'https://www.pbs.org/video/ken-burns-country-music-episode-1-the-rub/?utm_source=twitter&utm_medium=pbsofficial&utm_campaign=countrymusic_2019&fbclid=IwAR0ubiIWBeREOk2QnWdRMC-U_81il533NwP_CwmY8GymkicQeRFqMMV1nuE'
    url = 'https://www.viu.com/ott/sg/en-us/vod/207305/Justice'
    url = 'https://www.viu.com/ott/hk/zh-hk/vod/207300/Justice'
    url = 'https://kissasian.sh/Drama/Shiyakusho/Episode-4?id=51544'
    url = 'https://www.youtube.com/watch?v=AcZ2OY5-TeM'
    url = 'https://www.youtube.com/watch?v=Aql6SIOIyXs'
    url = 'https://www.youtube.com/watch?v=AAc8I67P-aE&t=103s'
    url = 'https://youtu.be/AawJi5GNzHA'
    url = 'https://hbr.org/video/3633937148001/the-explainer-the-balanced-scorecard'
    url = 'https://www.viki.com/videos/1157519v-extra-ordinary-you-episode-1'
    url = 'https://www.jw.org/finder?wtlocale=S&docid=1001071838&srcid=share'
    url = 'https://www.bbc.co.uk/iplayer/episode/m000b9f8/seven-worlds-one-planet-series-1-3-south-america'
    url = 'https://kissasian.sh/Drama/Shiyakusho/Episode-4?id=51544'
    url = 'https://kissasian.sh/Drama/1-Litre-of-Tears/Episode-8?id=1530'
    url = 'http://sockshare.net/watch/zGObKXDx-brittany-runs-a-marathon.html?__cf_chl_jschl_tk__=0579d1ee0f4758a3ee51bbb20c7e58843d9f2c6d-1575538101-0-Aaw8wJAiFMPmIXvlY4dv1MXaBnePOFHMlXgphq_NPmvuEJdJAHE-VDvf55hQcBcvifeMoYY_6yPNiKs6y1xd0yoeZh43o4SZghZObRf0x9n8CExOSkF-ockFip437aHG6k_OEeksVH2L9ODUboD7XVaN6kZzd8dfVyieb7Q3S67XCl_UgtnS_UXBtsQro5WP3NzLro6kqiLuczFDVgebYPARSxYfI1hk_GBRIx4SOhGgvQLSabXyQAXcJRRCnRrArm7tblDBJBonQYd4pJVFCUfYQZMaBUhMtE2rIktXpt-2qv-_4BWb-XTg4HERF_VlCg'
    url = 'https://www.ipla.tv/wideo/rozrywka/Filmowo/5010598/Jak-poslubic-milionera-Kulisy/5017331/Malgorzata-Socha-o-filmie-Jak-poslubic-milionera-premiera-29-listopada/b8ecc7b73856242a278c26d263e23ff3'
    url = 'http://vod.afreecatv.com/PLAYER/STATION/49940774'
    #url = 'https://v.jin10.com/details.html?id=10946'
    url = 'http://vod.afreecatv.com/PLAYER/STATION/50498304'
    #url = 'http://vod.afreecatv.com/PLAYER/STATION/49790431'
    url = 'https://videos.sproutvideo.com/embed/a49dd8b1101ce2cb2c/46ab3493a80de4a9?type=hd'
    url = 'https://dramaq.de/cn191030/1.html'
    url = 'https://www.9now.com.au/love-island-australia/season-2/episode-1'
    url = 'https://4d.rtvslo.si/arhiv/to-je-nasa-sola/174581785'
    url = 'https://www.youtube.com/watch?reload=9&v=RS0KyTZ3Ie4'
    url = 'https://edu.51cto.com/center/course/lesson/index?id=516242'
    url = 'https://www.mlb.com/tv/g605027/vb0dfd399-0409-427f-ab51-039e4761cf4c#game=605027,tfs=20200307_010500,game_state=live'
    
    url = 'http://www.howcast.com/videos/503667-l-a-noire-walkthrough-part-15-a-marriage-made-in-heaven-3-of-5/'
    url = 'http://media.photobucket.com/user/yugottah84/media/Video/VID00014-20100331-1311.mp4.html?filters[term]=video&filters[primary]=videos&filters[secondary]=images&sort=1&o=7'
    url = 'https://kisscartoon.info/episode/jojos-bizarre-adventure-diamond-is-unbreakable-dub-episode-5/?server=rapidvideo'
    url = 'https://kisscartoon.info/episode/police-academy-the-animated-series-season-1-episode-26/'
    
    url = 'https://www.viki.com/videos/1160385v-ill-go-to-you-when-the-weather-is-nice-episode-11'
    #url = 'https://www.raiplay.it/video/2020/04/gifted---il-dono-del-talento-35a18587-c93d-4019-9da0-015392e99933.html'
    #url = 'https://kisscartoon.info/episode/star-wars-the-clone-wars-season-1-episode-1/?server=youtu' 
    #url = 'https://www.youtube.com/watch?v=b4iPQNosp5c'   
    url = 'https://gyao.yahoo.co.jp/title/%E3%82%AC%E3%82%A4%E3%82%A2%E3%81%AE%E5%A4%9C%E6%98%8E%E3%81%91/5b863377-5c86-47ac-82e1-4c65d224c418'
    url = 'https://www.crunchyroll.com/the-ambition-of-oda-nobuna/episode-12-conquest-601587'
    url = 'https://www.gaia.com/video/psychedelics-and-consciousness?fullplayer=feature'
    url = 'https://www.bbc.co.uk/iplayer/episode/p089kjkt/killing-eve-series-3-3-meetings-have-biscuits'
    
    url = 'https://soundcloud.com/sergeytutty/sergey-tutty-first-set-with-love'
    url = 'https://embed.vhx.tv/videos/661558?api=1&amp;autoplay=1&amp;back=AT%20HOME%20WORKOUTS%20-%20Click%20here%20for%20more&amp;color=00b388&amp;context=https%3A%2F%2Fwatch.lesmillsondemand.com%2Fat-home-workouts%2Fseason%3A1&amp;live=0&amp;playsinline=1&amp;referrer=&amp;sharing=1&amp;title=0&amp;vimeo=1'
    url = 'https://watch.lesmillsondemand.com/at-home-workouts/season:1/videos/rpm-83-45-min'
    url = 'https://watch.lesmillsondemand.com/at-home-workouts/season:1/videos/les-mills-sprint-16'
    url = 'https://www.facebook.com/watch/live/?v=250490516148648'
    url = 'https://www.facebook.com/drjackkruse/videos/250490516148648/'
    url = 'https://www.eroprofile.com/m/videos/view/Power-ploughing'
    url = 'https://www.hotstar.com/in/tv/yeh-rishta-kya-kehlata-hai/s-43/kartik-nairas-mehndi-celebration/1000246341'
    url = 'https://www.mixcloud.com/DjMassimo/djmassimos-house-n101/'
    url = 'https://soundcloud.com/pillai-center/om-shreem-brzee-sri-swarna-varahi-devyei-namaha-chant-one-hour'
    url = 'https://www.raiplay.it/video/2020/04/Non-Voglio-Cambiare-Pianeta---Km-0---Lunedi-48b5a6d2-d5b6-4094-a495-8b9da2dcd345.html'
    url = 'https://www.mewatch.sg/en/series/tuition-fever/ep24/601436'
    url = 'https://www.hotstar.com/in/tv/yeh-rishta-kya-kehlata-hai/s-43/kartik-nairas-mehndi-celebration/1000246341'
    #url = 'https://www.hotstar.com/in/tv/yeh-rishta-kya-kehlata-hai/s-43/the-goenkas-team-up/1000249224'
    url = 'https://www.hotstar.com/in/e15-kartiks-shocking-decision/1000231771'
    url = 'https://www.viki.com/videos/1124838v-the-foxs-summer-season-2-episode-15'
    #url = 'https://www.viki.com/videos/1160898v-meow-the-secret-boy-episode-23'    
    url = 'https://www.linkedin.com/posts/ajjames_technology-innovation-motorcycle-ugcPost-6610854390783938560-im_c/'
    url = 'https://www.hotstar.com/in/tv/yeh-rishta-kya-kehlata-hai/s-43/kartik-nairas-mehndi-celebration/1000246341'
    url = 'https://www.itv.com/hub/family-guy/2a4259a0269'
    url = 'https://www.nbc.com/dateline/video/in-a-lonely-place/4077966'
    VD.init(url)
    # import urllib.request
    # print(urllib.request.urlopen('https://gyao.yahoo.co.jp/apis/playback/graphql?appId=dj00aiZpPUNJeDh2cU1RazU3UCZzPWNvbnN1bWVyc2VjcmV0Jng9NTk-&query=%20query%20Playback(%24videoId%3A%20ID!%2C%20%24logicaAgent%3A%20LogicaAgent!%2C%20%24clientSpaceId%3A%20String!%2C%20%24os%3A%20Os!%2C%20%24device%3A%20Device!)%20%7B%20content(%20parameter%3A%20%7B%20contentId%3A%20%24videoId%20logicaAgent%3A%20%24logicaAgent%20clientSpaceId%3A%20%24clientSpaceId%20os%3A%20%24os%20device%3A%20%24device%20view%3A%20WEB%20%7D%20)%20%7B%20tracking%20%7B%20streamLog%20vrLog%20stLog%20%7D%20inStreamAd%20%7B%20forcePlayback%20source%20%7B%20...%20on%20YjAds%20%7B%20__typename%20ads%20%7B%20location%20positions%20time%20urlWhenNoAd%20%7D%20spaceId%20%7D%20...%20on%20Vmap%20%7B%20__typename%20url%20%7D%20...%20on%20CatchupVmap%20%7B%20__typename%20url%20siteId%20%7D%20%7D%20%7D%20video%20%7B%20id%20title%20delivery%20%7B%20id%20drm%20%7D%20duration%20images%20%7B%20url%20width%20height%20%7D%20cpId%20playableAge%20maxPixel%20embeddingPermission%20playableAgents%20gyaoUrl%20%7D%20%7D%20%7D%20&variables=%7B%22videoId%22%3A%225e9e7e62-d455-4a70-bb23-2af446aa38d6%22%2C%22logicaAgent%22%3A%22PC_WEB%22%2C%22clientSpaceId%22%3A%221183082802%22%2C%22os%22%3A%22UNKNOWN%22%2C%22device%22%3A%22PC%22%7D').read())                
    VD.setPyCallback(single_callback)
    VD.sniffer(asynchronous='False')
    if sys.platform == 'win32':
        VD.download(r'D:\KeepVid Pro Downloaded2', r'd:\32', '1080', ext='mp4', subtitleLang='en', speedUp='False')
        # VD.download(r'D:\KeepVid Pro Downloaded2', r'd:\32', '720', ext='mp4', subtitleLang='en', speedUp='False')
    else:
        VD.download(r'/tmp', r'/tmp', '720', ext='mp4', subtitleLang='en', speedUp='True')
    sleep(10000)
    # VD.deleteTempFiles()
    VD.cancel()
    debug(pausedata)
    sleep(10)
    VD.resumeDownload(json.dumps(pausedata, cls=MyEncoder))
