#coding=utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
import re
import os
import sys
import time
import json
import math
import traceback
import threading
import subprocess
import gaid
import xml.etree.ElementTree as ET
from youtube_dl.utilsEX import (
    debug,
    FixDefaultEncoding,
    decode_html,
    GoogleAnalytics,
    get_top_host,
    convertWebSRT2SRT,
    Kown_Audio_EXTS,
    Kown_Video_EXTS,
    sandboxEnable, 
    convertTimeFormat
)
FixDefaultEncoding()
from youtube_dl.utils import (
    parse_duration,
    determine_protocol,
    int_or_none
)

from youtube_dl.WS_Extractor import (
    YoutubeDLPatch4Single,
    YoutubeDLPatch4Playlist,
    YoutubeDLPatch4AccountTest,
)

from youtube_dl.compat import (
    compat_urllib_parse_unquote,
    compat_parse_qs,
    compat_str,
    compat_urllib_parse_urlencode,
    compat_setenv,
    compat_urllib_parse_unquote,
    compat_urllib_parse_urlparse,
    compat_urlparse,
    compat_urllib_parse_unquote_plus
)

from youtube_dl.utils import (
    encodeFilename,
    encodeArgument,
    dfxp2srt,
    str_or_none
)

class sinfferBase(object):
    _ydl = None
    YoutubeDLPatchCLS = YoutubeDLPatch4Single

    def __init__(self, url, browser = None, callback = None):
        debug('SinfferBase __init__ Begin')
        self.callback = callback

        self.url = self.fixUrl(url)
        self._browser = browser
        self._data = {}
        self._cancel = False
        self._ydl = None
        self.needAccount = True
        self.needCookie = False
        self.account = YoutubeDLPatch4AccountTest.getAccount(self.url)
        debug('SinfferBase __init__ End')

    def accountSupportSite(self, url):
         for site in ['youtube.com', 'lynda.com', 'facebook.com', 'vimeo.com', 'nicovideo.jp']:
             if self.url.find(site)>-1:
                 return site


    def buildOptions(self, verbose=False):
        ydl_opts = {}
        ydl_opts['playlistend'] = 1
        ydl_opts['debug_printtraffic'] =1
        ydl_opts['verbose'] = 1 #'dump_intermediate_pages': 'debug_printtraffic': 1}
        ydl_opts['socket_timeout'] = 60
        #2017.08.10
        if not sandboxEnable():
            ydl_opts['source_address'] = '0.0.0.0'
        ydl_opts['youtube_include_dash_manifest'] = True
        ydl_opts['youtube_include_dash_manifest_as_single_url'] = True
        ydl_opts['nocheckcertificate'] = self.url.find('xvideos.com') > -1
        ydl_opts['GA'] = GoogleAnalytics(gaid.ga2)        
        return ydl_opts

    def fixUrl(self, url):
        try:
            if not isinstance(url, compat_str):
                url = compat_str(url)
        except:
            pass
        if re.search(r'youtu.be/', url) is None:
            url = url.replace('&list=WL', '')
        else:
            url = url.replace('youtu.be/', 'youtube.com/watch?v=').replace('?list=', '&list=')

        if re.search(r'lynda\.com', url):
            url = url.replace('http://', 'https://')

        return url

    def getYoutubeDL(self, verbose=False):
        dl = self.YoutubeDLPatchCLS(self.buildOptions(verbose))

        if self.needCookie:
            debug('sniffer __importCookies__')
            self.__importCookies__(dl.cookiejar, self.getCookies())
        else:
            if self.account and self.needAccount:
                dl.params['username'] = self.account['username']
                dl.params['password'] = self.account['password']
        return dl


    def __importCookies__(self, Jar, cookiesStr):
        if sys.version_info >= (3, 0):
            from http import cookiejar
        else:
            import cookielib as cookiejar
        def make_cookie(domain, name, value):
            return cookiejar.Cookie(
                version=0,
                name=name,
                value=value,
                port=None,
                port_specified=False,
                domain=domain,
                domain_specified=True,
                domain_initial_dot=False,
                path="/",
                path_specified=True,
                secure=False,
                expires=None,
                discard=False,
                comment=None,
                comment_url=None,
                rest=None
            )
        try:
            domain = get_top_host(self.url)
            mobj = re.findall(r'(.+?)=(.+?);', cookiesStr)
            for key, value in mobj:
                Jar.set_cookie(make_cookie(domain, key, value))
        except:
            pass

    def getDefaultBrowser(self):
        if sys.platform[:3] == "win":
            if sys.version_info >= (3, 0):
                import winreg
            else:
                import _winreg as winreg
            result = ''
            try:
                key = winreg.OpenKey(winreg.HKEY_CURRENT_USER, r'Software\Microsoft\Windows\Shell\Associations\UrlAssociations\http\UserChoice')
                result, _ = winreg.QueryValueEx(key, 'Progid')
            except:
                try:
                    key = winreg.OpenKey(winreg.HKEY_CLASSES_ROOT, r'http\shell\open\command')
                    result, _ = winreg.QueryValueEx(key, '')
                except:
                    pass
            result = 'firefox' if result.lower().find('firefox') != -1 else ('chrome' if result.lower().find('chrome') != -1 else 'IE')
            debug('default Browser: %s' % result)
            return result

        elif sys.platform == 'darwin':
            return 'chrome'
        else:
            return ''

    def getCookies(self):
        debug('SinfferBase getCookies Begin')
        result = ''
        from Cookies import BrowserCookie
        browser = self._browser if self._browser and self._browser != '' else self.getDefaultBrowser()
        browsers = []
        if sys.platform[:3] == "win":
            browsers = [browser, 'chrome', 'firefox', 'IE']
        elif sys.platform == 'darwin':
            browsers = ['chrome', 'safari', 'firefox']
            #因为mac的特殊性获取chrome会弹出提示框，所以这里做特殊限制
            if browser in browsers:
                browsers.remove(browser)
                browsers.insert(0, browser)

        domain = get_top_host(self.url)
        for browser in browsers:
            try:
                debug('begin get cookies browers：'+browser)
                result = BrowserCookie.CookiesJar().getCookies(domain, browser=browser)
                if result != '':
                    debug('end get cookies browers：'+browser)
                    break
            except:
                debug(traceback.format_exc())
                pass

        debug('SinfferBase getCookies End')
        return result

    def _run(self):
        pass

    def _doCancel(self):
        pass

    def run(self):
        self._cancel = False
        t = threading.Thread(target=lambda : self._run())
        t.setDaemon(True)
        t.start()
        timeOut = False
        startTick = time.time()
        while t.isAlive() and (not self._cancel):
            if time.time() - startTick >= 1000:
                timeOut = True
                break
            t.join(10)
        if self._cancel or timeOut:
            self._doCancel()
        if self.callback:
            if self._cancel:
                self.callback({'event': 'sniffer_cancel'})
            elif timeOut:
                self.callback({'event': 'sniffer_error', 'error': 'timeout'})

    def cancel(self):
        self._cancel = True

class YoutubeSubtitle:
    def __init__(self, ydl):
        self.ydl = ydl
        self.ie = self.ydl._ies_instances.get('Youtube', self.ydl._ies_instances.get('youtube'))

    def get(self, url, needContent='False'):
        self.needContent = needContent == 'True'
        self.video_id = self.ie.extract_id(url)
        try:
            subtitles = self.get2(url, needContent)
            if subtitles:
                return subtitles
        except Exception as ex:
            print(ex)
            pass

        try:
            for el_type in ['&el=info', '&el=embedded', '&el=detailpage', '&el=vevo', '']:
                video_info_url = (
                    'https://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en'
                    % (self.video_id, el_type))
                subtitles = self.getSubtitles(video_info_url)
                if ( len(subtitles) > 0):
                    break
        except:
            return {}


    def extract_player_response(self, player_response):
        pl_response = str_or_none(player_response)
        if not pl_response:
            return
        pl_response = self.ie._parse_json(pl_response, '', fatal=False)
        if isinstance(pl_response, dict):
            return pl_response

    def get_automatic_captions(self):
        url = 'https://www.youtube.com/watch?v=%s&gl=US&hl=en&has_verified=1&bpctr=9999999999' % self.video_id
        webpage = self.request(url)
        subtitles = []
        player_config = self.ie._get_ytplayer_config(self.video_id, webpage)        
        player_response = None
        if not player_config:      
            param1 = self.ie._YT_INITIAL_PLAYER_RESPONSE_RE                  
            param2 = self.ie._YT_INITIAL_BOUNDARY_RE
            text = self.ie._search_regex((r'%s\s*%s' % (param1, param2), param1), webpage,'', default='{}')
            player_response = self.extract_player_response(text)             
            if not player_response:
                return subtitles                       

        try:
            if not player_response:
                args = player_config['args']
                player_response = args.get('player_response')
                if player_response and isinstance(player_response, compat_str):
                    player_response = self.ie._parse_json(
                        player_response, self.video_id, fatal=False)
            if player_response:
                captionTracks = player_response['captions']['playerCaptionsTracklistRenderer']['captionTracks']
                base_url = captionTracks[0]['baseUrl']
                parsed_sub_url = compat_urllib_parse_urlparse(base_url)
                for captionTrack in captionTracks:
                    langcode = captionTrack['languageCode']
                    if [subtitle for subtitle in subtitles if subtitle['lc']==langcode]:
                        continue
                    caption_qs = compat_parse_qs(parsed_sub_url.query)
                    ext = 'vtt'

                    caption_qs.update({
                        'tlang': [langcode],
                        'fmt': [ext],
                    })
                    caption_url = compat_urlparse.urlunparse(parsed_sub_url._replace(
                        query=compat_urllib_parse_urlencode(caption_qs, True)))

                    if caption_url:
                        if self.needContent:
                            content = self.getSubtitleContent(caption_url)
                            if content:
                                subtitles.append({'lc': langcode, 'lan': captionTrack['name']['simpleText'], 'content': content})
                        else:
                            subtitles.append({'lc': langcode, 'lan': captionTrack['name']['simpleText'], 'url': caption_url})
        finally:
            return subtitles


    def get_captions(self):
        try:
            subs_doc = self.ie._download_xml(
                'https://video.google.com/timedtext?hl=en&type=list&v=%s' % self.video_id,
                self.video_id, note=False)
        except Exception as ex:
            self.ie._downloader.report_warning('unable to download video subtitles')
            return {}

        subtitles = []
        for track in subs_doc.findall('track'):
            lang = track.attrib['lang_code']
            if len([subtitle for subtitle in subtitles if subtitle['lc']==lang])>0:
                continue
            lang_translated = track.attrib['lang_translated']

            ext = 'vtt'
            params = compat_urllib_parse_urlencode({
                'lang': lang,
                'v': self.video_id,
                'fmt': ext,
                'name': track.attrib['name'].encode('utf-8'),
            })

            caption_url = 'https://www.youtube.com/api/timedtext?' + params
            if self.needContent:
                content = self.getSubtitleContent(caption_url)
                if content:
                    subtitle = {'lc': lang, 'lan': lang_translated, 'content': content}
                else:
                    continue
            else:
                subtitle = {'lc': lang, 'lan': lang_translated, 'url': caption_url}
            subtitles.append(subtitle)
        return subtitles

    def get2(self, url, needContent='False'):
        subtitles = self.get_captions()
        if not subtitles:
            subtitles = self.get_automatic_captions()
        return subtitles

    def request(self, url):
        return self.ie._download_webpage(url, url)

    def getSubtitleContent(self, url):
        webpage = self.request(url)
        autoSubtitle = url.find('kind=asr')>-1
        return self.convertWebSRT2SRT(webpage, autoSubtitle)
        #return content

    def __fixAutoSubtitleBug(self, lines):
        range_ = ''
        newLines = []
        for i in range(0, len(lines)):
            line = lines[i]
            if line.find('-->') > -1:
                range_ = line
            else:
                if newLines:
                    if newLines[-1]['text'] == line:
                        oldRange = newLines[-1]['range'].split('-->')
                        newRange = range_.split('-->')
                        if i + 1 < len(lines):
                            if lines[i + 1].find('-->') > -1:
                                newLines[-1]['range'] = '%s-->%s' % (oldRange[0], newRange[1])
                        else:
                            newLines[-1]['range'] = '%s-->%s' % (oldRange[0], newRange[1])
                    else:                        
                        newLines.append({'range': range_, 'text': line})
                else:
                    newLines.append({'range': range_, 'text': line})
        content = ''
        for item in newLines:
            if content == '':
                content = '%s\n%s' % (item['range'], item['text'])
            else:           
                content = '%s\n%s\n%s' % (content, item['range'], item['text'])  
        return content  

    def convertWebSRT2SRT(self, webpage, autoSubtitle=False):
        timeStr = r'([0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{3}[ ]*-->[ ]*[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{3})'
        mobj = re.search(r'(%s[\s\S]+)' % (timeStr), webpage)
        p = re.compile(timeStr)
        content = mobj.group(0)
        content = re.sub(r'%s[ ]+([^\n]+)' % timeStr, lambda x: x.group(1), content)
        content = re.sub(r'<.+?>', '', content)
        content = re.sub(r'<\.+?>', '', content)

        lines = re.findall(r'(.*)\n', content)
        lines = [line for line in lines if line != '' and line != ' ']
        if autoSubtitle:
            content = self.__fixAutoSubtitleBug(lines)
        else:
            for line in lines:
                content = '%s\n%s' % (content, line)

        replace = convertTimeFormat().run
        content = p.sub(replace, content)
        return content


    def getSubtitles(self, url):
        subtitles = []
        webpage = self.request(url)
        if re.search(r'token', webpage):
            mobj = re.search(r'caption_tracks=([^&]+)', webpage)
            if mobj:
                list = compat_urllib_parse_unquote(mobj.group(1)).split(',')
                for item in list:
                    caption_url = compat_parse_qs(item)['u'][0]
                    lc = compat_parse_qs(item)['lc'][0]
                    lan = compat_parse_qs(item)['n'][0]
                    if self.needContent:
                        content = self.getSubtitleContent(caption_url + '&fmt=vtt')
                        if content:
                            subtitles.append({'lc': lc, 'lan': lan, 'content': content})
                    else:
                        subtitles.append({'lc': lc, 'lan': lan, 'url': caption_url + '&fmt=vtt'})
        return subtitles

class YoutubeThumbnail:
    def __init__(self, ydl):
        self.ydl = ydl
        self.ie = self.ydl._ies_instances.get('Youtube', self.ydl._ies_instances.get('youtube'))

    def getFileSize(self, url):
        try:
            from youtube_dl.utils import HEADRequest
            head_req = HEADRequest(url)
            head_response = self.ie._request_webpage(
                head_req, '',
                note=False, errnote='Could not send HEAD request to %s' % url,
                fatal=False)
            if head_response.code == 200:
                return (int)(head_response.headers.get('content-length'))
            else:
                return -1
        except:
            return -1

    def sniffer(self, url):
        self.video_id = self.ie.extract_id(url)
        try:
            thumbnailURL = 'https://img.youtube.com/vi/{0}/{1}'
                        
            items = [('720', thumbnailURL.format(self.video_id, 'maxresdefault.jpg')), 
                ('480', thumbnailURL.format(self.video_id, 'sddefault.jpg')),
                ('360', thumbnailURL.format(self.video_id, 'hqdefault.jpg')), 
                ('180', thumbnailURL.format(self.video_id, 'mqdefault.jpg'))]
            result = []
            for item in items:
                fileSize = self.getFileSize(item[1])
                if fileSize > 0:
                    result.append({'quality': item[0], 'ext': 'jpg', 'filesize': fileSize, 'url': item[1]} )
            return result
        except:
            return []    


    def request(self, url):
        return self.ie._download_webpage(url, url)

class urlRequestSinffer(sinfferBase):

    _videoInfos = None

    def OnVideoReceived(self, bstrXML):
        try:
            root = ET.fromstring(bstrXML)
            cookie = root.attrib['cookie']
            title = root.attrib['title']
            temp = None
            filesize = 0
            try:
                for item in root._children:
                    ext = item.attrib['type']
                    for iitem in item._children:
                        filesize = int_or_none(iitem.attrib['filesize'], default=0)
                        duration = int_or_none(iitem.attrib['duration'], default=0)
                        url = iitem.text
                        if filesize > 1024:
                            temp = {
                                'title': title,
                                'duration': duration,
                                'formats': [{
                                                'url': url,
                                                'ext': ext,
                                                'filesize': filesize,
                                            }],
                            }
            except:
                pass
            if temp:
                lastfileSize = self._videoInfos['formats'][0]['filesize'] if self._videoInfos else 0
                if filesize > 1024 * 1024 * 5:
                    if lastfileSize < filesize:
                        self._videoInfos = temp
                        return 1
        except:
            pass
        return 0

    def run4Win(self):
        from comtypes import CoInitializeEx
        import comtypes.client as cc
        from comtypes.client import GetEvents
        CoInitializeEx()
        urlRequest = cc.CreateObject('{A43DE495-3D00-47d4-9D2C-303115707939}')
        try:
            connection = GetEvents(urlRequest, self)
            urlRequest.Initialize()
            urlRequest.SetCookie(self.getCookies())
            urlRequest.RequestURL(self.url)
            count = 0
            while not self._cancel and count < 6 * 2 * 5:
                cc.PumpEvents(2)
                count += 1
        except Exception as e:
            pass
        finally:
            urlRequest.UnInitialize()
            self._data = self._videoInfos

    def run4Mac(self):
        def getStartInfo():
            IS_WIN32 = 'win32' in str(sys.platform).lower()
            if IS_WIN32:
                startupinfo = subprocess.STARTUPINFO()
                startupinfo.dwFlags = subprocess.CREATE_NEW_CONSOLE | subprocess.STARTF_USESHOWWINDOW
                startupinfo.wShowWindow = subprocess.SW_HIDE
                return startupinfo
            else:
                return None
        try:
            debug('------------------begin run4Mac--------------------')
            DynamicAnalysiser = os.getenv('KVDynamicAnalysiser')
            if not DynamicAnalysiser:
                DynamicAnalysiser = 'DynamicAnalysiser'
            args = [(DynamicAnalysiser)]
            args += ['-u', self.url]
            args = [encodeArgument(opt) for opt in args]
            #self._debug_cmd(args)
            env = os.environ.copy()
            proc = subprocess.Popen(args, stdin=subprocess.PIPE, stdout=subprocess.PIPE, env=env,
                                    startupinfo=getStartInfo())
            cursor_in_new_line = True
            proc_stderr_closed = False
            start = time.time()
            while not proc_stderr_closed and not self._cancel or time.time() - start > 120:
                # read line from stderr
                line = ''
                while True:
                    char = proc.stdout.read(1)
                    if not char:
                        proc_stderr_closed = True
                        break
                    if char in [b'\r', b'\n']:
                        break
                    try:
                        line += char.decode('ascii', 'replace')
                    except:
                        continue

                if not line:
                    # proc_stderr_closed is True
                    continue

                if isinstance(line, bytes):
                    line = line.decode('utf-8')
                if re.search(r'\"event\"', line):
                    if re.search(r'sniffer_error', line):
                        debug('urlRequestSinffer4Mac sniffer_error')
                        break
                    else:
                        filesize = 0
                        try:
                            mobj = re.search(r'{(.*)}', line)
                            if not mobj:
                                continue
                            line = '{%s}' % mobj.group(1)
                            temp = json.loads(line)
                            filesize = temp['formats'][0]['filesize']
                        except:
                            temp = None
                        if temp:
                            lastfileSize = self._videoInfos['formats'][0]['filesize'] if self._videoInfos else 0
                            if filesize > 1024 * 1024 * 5:
                                if lastfileSize < filesize:
                                    self._videoInfos = temp
                                    break
                else:
                    continue
            proc.wait()
            if not cursor_in_new_line:
                self.to_screen('')
        except Exception as e:
            debug('------------------run4Mac Exception--------------------')
            pass
        finally:
            debug('------------------end run4Mac--------------------')
            try:
                # if sys.platform != 'win32':
                #     proc.communicate(b'q')
                # else:
                proc.terminate()
            except:
                print(traceback.format_exc())
            #UrlRequest = None
            self._data = self._videoInfos

    def runSuperMan(self):
        #直接屏了，不然会弹出Chrome
        return False

        if sys.platform[:3] != 'win' or re.search(r'youtube\.com|youtu\.be', self.url):
            return False

        sucess = False
        errorMsg = None
        try:
            self._ydl = self.getYoutubeDL()
            result = self._ydl.extract_info('superMan://%s' % self.url, False)
            self._data = result
            sucess = result and ('formats' in result or 'entries' in result or 'url' in result)
        except Exception as ex:
            sucess = False
            errorMsg = ex.message
        finally:
            if not (errorMsg and errorMsg.find('kv_server no exists!')>-1):
                GA = self._ydl.params.get('GA', None)
            return sucess


    def _run(self):
        self._data = None
        if not self.runSuperMan():
            if sys.platform[:3] == 'win':
                self.run4Win()
            else:
                self.run4Mac()

    def getFormat(self):
        return self._data


class singleSinffer(sinfferBase):
    _subtitleGet = None
    _urlRequestSinffer = None

    QuickMode = False
    _Video_EXTS = Kown_Video_EXTS
    _Audio_EXTS = Kown_Audio_EXTS


    def fixUrl(self, url):
        url = super(singleSinffer, self).fixUrl(url)
        if re.search(r'youtube\.com', url):
            url = url.split('&list=')[0]
        return url

    def getFormats(self):
        return self._data

    def _getAudio(self, audios, videoExt):
        assert videoExt != ''
        selects = [f for f in audios if (f.get('ext', '').lower() == videoExt or (videoExt =='mp4v' and f.get('ext', '').lower()=='m4a'))]
        if len(selects)>0:
            return selects[0]
        elif len(audios) != 0:
            return audios[0]
        else:
            raise Exception('not find suite audio')

    def _video_formats_key(self, f, quality, proto_preferenceFrist, ext=None):
        qualityStr = 'height'

        VIDEO_ORDER = self._Video_EXTS
        if ext and ext.lower().strip('.') not in VIDEO_ORDER:
            VIDEO_ORDER.insert(0, ext.lower().strip('.'))
        preference = f.get('preference', -99) if 'preference' in f else -99
        preference = preference if preference else -99
        index_oder = 0
        try:
            try:
                index_oder = 0 if not 'ext' in f else VIDEO_ORDER.index(f['ext'].lower())
            except:
                index_oder = len(VIDEO_ORDER)
            protocol = f.get('protocol') or determine_protocol(f)
            proto_preference = 0 if protocol in ['http', 'https'] else (0.5 if protocol in ['rtsp','rtmp'] else 0.1)
        except:
            debug(traceback.format_exc())
            pass

        hv = f.get(qualityStr, '1')
        if hv == None: hv = 1
        if proto_preferenceFrist:
            list = [proto_preference, abs(int_or_none(hv, default=720) - quality), -preference, index_oder]
        else:
            list = [abs(int_or_none(hv, default=720) - quality), proto_preference, -preference, index_oder]
        try:
            list.extend([
                -(f.get('tbr') if f.get('tbr') is not None else -1),
                -(f.get('filesize') if f.get('filesize') is not None else -1),
                -(f.get('vbr') if f.get('vbr') is not None else -1),
                -(f.get('height') if f.get('height') is not None else -1),
                -(f.get('width') if f.get('width') is not None else -1),
                -(f.get('abr') if f.get('abr') is not None else -1),
                -(f.get('fps') if f.get('fps') is not None else -1)
                #f.get('format_id') if f.get('format_id') is not None else ''
            ])
        except:
            pass
        #print tuple(list)
        return tuple(list)


    def _audio_formats_key(self, f, ext):
        AUDIO_ORDER = self._Audio_EXTS
        if ext and ext.lower().strip('.') not in AUDIO_ORDER:
            AUDIO_ORDER.insert(0, ext.lower().strip('.'))
        try:
            index_oder = 0
            try:
                AUDIO_ORDER.index(f['ext'].lower())
            except:
                index_oder = len(AUDIO_ORDER)
            protocol = f.get('protocol') or determine_protocol(f)
            proto_preference = 0 if protocol in ['http', 'https'] else (0.5 if protocol in ['rtsp','rtmp'] else 0.1)
            preference = f.get('preference', -99) if 'preference' in f else -99
            preference = preference if preference else -99

            list = [
                proto_preference,
                -preference,
                index_oder
            ]
            try:
                list.extend([
                    -(f.get('tbr') if f.get('tbr') is not None else -1),
                    -(f.get('filesize') if f.get('filesize') is not None else -1),
                    -(f.get('abr') if f.get('abr') is not None else -1),
                ])
            except:
                pass
            return tuple(list)
        except:
            return (2, 2)


    def _splitVideoAndAudio(self, qulity, proto_preferenceFrist = False, ext=None):
        formats = self._data['result']['formats']
        formats2 = []
        notYoutube = not self._data['result']['extractor'].lower() == 'youtube'
        for f in formats:
            if f and ('ext' in f) and f['ext']:
                if f['ext'] in ['unknown_video', 'm3u8']:
                    f['ext'] = 'mp4'
                    if 'vcodec' in f:
                        f.pop('vcodec')
                elif notYoutube and f['ext'] == 'webm':#过滤掉WEB
                     continue
                try:
                   if self._data['result']['extractor'].lower() == 'youtube':
                       if 'format_id' in f and f['format_id'] in ['325', '328']:
                           continue
                except:
                   pass

                formats2.append(f)
                # if 'vcodec' in f and f['vcodec'] == None:
                #     f.pop('vcodec')

        formats = formats2

        videos = filter(lambda f: str(f.get('vcodec', 'none')).lower() != 'none' or ('ext' in f and f['ext'].lower() in self._Video_EXTS), formats)
        audios = filter(lambda f: 'ext' in f and f['ext'].lower() in self._Audio_EXTS or ('format_note' in f and f['format_note'] == 'DASH audio'), formats)
        #针对Youtube下audios里面混入了视频格式进行修正
        if not notYoutube:
            audios = [audio for audio in audios if not (audio.get('ext', 'none') == 'webm' and audio.get('acodec', 'none') == 'none')]

        audios = list(audios)
        audios.sort(key = lambda f: self._audio_formats_key(f, ext))
        videos = list(videos)
        videos.sort(key = lambda f: self._video_formats_key(f, qulity, proto_preferenceFrist, ext))
        return videos, audios

    def _safegetQuality(self, video, default):
        result = 'height' in video and video.get('height')
        if not result:
           result = default
        return result

    def _format_selector4Youtube(self, ext, quality):
        onlyNeedAudio = ext.lower() in ['mp3', '.mp3'] #and self._data['result']['extractor'].lower() == 'youtube'
        quality = 1 if onlyNeedAudio else int(quality)
        videos, audios = self._splitVideoAndAudio(quality, ext=ext if ext and ext.lower().find('webm')!=-1 else None)
        if onlyNeedAudio:  # 纯音频
            if len(audios) > 0:  #音频资源就够了
                #纯音频就不要下webm了
                audios = list(filter(lambda f: 'ext' in f and f['ext'] != 'webm', audios))
                return {'video': False, 'quality': 0, 'ext': 'mp3', 'formats': [audios[0]],
                        'action': 'none' if audios[0]['ext'].lower() == 'mp3' else 'convert2Mp3'}
            else:  #没有单独的音频
                videos = [f for f in videos if f['acodec'].lower() != 'none']
                if len(videos) > 0:  #有视频可以下载
                    return {'video': False, 'quality': 0, 'ext': 'mp3', 'formats': [videos[0]], 'action': 'convert2Mp3'}
                else:
                    return {'error': 'can\'t find resouce'}
        elif len(videos) > 0:  # 没有指定只下音频
            if len(videos)>2:
                if videos[0]['format_id'] == '22':#22 tag 这个有可能会下载后导致黑屏
                    videos.pop(0) 
            video = videos[0]
            if ('acodec' not in video) or (video.get('acodec', 'none') != 'none'):  #音视频完整的
                action = 'none' if self.url.find('bbc.co.uk')==-1 else 'fixM3u8'
                return {'video': True, 'quality': self._safegetQuality(video, quality), 'ext': video.get('ext', 'mp4'),
                        'formats': [video], 'action': action}
            elif len(audios) > 0:  #分离的
                videoExt = 'mp4v' if video['ext'].lower() == 'mp4' else video.get('ext', 'mp4')
                audio = self._getAudio(audios, videoExt.lower())
                if audio['ext'] == 'webm':
                    audio['ext'] = audio['acodec']

                return {'video': True, 'quality': self._safegetQuality(video, quality), 'ext': video.get('ext', 'mp4'),
                        'formats': [video, audio],
                        'action': 'dash_convert' if video['ext'].lower() == 'webm' else 'dash_merge'}
            else:  #没有找到可以用来匹配的音频
                return {'video': True, 'quality': self._safegetQuality(video, quality), 'ext': video.get('ext', 'mp4'),
                        'formats': [video], 'action': 'none'}
        elif len(audios) > 0:  # 没有视频资源，但是有音频将就用吧
            return {'video': False, 'quality': 0, 'ext': 'mp3', 'formats': [audios[0]],
                    'action': 'none' if audios[0]['ext'].lower() == 'mp3' else 'convert2Mp3'}
        else:  # 啥都没有
            return {'error': 'can\'t find resouce'}

    def __format_select_for_thumbnail(self, quality):
        items = YoutubeThumbnail(self._ydl).sniffer(self.url)
        select = None
        for item in items:
            if select == None:
                select = item
            value = int(item['quality'])
            if  value == quality:
                select = item                        
        return {'video': True, 'quality': select['quality'], 'ext': 'jpg','formats': [{'url': select['url'], 'ext': select['ext']}], 'action':'none'}

    def _format_selector(self,  quality, ext):
        if ext == 'jpg':
            self._data['thumbnail']= None
            self._data['subtitles']= None
            return self.__format_select_for_thumbnail(quality)
            
        dashFormats = [f for f in self._data['result']['formats'] if 'format_note' in f and f['format_note'] and f['format_note'].find('DASH audio')!=-1]
        if self._data['result']['extractor'].lower() == 'youtube' or len(dashFormats) > 0:
            return self._format_selector4Youtube(ext, quality)
        else:
            if 'result' in self._data and 'formats' in self._data['result']:
                videos, audios = self._splitVideoAndAudio(quality, proto_preferenceFrist=False)
                needAudio = ext.lower() in ['mp3', '.mp3']
                if needAudio:
                    if len(audios) > 0:
                        audio = audios[0]
                        return {'video': False, 'quality':0, 'ext': 'mp3', 'formats': [audio], 'action': 'none' if audio['ext'].lower() == 'mp3' else 'convert2Mp3'}
                    elif len(videos) > 0:
                        video = videos[0]
                        return {'video': True, 'quality': self._safegetQuality(video, quality), 'ext': 'mp3', 'formats': [video], 'action': 'convert2Mp3'}
                    else:
                        return {'error': 'can\'t find resouce'}
                else:
                    if len(videos) > 0:
                        video = videos[0]
                        action = 'none'
                        if self._data['result']['extractor'].lower() in ['toggle', 'youku', 'theplatform', 'bbc'] and video.get('protocol','').lower().find('m3u8')>-1:
                            action = 'fixM3u8'
                        if self._data['result']['extractor'].lower() in ['bbc.co.uk'] and video.get('protocol','').lower().find('f4m')>-1:
                             action = 'convertF4MToMP4'
                        return {'video': True, 'quality': self._safegetQuality(video, quality), 'ext': video.get('ext', 'mp4'),'formats': [video], 'action': action}
                    elif len(audios) > 0:
                        audio = audios[0]
                        if self.url.find('soundcloud.com') > -1 and sys.platform == 'win32':
                            return {'video': False, 'quality': '256', 'ext': audio.get('ext', 'mp4'), 'formats': [audio], 'action' : 'convert2Mp3' }
                        else:
                            return {'video': False, 'quality': 0, 'ext': audio.get('ext', 'mp4'),'formats': [audio], 'action' : 'none' }
                    else:
                        return {'error': 'can\'t find resouce'}
            else:
                return {'error': 'can\'t find resouce'}

    def format_selector(self, quality, ext='', subtitleLan=''):
        ext = ext if ext != '' else 'mp4'
        result = {}
        try:
            quality = int_or_none(quality, default= 720)
            details = self._data['result']
            if details.get('formats'):
                #普通的
                result = self._format_selector(quality, ext)
                result['thumbnail'] = self._data.get('thumbnail', '')
                #print(result['title'])
            elif details.get('entries'):
                #多段的特指Youku和列表下载
                result = {'video': 'True', 'quality': quality, 'formats': details['entries'], 'ext': ext, 'action': 'multi_video_merge' if len(details['entries']) > 1 else 'none'}
            else:
                result = {'event': 'download_error', 'error': 'can\'t find resouce'}

            result['title'] = decode_html(self._data.get('title', 'title'))
            try:
                if self._data.get('subtitles'):
                    subtitleLan = subtitleLan if subtitleLan else ''
                    if 'default' in self._data.get('subtitles'):
                        if subtitleLan != '':
                            langs = self._data.get('subtitles').keys()
                            if len(langs) > 0:
                                if subtitleLan in langs:
                                    selectLan = subtitleLan
                                else:
                                    selectLan = 'en' if 'en' in langs else langs[0]
                                result['subtitle_data'] = self._data['subtitles'][selectLan][0]['data']
                    else:
                        if subtitleLan != '':
                            try:
                                langs = [sub['lc'] for sub in self._data.get('subtitles')]
                                if len(langs)>0:
                                    selectLan = subtitleLan if subtitleLan in langs else 'en' if 'en' in langs else langs[0]
                                    if subtitleLan in langs:
                                        selectLan = subtitleLan
                                    else:
                                        eng_langs = [lang for lang in langs if lang.find('en')==0]
                                        selectLan = eng_langs[0] if eng_langs else None

                                    subtitleUrl = [sub['url'] for sub in self._data.get('subtitles') if sub['lc'] == selectLan]
                                    if len(subtitleUrl) > 0:
                                        result['subtitleUrl'] = subtitleUrl[0]
                            except:
                                if re.search(r'viki\.com|toggle\.sg|bbc\.co\.uk', self._data['webpage_url']):
                                    if subtitleLan not in self._data.get('subtitles'):
                                        subtitleLan = 'en' if 'en' in self._data.get('subtitles') else list(self._data.get('subtitles').keys())[0]
                                    subtitles = self._data.get('subtitles').get(subtitleLan, None)
                                    if re.search(r'bbc\.co\.uk', self._data['webpage_url']):
                                        if len(subtitles) > 0:
                                            try:
                                                data = self._ydl.urlopen(subtitles[0]['url']).read()
                                                data = dfxp2srt(data)
                                                result['subtitle_data'] = convertWebSRT2SRT(data, hasLineTag=True)
                                            except Exception as e:
                                                print(e)
                                                pass
                                    else:
                                        subtitles = [sub for sub in subtitles if sub['ext']=='srt']
                                        if len(subtitles) > 0:
                                            try:
                                                result['subtitle_data'] = self._ydl.urlopen(subtitles[0]['url']).read()
                                            except Exception as e:
                                                pass
            except:
                #字幕不要影响主流程
                debug(traceback.format_exc())
                pass
        except Exception as e:
            debug(traceback.format_exc())
        finally:
            return result


    def __formatResult__(self, result):
        debug('singleSinffer __formatResult__ Begin')
        if not result:
            return

        # 避免title直接取到空字串问题
        if 'title' in result and result['title'].strip() == '':
            result['title'] = 'unknown'
        try:
            self._data['title'] = decode_html(result.get('title', self.url)).replace('\n', '').replace('\t', '')
        except Exception as ex:
            print(ex)
            self._data['title'] = decode_html(result.get('title', self.url))

        self._data['duration'] = result.get('duration', 0)
        self._data['thumbnail'] = result.get('thumbnail', '')
        if '_type' in result and result['_type'] == 'playlist' and 'entries' in result:
            self._data['duration'] = result['entries'][0].get('duration', 0)
            self._data['thumbnail'] = result['entries'][0].get('thumbnail', '')
            if 'title' in result['entries'][0]:
                self._data['title'] = decode_html(result['entries'][0].get('title', self.url)).encode('UTF-8')


        self._data['webpage_url'] = result.get('webpage_url', self.url)
        self._data['result'] = {}
        self._data['result']['extractor'] = result.get('extractor', '')
        #处理多段和列表的情况
        if 'extractor_key' in result and result.get('extractor_key').lower() == 'youtubeplaylist':
            result['formats'] = self._data['result']['formats'] = result['entries'][0]['formats']
            self._data['result']['extractor'] = 'youtube'
        elif '_type' in result and result['_type'] == 'playlist' and 'entries' in result:
            if 'formats' in result['entries'][0]:
                self._data['result']['formats'] = result['entries'][0]['formats']
            else:
                self._data['result']['formats'] = [result['entries'][0]]
        elif '_type' in result and result['_type'] == 'multi_video':
            self._data['result']['entries'] = result['entries']
        elif 'formats' in result:
            self._data['result']['formats'] = result['formats']
        elif 'url' in result:
            item = {}
            item['url'] = result['url']
            if 'ext' in result:
                item['ext'] = result['ext']
            if 'protocol' in result:
                item['protocol'] = result['protocol']
            if 'http_headers' in result:
                item['http_headers'] = result['http_headers']
            self._data['result']['formats'] = [item]

        # 处理Youtube的情况
        if  self._data['result']['extractor'].lower() == 'youtube' or self.url.find('youtube.com')!=-1:
            from youtube_dl.WS_Extractor.youtube import YoutubeIE
            videos = {}
            ie = YoutubeIE()
            # filter httpDASH-fragments
            # result['formats'] = [f for f in result['formats'] if 'fragments' in f]
            # self._data['result']['formats'] = result['formats']
            formatsList = ie.get_formatsList()
            if self._data['result']['extractor'].lower() == 'youtube':
                for format in result['formats']:
                    if 'vcodec' in format and 'av01' in format['vcodec']:
                        continue
                    if ('format_note' in format and format['format_note'] != 'DASH audio'): #and ('ext' in format and format['ext'].lower() != 'webm'):
                        height = format.get('height', 720)

                        if 'subExtract' not in result:
                            if 'format_id' in format:
                                if format.get('format_id', 0) == '138':
                                    height = format['height'] = 4320
                                elif format.get('format_id', 0) == '272' and format.get('height', 720) >2160:
                                    height = format['height'] = 4320
                                elif (format['format_id'] in formatsList and 'height' in formatsList[format['format_id']]):
                                    height = format['height'] = formatsList[format['format_id']]['height']

                        key = 'quality_%s_ext_%s' % (height, format.get('ext', 'mp4'))
                        item = {'quality': height, 'ext': format.get('ext', 'mp4'), 'filesize': format.get('filesize', 0)}
                        if key not in videos:
                            videos[key] = []
                        videos[key].append(item)
            else:
                for format in result['formats']:
                    height = format.get('height', 720)

                    key = 'quality_%s_ext_%s' % (height, format.get('ext', 'mp4'))
                    item = {'quality': height, 'ext': format.get('ext', 'mp4'), 'filesize': format.get('filesize', 0)}
                    if key not in videos:
                        videos[key] = []
                    videos[key].append(item)
            quick = []

            #filter webm
            temp = {}
            for key in videos.keys():
                items = re.findall(r'quality_(\d+)_ext_(\w+)', key)
                item = items[0]
                if item[0] not in temp:
                    temp[item[0]] = []
                temp[item[0]].append(item[1])

            #------------------
            exts_order = ['mp4', 'webm', '3gp']
            keys = []
            for key, value in temp.items():
                value.sort(key = lambda ext : exts_order.index(ext) if ext in exts_order else len(exts_order) + 1)
                keys.append('quality_%s_ext_%s' % (key, value[0]))

            #keys = videos.keys()
            #------------------

            for key in keys:
                items = videos[key]
                items.sort(key=lambda item: int_or_none(item['filesize'], default=0), reverse = True)
                quick.append(items[0])
            quick.sort(key=lambda item: item['quality'], reverse = True)
            self._data['result']['quick'] = quick
            try:
                debug('sniffer getSutitles')
                if self._data['result']['extractor'].find('savefrom.net') > -1:
                    self._data['subtitles'] = None
                else:
                    self._data['subtitles'] = YoutubeSubtitle(self._ydl).get(self.url)
            except:
                self._data['subtitles'] = None

            try:
                debug('sniffer thumbnails')
                self._data['thumbnails'] = [ item for item in YoutubeThumbnail(self._ydl).sniffer(self.url)]
            except:
                self._data['thumbnails'] = None

        else:
            if 'subtitles' in result and result['subtitles'] and len(result['subtitles'])>0:
                self._data['subtitles'] = result['subtitles']

        debug('singleSinffer __formatResult__ End')

    def _doCancel(self):
        if self._urlRequestSinffer:
            self._urlRequestSinffer.cancel()

    def getLastError(self):
        if self.account:
            test = accountTest(self.account['site'], self.account['username'], self.account['password'])
            test._run()
            if test._data['event'] == 'accountTest_error' and test._data['error'] == 'account error':
                self.account_login_fail = True
                return test._data['error']
        return 'no result'

    def _run(self):
        error = None
        try:
            debug('singleSinffer run Begin')
            self.urlRequestSinffer = None
            hasTryLoginMode = False
            for i in range(2):
                debug('sniffer.py _run try %d' % i)
                debug('sniffer getYoutubeDL')

                # 对于https://www.youtube.com/watch?v=ivUYMzfNPko这样URL，这是个MTV列表https://www.youtube.com/watch?v=ivUYMzfNPko&list=RDivUYMzfNPko&start_radio=1，带cookies获取的url，是不能下载的。第一次解析，不带cookie
                if self.QuickMode:
                  self.needCookie = i == 1
                else:
                  if 'youtube' in self.url:
                    self.needCookie = i == 1
                  else:
                    self.needCookie = i == 0
                if hasTryLoginMode:
                    self.needAccount = False
                    if not self.needCookie:
                        self.needCookie = True

                if self.account and self.needAccount:
                    self.needCookie = False
                    hasTryLoginMode = True

                self._ydl = self.getYoutubeDL()

                result = None
                try:
                    result = self._ydl.extract_info(self.url, False)
                    if not result or not ('formats' in result or 'entries' in result or 'url' in result):
                        raise Exception(self.getLastError())
                except:
                    error = traceback.format_exc()
                    #动态尝试一次就好了
                    if i == 0:
                        debug('try urlRequestSinffer begin')

                        self._urlRequestSinffer = urlRequestSinffer(self.url)
                        try:
                            self._urlRequestSinffer._run()
                            result = self._urlRequestSinffer.getFormat()
                            if result:
                               result['extractor'] = 'urlRequestSinffer'
                               error = None
                            else:
                                #动态没有分析到所以跳出来继续其他的尝试
                                continue
                        except:
                            pass
                        finally:
                            self._urlRequestSinffer = None
                            debug('try urlRequestSinffer end')

                self.__formatResult__(result)

                msg = self._data.copy()
                if msg.get('result'):
                    debug('sniffer sucess1')
                    if msg['result'].get('quick'):
                        msg['formats'] = msg['result']['quick']
                    msg.pop('result')

                    if msg.get('subtitles'):
                        try:
                            msg['subtitles'] = [sub['lc'] for sub in msg.get('subtitles')]
                        except:
                            pass
                    msg['event'] = 'sniffer'
                    debug('sniffer sucess2')
                    break
                else:
                    if self._cancel:
                        break

                    if i == 1:#尝试超过2次那么认为异常了
                        debug(error)
                        raise Exception(error)
        except:
            debug('sniffer Error')
            error = traceback.format_exc()
            debug(error)

            msg = {
                'event': 'sniffer_error',
                'error': error,
                'webpage_url': self.url,
            }
            try:
                if self._ydl.params.get('GA', None) : 
                    error = re.search(r'ERROR\:(.+?)please report this issue on', error).group(1)
                    self._ydl.params.get('GA').send('event', 'analyticsFail', self.url, error[:])
            except:
                pass
        if self.callback:
            self.callback(msg)
        debug('singleSinffer run End')

class snifferPlayList(sinfferBase):
    YoutubeDLPatchCLS = YoutubeDLPatch4Playlist

    def formatDuration(self, duration):
        try:
            return parse_duration(str(duration))
        except:
            return 0.0

    def buildResult(self, entry):
        videoUrl = entry.get('url', '') if entry.get('ie_key', '').lower() != 'youtube' else \
            'https://www.youtube.com/watch?v=%s' % entry.get('url', '')
        return {'title': entry.get('title'), 'url': videoUrl, 'duration': self.formatDuration(entry.get('duration', '')), 'artist': entry.get('artist', '')}

    def appendEntry(self, entries, entry):
        self._lock.acquire()
        try:
            entries.append(entry)
        finally:
            self._lock.release()        


    def checkYoutubeCopyRight(self, entries, blockList):
        key = ''
        for entry in entries:
            key += ',' + entry['id']

        query_infos_url = 'https://www.googleapis.com/youtube/v3/videos?part=snippet%2Cconte' \
                        'ntDetails&key=AIzaSyAa8yy0GdcGPHdtD083HiGGx_S0vMPScDM&id=' + key
        ie = self._ydl._ies_instances.get('YoutubePlaylist')                        
        try:            
            result = ie._download_json(query_infos_url, query_infos_url, headers={'x-origin': 'https://explorer.apis.google.com'})
            
            for item in result['items']:
                if item.get('licensedContent', False) and item.get('regionRestriction', None):
                    if self.region in item['regionRestriction'].get('blocked', []):
                    #if ('US' or 'DK' or 'PL') in item['regionRestriction'].get('blocked', []):
                        self.appendEntry(blockList,item['id'])
                    elif self.region not in item['regionRestriction'].get('allowed', []):
                        self.appendEntry(blockList,item['id'])
        except:
            pass

    def getCurrentRegion(self):
        ie = self._ydl._ies_instances.get('YoutubePlaylist')
        try:
            ipaddr = ie._download_webpage('https://yt-dl.org/ip', 'https://yt-dl.org/ip')
            url = 'https://tools.keycdn.com/geo?host=%s' % ipaddr
            webpage = ie._download_webpage(url, url)
            mobj = re.search(r'Country</dt>.+?\((\w{2})\)</dd>', webpage)
            return mobj.group(1)
        except:
            return None

    def filterCopyrightVideo(self, jsonresult):
        
        if jsonresult and '_type' in jsonresult and jsonresult['_type'] == 'playlist':
            entries = jsonresult['entries']
            if not entries or entries[0]['ie_key'] != 'Youtube':
                return  

        self.region = self.getCurrentRegion()
        if not self.region:
            return

        self._lock = threading.Lock()
        entries = jsonresult['entries']
        Pagination = 10        
        threadList = []
        blockList = []
        for i in range(math.ceil(len(entries) / Pagination)):
            try:
                t = threading.Thread(target=self.checkYoutubeCopyRight, args=(entries[i * Pagination : (i + 1)*Pagination], blockList))
                threadList.append(t)
                t.setDaemon(True)
                t.start()
            except Exception as ex:
                print(ex)
                pass
        for t in threadList:
            t.join()
        for block in blockList:
            entries = [entry for entry in entries if entry['id'] != block]                        
        jsonresult['entries'] = entries
         

    def __formatResult__(self, jsonresult):
        self._data = {}
        if jsonresult and '_type' in jsonresult and jsonresult['_type'] == 'playlist':
            items = [self.buildResult(entry) for entry in  jsonresult['entries']]
            debug(len(items))
            self._data = {'name': jsonresult['title'], 'items':items}

    def _run(self):
        msg = {}
        hasTryLoginMode = False
        for i in range(3):
            self.needAccount = self.needCookie = i > 0

            if hasTryLoginMode:
                self.needAccount = False
                if not self.needCookie:
                    self.needCookie = True

            if self.account and self.needAccount:
                self.needCookie = False
                hasTryLoginMode = True

            try:
                debug('snifferPlayList run Begin')
                self._ydl = self.getYoutubeDL()
                result = self._ydl.extract_info(self.url, False)
                #self.filterCopyrightVideo(result)
                self.__formatResult__(result)
                msg = self._data.copy()
                msg['event'] = 'sniffer' if msg and (msg.get('items') and len(msg.get('items'))>0) else 'sniffer_error'
            except:
                msg['event'] = 'sniffer_error'
                msg['error'] = '%s' % traceback.format_exc()
                # if (self.url.find('searchMusic://')==-1) and (self.url.find('watch?v=')>-1):

            if msg['event'] != 'sniffer_error':
                break

        if self.callback:
            self.callback(msg)
        debug('snifferPlayList run End')

    def support(self):
        return len(list(filter(lambda ie: ie.suitable(self.url), self.getYoutubeDL()._ies))) > 0


class accountTest:

    def __init__(self, site, username, password, callback = None):
        debug('accountTest __init__ Begin')
        self.callback = callback

        self.site = site
        self.username = username
        self.password = password
        self._data = {}
        self._cancel = False

        debug('accountTest __init__ End')

    def buildOptions(self, verbose=False):
        ydl_opts = {}
        ydl_opts['playlistend'] = 1
        ydl_opts['debug_printtraffic'] =1
        ydl_opts['verbose'] = 1 #'dump_intermediate_pages': 'debug_printtraffic': 1}
        ydl_opts['socket_timeout'] = 60
        #2017.08.10
        if not sandboxEnable():
            ydl_opts['source_address'] = '0.0.0.0'
        ydl_opts['youtube_include_dash_manifest'] = True
        ydl_opts['youtube_include_dash_manifest_as_single_url'] = True
        ydl_opts['GA'] = GoogleAnalytics(gaid.ga2)
        
        ydl_opts['username'] = self.username
        ydl_opts['password'] = self.password
        return ydl_opts

    def getYoutubeDL(self, verbose=False):
        return YoutubeDLPatch4AccountTest(self.buildOptions(verbose))

    def _run(self):
        self._data = {}

        for i in range(3):
            try:
                debug('accountTest run Begin')
                result = self.getYoutubeDL().login(self.site)
                if (result == None and self.site == 'youtube.com'):
                    result = False
                self._data['event'] = 'accountTest_success' if result or result==None else 'accountTest_error'

            except:
                self._data['event'] = 'accountTest_error'
                self._data['error'] = '%s' % traceback.format_exc()

            if self._data['event'] != 'accountTest_error':
                break

        if self.callback:
            self.callback(self._data)
        debug('accountTest run End')

    def _doCancel(self):
        pass

    def run(self):
        self._cancel = False
        t = threading.Thread(target=lambda : self._run())
        t.setDaemon(True)
        t.start()
        timeOut = False
        startTick = time.time()
        while t.isAlive() and (not self._cancel):
            if time.time() - startTick >= 1000:
                timeOut = True
                break
            t.join(10)
        if self._cancel or timeOut:
            self._doCancel()
        if self.callback:
            if self._cancel:
                self.callback({'event': 'accountTest_cancel'})
            elif timeOut:
                self.callback({'event': 'accountTest_error', 'error': 'timeout'})

    def cancel(self):
        self._cancel = True



if __name__ == "__main__":
    sniffer = urlRequestSinffer('http://www.txxx.com/videos/1848412/nazuna-otoi-uncensored-hardcore-video-with-gangbang-dildos-toys-scenes/?source=0')
    sniffer.run()
    print(sniffer.getFormat())

    # list = ['searchMusic://metaTitle=Where Are Ü Now-Skrillex&metaArtist=Diplo&duration=4:12', 'https://www.youtube.com/channel/UCs0ifCMCm1icqRbqhUINa0w', 'https://www.lynda.com/Windows-tutorials/IoT-Development-Windows-10-IoT-Core-2-Enabling-Cloud-Security/556498-2.html']
    # for url in list:
    #     ss = snifferPlayList(url)
    #     if ss.support():
    #         ss.run()
