#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

from ..extractor.common import (
    InfoExtractor
)
from ..extractor.fc2 import (
    FC2IE as base,
    FC2EmbedIE as base2,
    hashlib,
    compat_urllib_request,
    compat_urlparse,
    ExtractorError
)

class FC2IE(base):
    _VALID_URL = r'^(?:https?://(?:video\.fc2\.com|(?:jinniumovie|chenghuavideo)\.be|shanximovie\.net)/(?:[^/]+/)*content/|fc2:)(?P<id>[^/]+)'

    def _real_extract(self, url):
        try:
            url = url.replace('jinniumovie.be', 'video.fc2.com').replace('chenghuavideo.be', 'video.fc2.com').replace('shanximovie.net', 'video.fc2.com')
            return super(FC2IE, self)._real_extract(url)
        except:
            return self._new_real_extract(url)


    def _new_real_extract(self, url):
        video_id = self._match_id(url)
        url = url.replace('jinniumovie.be', 'video.fc2.com').replace('chenghuavideo.be', 'video.fc2.com').replace('shanximovie.net', 'video.fc2.com')
        self._login()
        webpage = None
        if not url.startswith('fc2:'):
            webpage = self._download_webpage(url, video_id)
            self._downloader.cookiejar.clear_session_cookies()  # must clear
            self._login()
            webpage = self._download_webpage(url, video_id)
            PHPSESSID = self._get_cookies(url)['PHPSESSID'].value
            self._downloader.cookiejar.clear_session_cookies()  # must clear
            self._set_cookie('.fc2.com', 'PHPSESSID', PHPSESSID)


        title = 'FC2 video %s' % video_id
        thumbnail = None
        if webpage is not None:
            title = self._og_search_title(webpage, default=None) or self._html_search_regex(
            r'(?s)<title>(.*?)</title>', webpage, 'video title',
            default='video')
            thumbnail = self._og_search_thumbnail(webpage)
        refer = url.replace('/content/', '/a/content/') if '/a/content/' not in url else url

        mimi = hashlib.md5((video_id + '_gGddgPfeaf_gzyr').encode('utf-8')).hexdigest()

        info_url = (
            'http://video.fc2.com/ginfo.php?mimi={1:s}&href={2:s}&v={0:s}&fversion=WIN%2011%2C6%2C602%2C180&from=2&otag=0&upid={0:s}&tk=null&gk=123'.
            format(video_id, mimi, compat_urllib_request.quote(refer, safe=b'').replace('.', '%2E')))

        info_webpage = self._download_webpage(
            info_url, video_id, note='Downloading info page')
        info = compat_urlparse.parse_qs(info_webpage)
        video_url = None
        if 'filepath' not in info:
            if 'reason' in info:
                gk = info['reason'][0]
                info_url = (
                    'http://video.fc2.com/ginfo.php?mimi={1:s}&href={2:s}&v={0:s}&fversion=WIN%2011%2C6%2C602%2C180&from=2&otag=0&upid={0:s}&tk=null&gk={3:s}'.
                    format(video_id, mimi, compat_urllib_request.quote(refer, safe=b'').replace('.', '%2E'), gk))

                info_webpage = self._download_webpage(
                    info_url, video_id, note='Downloading info page')
                info = compat_urlparse.parse_qs(info_webpage)

                if 'err_code' in info:
                    # most of the time we can still download wideo even if err_code is 403 or 602
                    self.report_warning(
                        'Error code was: %s... but still trying' % info['err_code'][0])

                if 'filepath' not in info:
                    raise ExtractorError('Cannot download file. Are you logged in?')
            else:
                temp = 'https://video.fc2.com/api/v3/videoplaylist/%s?sh=1&fs=0' % video_id
                self._downloader.cookiejar.clear()  # must clear
                jsonData = self._download_json(temp, video_id, headers={'Referer': url})
                video_url = 'https://video.fc2.com' + jsonData['playlist']['nq']
                
        if video_url == None:
            video_url = info['filepath'][0] + '?mid=' + info['mid'][0]
            title_info = info.get('title', None)
            if title_info:
                title = title_info[0]

        return {
            'id': video_id,
            'title': title,
            'url': video_url,
            'ext': 'flv',
            'thumbnail': thumbnail,
        }


class FC2EmbedIE(base2):
    _VALID_URL = r'https?://video\.(?:fc2\.com|jinniumovie\.be)/flv2\.swf\?(?P<query>.+)'