#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys 
import threading

try:
    import Queue
except:
    
    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    ExtractorError,
    xpath_text,
    url_or_none,
    int_or_none,
    determine_ext
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs,
    compat_xpath
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, downloadWebPage_BYHeadlessBrowser_localFile

class AfreecaTVIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?afreecatv\.com/'

    def _real_extract(self, url):
        print('SockShare begin')
                
        webpage = self._download_webpage(url, 'embVideo_url') 
        # webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)

        url_query = self._search_regex(r'name="twitter:player"\s*value\=".+embed.php\?([^"]+)', webpage, 'embVideo_url')
        info_url = 'http://stbbs.afreecatv.com/api/video/get_video_info.php?'+ url_query #+ '&partialView=SKIP_ADULT'
        video_xml = self._download_xml(info_url, 'embVideo_url')
        video_element = video_xml.findall(compat_xpath('./track/video'))[-1]
        if video_element is None or video_element.text is None:
            raise ExtractorError(
                'Video %s video does not exist' % 'video_id', expected=True)
        title = xpath_text(video_xml, './track/title', 'title', fatal=True)
        thumb_url = xpath_text(video_xml, './track/titleImage', 'titleImage', fatal=True)
        video_url = video_element.text.strip()
        if video_url:           
            formats = self._extract_m3u8_formats(
                    video_url, 'video_id', 'mp4',
                    entry_protocol='m3u8_native', m3u8_id='hls', fatal=False)
            
            return {
                'id': 'id',
                'formats': formats,
                'title': title,
                'thumbnail': thumb_url
            }


        entries = []
        file_elements = video_element.findall(compat_xpath('./file'))
        one = len(file_elements) == 1
        for file_num, file_element in enumerate(file_elements, start=1):
            file_url = url_or_none(file_element.text)
            if not file_url or file_url.lower().find('hide.mp4') > -1:
                continue
            key = file_element.get('key', '')
            upload_date = self._search_regex(
                r'^(\d{8})_', key, 'upload date', default=None)
            file_duration = int_or_none(file_element.get('duration'))
            format_id = key if key else '%s_%s' % ('video_id', file_num)
            if determine_ext(file_url) == 'm3u8':
                formats = self._extract_m3u8_formats(
                    file_url, 'video_id', 'mp4', entry_protocol='m3u8_native',
                    m3u8_id='hls',
                    note='Downloading part %d m3u8 information' % file_num)
            else:
                formats = [{
                    'url': file_url,
                    'format_id': 'http',
                }]
            if not formats:
                continue
            self._sort_formats(formats)

            file_info= {
                'id': format_id,
                'title': title if one else '%s (part %d)' % (title, file_num),
                'duration': file_duration,
                'formats': formats,
            }
            entries.append(file_info)
        self._downloader.params['playlistend'] = -1
        result =  {
            'id': 'id',
            'title': title,
            'thumbnail': thumb_url,
             '_type': 'multi_video',
            'entries': entries,
        }        
        return result
            # webpage = self._download_webpage(embVideo_url, 'embVideo_url') 
            # v_id = self._search_regex(r'gaobook.review/v/(.+)', embVideo_url, 'v_id', fatal = False)
            # if v_id:
            #     jsondata = self._download_json("https://www.gaobook.review/api/source/%s" % v_id, v_id, data=urlencode_postdata({'d': 'www.gaobook.review'}))
                            
            #     formats = [{
            #         'format_id': item['label'].strip(),
            #         'url': item['file'],
            #         'width': item['label'].strip(),
            #         'ext': item['type']
            #     } for item in jsondata['data']]   
            #     print('kissasian end')         
            #     return {
            #         'id': v_id,
            #         'title': title,
            #         'formats': formats,                
            #     }            
            #else: 
            #    return self._hx_extract(url, js)
