# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys
import threading
import json

try:
    import Queue
except:

    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, \
    downloadWebPage_BYHeadlessBrowser_localFile

class DramaniceMovieIE(InfoExtractor):
    _VALID_URL = r'https?://(?:.+\.)?dramanice\.movie/'

    def _real_extract(self, url):
        print('SockShare begin')

        webpage = self._download_webpage(url, 'embVideo_url')
        title = self._search_regex(r'<title>(.*?)</title>', webpage, 'video_url')

        url_query = self._search_regex(r'<iframe src="(.*?)"\s+(.*)></iframe>', webpage, 'embVideo_url')

        webpage = self._download_webpage(url_query, 'embVideo_url')

        m3u8url = self._search_regex(r'sources:\[\{file: \'(.*?)\',(.*?)\}\],',webpage,'m3u8_url')
        if m3u8url.find('.m3u8')== -1:
            formats = []
            formats.append({
                'format_id': 'asnuf',
                'url': m3u8url,
            })
            return {
                '_type': 'video',
                'url':  m3u8url,
                'ie_key': DramaniceMovieIE.ie_key(),
                'id': 'asd',
                'formats':formats,
                'title': title,
            }
            # result = {
            #     '_type': 'url_transparent',
            #     'id': 'v_id',
            #     'title': title,
            #     'entries': parts,
            # }
            pass
        else:
            # tsList = self._extract_real_video_spice(m3u8url, configobj)
            # 解第一层m3u8.
            formats = self._extract_m3u8_formats_header(
                m3u8url, 'video_id', 'mp4',
                entry_protocol='m3u8_native', m3u8_id='hls', fatal=False, headers={"Referer": "http://kshows.to/"})

            realdownloadM3u8Url = formats[-1]["url"]

            webpage = self._download_webpage(realdownloadM3u8Url, 'embVideo_url',headers={"Referer": "http://kshows.to/"})
            formats = re.findall(r'([a-z0-9-.\S]+).ts',webpage)

            # formats = self._extract_m3u8_formats_header(
            #     realdownloadM3u8Url, 'video_id', 'mp4',
            #     entry_protocol='m3u8_native', m3u8_id='hls', fatal=False, headers={"Referer": "http://kshows.to/"})

            parts = []
            for part_url in formats:
                part = {
                    'id': part_url,
                    'title': 'part%s' % part_url,
                    'url': realdownloadM3u8Url[0:self.find_last(realdownloadM3u8Url,'/') + 1] + part_url + '.ts',
                    'ext': 'ts',
                    'http_headers': {
                        'Referer': 'http://kshows.to/'
                    },
                    'filesize': 1024 * 1024 * 2
                }
                parts.append(part)
            self._downloader.params['playlistend'] = -1

            result = {
                '_type': 'multi_video',
                'id': 'v_id',
                'title': title,
                'entries': parts,
            }
            return result

    def _extract_m3u8_formats_header(self, m3u8_url, video_id, ext=None,
                                     entry_protocol='m3u8', headers={}, preference=None,
                                     m3u8_id=None, note=None, errnote=None,
                                     fatal=True, live=False):
        if len(headers) > 0:
            res = self._download_webpage_handle(
                m3u8_url, video_id,
                note=note or 'Downloading m3u8 information',
                errnote=errnote or 'Failed to download m3u8 information',
                fatal=fatal, headers=headers)

        if res is False:
            return []

        m3u8_doc, urlh = res
        m3u8_url = urlh.geturl()

        return self._parse_m3u8_formats(
            m3u8_doc, m3u8_url, ext=ext, entry_protocol=entry_protocol,
            preference=preference, m3u8_id=m3u8_id, live=live)

    # def _extract_real_video_spice(self,realM3u8Url):
    #     formats = []
    #     webpage = self._download_webpage(realM3u8Url, 'embVideo_url')
    #     matchresult_tslist = re.findall(r'\d+_\d+.ts', webpage)
    def find_last(self,string,str):
        last_position=-1
        while True:
            position=string.find(str,last_position+1)
            if position==-1:
                return last_position
            last_position=position