# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
from ..extractor.dailymotion import DailymotionIE
import re
import sys
import threading

try:
    import Queue
except:

    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url,
    ExtractorError,
    xpath_text,
    url_or_none,
    int_or_none,
    determine_ext
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs,
    compat_xpath
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, \
    downloadWebPage_BYHeadlessBrowser_localFile

class DramaqDEIE(InfoExtractor):
    _VALID_URL = r'https?://(?:.+\.)?dramaq\.de/|https?://(?:.+\.)?lovetvshow\.info/'

    def insert_info_extractor(self, ie):
        self._ies.insert(1, ie)
        if not isinstance(ie, type):
            self._ies_instances[ie.ie_key()] = ie
            ie.set_downloader(self)

    def _real_extract(self, url):
        print('SockShare begin')
        js = '''function output(txt){
                                if (window.external){
                                    window.external.output(txt);
                                }
                                if (window.WebViewJavascriptBridge){
                                    window.WebViewJavascriptBridge.callHandler('JSSendToOC', txt);
                                }
                }
                if(document.URL.indexOf('dramaq.de') > -1){
                    var alist = document.getElementsByClassName('holder scrollbarx')[0].getElementsByTagName('a');
                    for(var i=0;i<alist.length;i++){
                        if(alist[i].text.indexOf('Dailymotion')>0){
                            alist[i].click();
                            break;
                        }
                    }
                }
                var vf = document.getElementsByTagName("iframe");
                if  (vf && vf.length>0){
                    for(var i=0;i<vf.length;i++){
                        if(vf[i].getAttribute("src").indexOf('dailymotion.com')>-1){
                            var v_url = vf[i].getAttribute("src");
                            var p_url = "";
                            output('<video id="kv_player" src="' + v_url + '" thumbnail="' + p_url + '" />');
                            break;
                        }
                    }
                    output('<video id="kv_player" src="' + v_url + '" thumbnail="' + p_url + '" />');
                }'''

        webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)
        if 'kv_player' in webpage:
            embVideo_url = self._search_regex(r'<video\s+id="kv_player"\s+src="([^"]+)"', webpage, 'video_url')
            if embVideo_url.find('http:') < 0 and embVideo_url.find('https:') < 0:
                embVideo_url = 'https:' + embVideo_url
        if embVideo_url:
            print(embVideo_url)
            dailymotion = DailymotionIE()
            # dailymotion.set_downloader()
            dailymotion.set_downloader(self._downloader)
            result = dailymotion.real_extract_api(embVideo_url)
            # result = dailyMotion.real_extract_api(
            #     'https://www.dailymotion.com/embed/video/k2VLFvSUNfQLtuvi3Re?info=0&amp;autoplay=0')
            return result

        # webpage = downloadWebPage_BYHeadlessBrowser_withJS(url, js)