#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)
from ..utilsEX import url_result
class educbaListIE(InfoExtractor):   
    #https://www.educba.com/my-courses/course-lessons.php?xcdi=290
    _VALID_URL = r'https?://(?:.+\.)?educba\.com/my-courses/course-lessons.php\?xcdi=(?P<id>\d+)'

    def _real_extract(self, url):
        webpage = self._download_webpage(url, '')    
        title = self._html_search_regex(r'<h2.+?>(.+)</h2>', webpage, 'title')
        playlist_id = self._match_id(url)
        webpage = self._download_webpage('https://www.educba.com/my-courses/lz_load-np.php?start=0&xcdi={0}'.format(playlist_id), '')
        
        ids = re.findall(r'<li id = "li_topic_(\d+)">.+?</i>([^<]+)', webpage)        
        entries = [url_result('https://www.educba.com/my-courses/pnn.php?id=li_topic_{0}&xcdi={1}'.format(id, playlist_id), 'educba', video_title=title.replace('&nbsp;', ''), video_duration='02:00') for id,title in ids]
            
        return {
            '_type': 'playlist',
            'id': playlist_id,
            'title': title,
            'entries': entries,
        }

class educbaIE(InfoExtractor): 
    _VALID_URL = r'https?://(?:.+\.)?educba\.com/my-courses/pnn.php\?id=li_topic_(?P<id>\d+)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        data = self._download_json(url, video_id)
               
        return {
            '_type': 'video',
            'id': video_id,
            'title': data['name'],
            'url': data['final_url']
        }