# coding: utf-8
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor
from ..extractor.facebook import FacebookIE

class facebookLiveIE(InfoExtractor):
    IE_NAME = 'facebookLive'
    _VALID_URL = r'https?://(?:www\.)?facebook.com/watch/live/\?v=(?P<id>[0-9]+)'    

    def _real_extract(self, url):            
        webpage = self._download_webpage(url, url)
        video_id = self._match_id(url)  
                  
        iframe_url = self._search_regex(r'video\:{id\:"\d+",url:"([^"]+)', webpage, 'iframe', fatal=False)
        if iframe_url:
            return {
                '_type': 'url_transparent',
                'ie_key': FacebookIE.ie_key(),
                'url': iframe_url,
                'id': video_id,
            }
        else:
            return {
                '_type': 'url_transparent',
                'ie_key': FacebookIE.ie_key(),
                'url': url,
                'id': video_id,
            }
            
        
                       