# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

import json

import hashlib

from ..extractor.common import (
    InfoExtractor,
)
from ..extractor.lynda import (
    LyndaBaseIE,
    LyndaIE as OldLyndaIE
)

from ..utils import (
    int_or_none,
    ExtractorError,
    qualities,
    js_to_json
)

from ..utilsEX import downloadWebPage_BYHeadlessBrowser_localFile

class fanstuiIE(InfoExtractor):
    #https://edu.51cto.com/course/21671.html
    _VALID_URL = r'https?://(?:www\.)?(?:fanstui|duboku)\.(?:com|net|tv)/vodplay/(?P<id>.+)'

    def _real_extract(self, url):
        #https://v.wedubo.com/20190910/Q8A7o1Om/index.m3u8
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, url)
        mobj = re.findall(r'<span class="vod_history hide" data-name="([^"]+).+?data-part="([^"]+)', webpage)
    
        title = mobj[0][0] + mobj[0][1] if mobj else None
        if not title:
            title = self._search_regex(r'<title>(.+)</title>', webpage, 'video title')

        json_str = self._search_regex(r'var player_data=(.+?)</script>', webpage, 'ebm_url')
        data = json.loads(json_str)

        formats = self._extract_m3u8_formats(data['url'], '', 'mp4',
                entry_protocol='m3u8_native', m3u8_id='hls', fatal=False)

        self._sort_formats(formats)        
        
        return {
            'id': '',
            'title': title,
            'formats': formats
        }