# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
from ..extractor.common import InfoExtractor

# https://filmovi.ws
# https://andrija-i-andjelka.com
# https://filmovitica.com
# https://serijefilmovi.com
# https://serijehaha.com
# https://praveserije.com
# https://www.filmovi.me
# 此网站群，都是偷openload视频
class FilmoviIE(InfoExtractor):
    # https://filmovi.ws/juzni-vetar-2018-domaci-film-gledaj-online/
    # https://www.filmovi.me/the-horse-whisperer-1998
    _VALID_URL = r'https?://(?:www\.)?(?:filmovi|andrija-i-andjelka|filmovitica|serijefilmovi|serijehaha|praveserije)\.\w+/(?P<id>[^/]+)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, video_id)

        # 找引用的openload链接
        # <div style="margin: auto; text-align: center;">
        # <p>PLAYER</p>
        # <p><iframe src="https://serije.pw/openload/player.php?id=908fdc9d-d674-4d93-8e5b-cff4fd1029c4" scrolling="no" frameborder="0" width="900" height="730" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></p>
        # </div>
        # https://www.filmovi.me/beowulf-2007
        # <iframe src="https://openload.co/embed/SBqoBx876Fg/" scrolling="no" frameborder="0" width="700" height="430" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe>
        video_url = self._search_regex(r'<iframe[^>]+?src="(.*?openload.*?[^"]+)', webpage, 'video_url', fatal=False)
        if video_url:
            return self.url_result(video_url)

        # 再找其它链接
        video_url = self._search_regex(r'(?is)<p>PLAYER</p>.*?<iframe[^>]+?src="([^"]+)', webpage, 'video_url', fatal=False)
        if video_url:
            return self.url_result(video_url)

        video_url = self._search_regex(r'(?is)<div class="embed">.*?<iframe[^>]+?src="([^"]+)', webpage, 'video_url', fatal=False)
        if video_url:
            return self.url_result(video_url)

        return super(PrageruIE, self)._real_extract(url)