#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse, compat_urllib_parse
from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
)

from ..utilsEX import url_result

class gatechIE(InfoExtractor):    
#https://mediaspace.gatech.edu/media/Bill+Campbell+-+Astral+TravelingA+Exploring+Afro+Past%2C+Present%2C+and+Futures/1_st6k4thu
    _VALID_URL = r'https?://mediaspace\.gatech\.edu/(?:media/.+/|media/)(?P<id>[^\\]+)$'

    def _real_extract(self, url):
        video_id = re.match(self._VALID_URL, url).groups()[0]        
        webpage = self._download_webpage(url, '')
        player_url = self._search_regex(r'src="(https\://cdnapisec\.kaltura\.com/[^"]+)/embedIframeJs', webpage, '123123', fatal=False)
        m3u8_url = '%s/playManifest/entryId/%s/format/applehttp/protocol/https/a.m3u8' % (player_url, video_id)
        formats = self._extract_m3u8_formats(m3u8_url, video_id, 'mp4')
        title = self._html_search_regex(r'<h3 class="entryTitle">\s*(.+)\s*</h3>', webpage, 'title')
        return {
            'id': video_id,
            'title': title,
            'formats': formats
        }
        

class gatechPlaylistIE(InfoExtractor):    
    #https://mediaspace.gatech.edu/playlist/dedicated/74258101/1_g5xwvbde/1_iw8fk73m
    _VALID_URL = r'https?://mediaspace\.gatech\.edu/playlist/dedicated/\d+/([^\\]+)/([^\\]+)'

    def _real_extract(self, url):
        playlistId, video_id = re.match(self._VALID_URL, url).groups()
        
        webpage = self._download_webpage(url, '')        
        uiconf_id, partner_id = re.findall(r'src=.+/uiconf_id/(\d+)/partner_id/(\d+)', webpage)[0]
        wid = self._search_regex(r'\'wid\'\:\s*\'(_\d+)', webpage, 'wid', fatal=False)
        player_url = self._search_regex(r'src="(https\://cdnapisec\.kaltura\.com/[^"]+)', webpage, '123123', fatal=False)
        webpage = self._download_webpage(player_url, '')
        version = self._search_regex(r'https\://cdnapisec\.kaltura\.com/html5/html5lib/(v.+)/load\.php', webpage, '123123', fatal=False)
        info_url = 'https://cdnapisec.kaltura.com/html5/html5lib/%s/mwEmbedFrame.php' % version        
        
        query = {
            'wid': wid,
            'uiconf_id': uiconf_id,
            'flashvars[playlistAPI]': {
                "layout":"vertical",
                "kpl0Id": playlistId,
                "initItemEntryId": video_id
            }
        }

        playlistAPI = compat_urllib_parse.quote(json.dumps({
                "layout":"vertical",
                "kpl0Id": playlistId,
                "initItemEntryId": video_id
        }))
        info_url = '%s?wid=%s&uiconf_id=%s&flashvars[playlistAPI]=%s' %(info_url, wid, uiconf_id, playlistAPI)
        webpage = self._download_webpage(info_url, '')
        f = open(r"d:/demofile2.txt", "w")
        f.write(webpage)
        f.close()
        text = self._search_regex(r'window\.kalturaIframePackageData\s*=\s*({.+}]}});', webpage, '123123', fatal=False)
        infos = json.loads(text)
        playlist = infos['playlistResult'][playlistId]
        title = playlist['name']        
        entries = [url_result('https://mediaspace.gatech.edu/media/%s' % item['id'], ie='gatech', video_id= item['id'], video_title=item['name'], video_duration=int(item['msDuration'] / 1000)) for item in playlist['items']]
        return {
            '_type': 'playlist',
            'id': playlistId,
            'title': title,
            'entries': entries
        }

 