#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor

from ..compat import (
    compat_urllib_parse_urlencode,
    compat_urllib_request
)
class GyaoIE(InfoExtractor):
    IE_NAME = 'gyao.yahoo.co.jp'
    _VALID_URL = r'https?://gyao.yahoo.co.jp'
    _TEST = {
        'url': 'http://gyao.yahoo.co.jp/player/00597/v12448/v1000000000000003690/?list_id=1654725',
    }

    def extractFromBCPlayer(self, title, video_id, webpage):

        player_url = 'https://s.yimg.jp/images/gyao/bc-player/hls/player.gyao.js?0004'
        space_id = self._html_search_regex(r'data-spaceid=[\'"]([^\'"]+)', webpage, 'space_id')
        service_id = self._html_search_regex(r'data-serviceid="([^"]+)', webpage, 'data-serviceid')
        video_uni_id = self._html_search_regex(r'data-vid=[\'"]([^\'"]+)', webpage, 'data-vid')
        index_min_js_url = self._html_search_regex(r'href="(https://players.brightcove.net/.*/index\.min\.js)', webpage, 'production_id')
        webpage = self._download_webpage(player_url, player_url)
        #account = self._html_search_regex(r'videoElement\.setAttribute\("data-account","([^"]+)', webpage, 'account')
        account = self._html_search_regex(r'module.exports={dash\:{accountId:"([^"]+)', webpage, 'account')
        production_id = self._html_search_regex(r'production:"([^"]+)', webpage, 'production_id')
        #index_min_js_url = self._html_search_regex(r'BC_PLAYER_URL="([^"]+)', webpage, 'index_min_js_url')
        webpage = self._download_webpage(index_min_js_url, index_min_js_url)
        app_id = self._html_search_regex(r'var n="(.{56})"', webpage,'index_min_js_url')  # m="dj0zaiZpPXFuMjk4YTJZcU4wUCZzPWNvbnN1bWVyc2VjcmV0Jng9YjQ-";
        # query = compat_urllib_request.quote(' query Playback($videoId: ID!, $logicaAgent: LogicaAgent!, $clientSpaceId: String!, $os: Os!, $device: Device!) { content( parameter: { contentId: $videoId logicaAgent: $logicaAgent clientSpaceId: $clientSpaceId os: $os device: $device view: WEB } ) { tracking { streamLog vrLog stLog } inStreamAd { forcePlayback source { ... on YjAds { __typename ads { location positions time urlWhenNoAd } spaceId } ... on Vmap { __typename url } ... on CatchupVmap { __typename url siteId } } } video { id title delivery { id drm } duration images { url width height } cpId playableAge maxPixel embeddingPermission playableAgents gyaoUrl } } } &variables={"videoId":"%s","logicaAgent":"PC_WEB","clientSpaceId":"%s","os":"UNKNOWN","device":"PC"}' %\
        #     (video_uni_id, space_id))
        query = '%20query%20Playback(%24videoId%3A%20ID!%2C%20%24logicaAgent%3A%20LogicaAgent!%2C%20%24clientSpaceId%3A%20String!%2C%20%24os%3A%20Os!%2C%20%24device%3A%20Device!)%20%7B%20content(%20parameter%3A%20%7B%20contentId%3A%20%24videoId%20logicaAgent%3A%20%24logicaAgent%20clientSpaceId%3A%20%24clientSpaceId%20os%3A%20%24os%20device%3A%20%24device%20view%3A%20WEB%20%7D%20)%20%7B%20tracking%20%7B%20streamLog%20vrLog%20stLog%20%7D%20inStreamAd%20%7B%20forcePlayback%20source%20%7B%20...%20on%20YjAds%20%7B%20__typename%20ads%20%7B%20location%20positions%20time%20urlWhenNoAd%20%7D%20spaceId%20%7D%20...%20on%20Vmap%20%7B%20__typename%20url%20%7D%20...%20on%20CatchupVmap%20%7B%20__typename%20url%20siteId%20%7D%20%7D%20%7D%20video%20%7B%20id%20title%20delivery%20%7B%20id%20drm%20%7D%20duration%20images%20%7B%20url%20width%20height%20%7D%20cpId%20playableAge%20maxPixel%20embeddingPermission%20playableAgents%20gyaoUrl%20%7D%20%7D%20%7D%20&variables=%7B%22videoId%22%3A%22'+ video_uni_id +'%22%2C%22logicaAgent%22%3A%22PC_WEB%22%2C%22clientSpaceId%22%3A%22'+ space_id +'%22%2C%22os%22%3A%22UNKNOWN%22%2C%22device%22%3A%22PC%22%7D'
        url2 = 'https://gyao.yahoo.co.jp/apis/playback/graphql' 
        url2 += '?appId=' + app_id
        url2 += '&query=' + query

        #query = compat_urllib_request.quote(' query Playback($videoId: ID!, $logicaAgent: LogicaAgent!, $clientSpaceId: String!, $os: Os!, $device: Device!) { content( parameter: { contentId: $videoId logicaAgent: $logicaAgent clientSpaceId: $clientSpaceId os: $os device: $device view: WEB } ) { tracking { streamLog vrLog stLog } inStreamAd { forcePlayback source { ... on YjAds { __typename ads { location positions time urlWhenNoAd } spaceId } ... on Vmap { __typename url } ... on CatchupVmap { __typename url siteId } } } video { id title delivery { id drm } duration images { url width height } cpId playableAge maxPixel embeddingPermission playableAgents gyaoUrl } } } &variables={"videoId":"%s","logicaAgent":"PC_WEB","clientSpaceId":"%s","os":"UNKNOWN","device":"PC"}'
        
        #url2 = 'https://gyao.yahooapis.jp/rio/getVideo'
        # query = {
        #     'appid': app_id,
        #     'output': 'json',
        #     'space_id': space_id,
        #     'domain': 'gyao.yahoo.co.jp',
        #     'start': '1',
        #     'results': '1',
        #     'service_id': service_id,  # 'gy
        #     'video_uni_id': video_uni_id,
        #     'device_type': '1100',
        #     'delivery_type': '2,6',
        #     'premiumgyao_limited_contents_flag': '1',
        #     'callback': 'jsonp_1499686946866_5949'
        # }
        jsonData = self._download_json(url2, url2, headers={'Accept':'*'})
        deliveryId = jsonData['data']['content']['video']['delivery']['id']
        #deliveryId = self._search_regex(r'"deliveryId":([^\"]+),"deliveryType":6', webpage, 'deliveryId')
        url3 = 'https://edge.api.brightcove.com/playback/v1/accounts/%s/videos/%s' % (account, deliveryId)
        program_info = self._download_json(
            url3, video_id,
            headers={
            'Accept': 'application/json;pk=BCpkADawqM3UI7LN8vy-xZ-f0EG6Xuch56dMQLuXX-VST0YZFntoAghnCk04EswbZ56BAX20HkAWwYw5M4YbCcSRWgDNcGlbKIUOlw2DNT15MyrRvG2n2y3WAoy1IWfTAlhMgZLc2pa3rZPbjCB23KBFaGZ1ezN5bgDFpOCQ4Rmb8MAx3BSPVrsprtQ'})
        formats = [{
                       'ext': 'm3u8',
                       'url': program_info['sources'][0]['src'],
                   }]
        return {
            'id': video_id,
            'title': title,
            'formats': formats,
            'duration': program_info['duration'],
            'thumbnail': program_info['thumbnail']
        }

    def _real_extract(self, url):
        self.url = url
        webpage = self._download_webpage(url, url)
        title = self._html_search_regex(r'<title>(.+)</title>', webpage, 'title')
        video_id = self._search_regex(r'video_uni_id=(.+?)"', webpage, 'video_id')
        try:
            return self.extractFromGYAOPlayer(title, video_id, webpage)
        except:
            return self.extractFromBCPlayer(title, video_id, webpage)


    def extractFromGYAOPlayer(self, title, video_id, webpage):
        player_url = self._html_search_regex(r'(https\://players\.brightcove\.net\/.+?_default/index\.min\.js)', webpage, 'player_url')
        video_id = self._html_search_regex(r'play\?video_id\=([^"]+)', webpage, '')
        param2 = self._html_search_regex(r'data-spaceid="([^"]+)', webpage, '')        
        version_id = self._html_search_regex(r'brightcove.net/(\d+)', player_url, 'player_url')
        webpage = self._download_webpage(player_url, player_url)
        pk = self._html_search_regex(r',policyKey\:"([^"]+)', webpage, 'player_url')
        #BCpkADawqM11VGWfl-kgRn1FeLbA06WvN_D77Yq-cRmzL_kREHmSFyM2HT-ZTbMWTo3X7h3uSKVy1DG_mI6t8TxdTnwtEMSz3LlZEZiI7brMsSqxCe2a9AWqdnUnCQShPRlrAj1FlaYUHSHE5v5JpmOVNLWym3HbAKYW2a_NeYBq2M7pEmLQNBImkdA
        headers = {
            "Accept": "application/json;pk=%s" %  pk,
            "Referer": self.url
        }
        
        json_url = 'https://gyao.yahoo.co.jp/dam/v1/videos/' + video_id + '?fields=title%2Cid%2CwebUrl%2Cduration%2Cimages%2ClongDescription%2Ccast%2Cstaff%2Ccopyright%2CstartDate%2CendDate%2CvideoUrl%2CvideoId%2Cdrm%2Crbop%2CembeddingPermission%2CexternalPlaybackPermission%2CinStreamAd%2CauthRequired%2CstreamBeacon%2CplayableAgents%2CcpId%2Coptions&streaming_availability=available&space_id=' + param2
        data = self._download_json(json_url, json_url)
        data = self._download_json("https://edge.api.brightcove.com/playback/v1/accounts/%s/videos/%s" %(version_id,  data['videoId']), '', headers=headers)
        source = data["sources"][0]
        formats = self._extract_m3u8_formats(source['src'], '', 'mp4')
        return {
            'id': video_id,
            '_type': 'video',
            'title': data['name'],
            'formats': formats,
            'ext': 'mp4',
        }        
        #'https://players.brightcove.net/4235717419001/SyG5P0gjb_default/index.min.js
        # try:
        #     player_url = self._html_search_regex(r'src="(.+)\/player.js.*?">', webpage,
        #                                          'player_url') + '/player.js'
        # except:
        #     player_url = 'http://i.yimg.jp/images/gyao/player/js/player.js'
        # webpage = self._download_webpage(player_url, player_url)
        # appID = self._html_search_regex(r'APPID\s*:\s*"(.+?)"', webpage, 'appID')
        # appKey = self._html_search_regex(r'GATE_WAY_APP_KEY\s*:\s*"(.+?)"', webpage, 'GATE_WAY_APP_KEY')
        # video_url = 'https://gw.gyao.yahoo.co.jp/v1/hls/%s/variant.m3u8?device_type=1100&' \
        #             'delivery_type=2&min_bandwidth=246&appkey=%s&appid=%s' % (video_id, appKey, appID)
        # return {
        #     'id': video_id,
        #     '_type': 'video',
        #     'title': title,
        #     'url': video_url,
        #     'ext': 'mp4',
        # }


'''
http://gyao.yahoo.co.jp/player/00597/v12416/v1000000000000003678/?list_id=1654725
http://i.yimg.jp/images/gyao/bc-player/player.gyao.js?0002
http://players.brightcove.net/4235717419001/H17bGYqS_default/index.min.js
https://vod01-gyao.c.yimg.jp/4235717419001/4235717419001_4971788934001_4971736491001.mpd

GET https://edge.api.brightcove.com/playback/v1/accounts/4235717419001/videos/4971736491001 HTTP/1.1
Accept: application/json;pk=BCpkADawqM2QSOsdGmTVDZ4_Y10f_FHAfpcCmG99ZZC4tNNQclHy44k7klaWnFhZLQvByouh2G0bkPY7xOC5sYPx-Ich7wVBIHCSLxsH-r0eps_GbXxXpMa96eHTJEb_G404XOUt-hpkg21S
Referer: http://gyao.yahoo.co.jp/player/00597/v12416/v1000000000000003678/?list_id=1654725
Accept-Language: zh-Hans-CN,zh-Hans;q=0.8,en-US;q=0.5,en;q=0.3
Origin: http://gyao.yahoo.co.jp
Accept-Encoding: gzip, deflate
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10240
Host: edge.api.brightcove.com
Connection: Keep-Alive
Cache-Control: no-cache


HTTP/1.1 200 OK
Content-Type: application/json; charset=UTF-8
Content-Length: 1736
Connection: keep-alive
access-control-allow-origin: *
access-control-expose-headers: x-cache,via,bcov-debug-cache-stats,bcov-instance,x-amz-cf-id
BCOV-instance: i-58dfacc4, ca69ff2, 2016-07-07 07:59:18.679Z
Cache-Control: max-age=0, no-cache, no-store
Date: Thu, 07 Jul 2016 07:59:18 GMT
Server: Jetty(9.2.z-SNAPSHOT)
Strict-Transport-Security: max-age=600
X-Originating-URL: https://edge-elb.api.brightcove.com/playback/v1/accounts/4235717419001/videos/4971736491001
X-Cache: Miss from cloudfront
Via: 1.1 2bb00e225b1b6c3d82913e7c9db706c5.cloudfront.net (CloudFront)
X-Amz-Cf-Id: DYQa8nLJhIDMmKfN6ZyJkp9iz11XD2B1ygSkELoh1g6EYbKLxWQf8Q==
'''