#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************

#encoding: utf-8

from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)

class hbrIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?hbr\.org/'

    def _real_extract(self, url):        
        webpage = self._download_webpage(url, '')
        title = self._search_regex('<meta name="twitter:title" content="([^"]+)', webpage, 'title')   
        ebm_video = self._search_regex('<meta property="og:video" content="([^"]+)', webpage, 'ebmURL')   
        return self.url_result(ebm_video, ie='BrightcoveNew', video_id = 'id', video_title=title)     
        