#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor
from ..utils import smuggle_url
from ..extractor.theplatform import ThePlatformIE, default_ns, OnceIE, determine_ext, update_url_query
from ..compat import (
    compat_urllib_parse,
    compat_urllib_parse_unquote
)
import re

class HistoryIE(InfoExtractor):
    _VALID_URL = r'https?://(?:www\.)?history\.com'

    _TESTS = [{
        'url': 'http://www.history.com/topics/valentines-day/history-of-valentines-day/videos/bet-you-didnt-know-valentines-day?m=528e394da93ae&s=undefined&f=1&free=false',
        'md5': '6fe632d033c92aa10b8d4a9be047a7c5',
        'info_dict': {
            'id': 'bLx5Dv5Aka1G',
            'ext': 'mp4',
            'title': "Bet You Didn't Know: Valentine's Day",
            'description': 'md5:7b57ea4829b391995b405fa60bd7b5f7',
        },
        'add_ie': ['ThePlatform'],
    }]

    def _real_extract(self, url):
        webpage = self._download_webpage(url, url)
        try:
            mobj = re.search(r'history\.com/(?:[^/]+/)+(?P<id>[^/]+?)(?:$|[?#])', url)
            if mobj:
                video_id = mobj.group('id')
                pattern = r'data-href="[^"]*/%s"[^>]+data-release-url="([^"]+)"' % video_id
            else:
                pattern = r'_videoPlayer.play\(\'([^\']+)'
            try:
                video_url = self._search_regex(pattern, webpage, 'video url')
            except:
                pattern = r'_videoPlayer.play\(\'([^\']+)'
                video_url = self._search_regex(pattern, webpage, 'video url')
            redirectUrl = smuggle_url(video_url, {'sig': {'key': 'crazyjava', 'secret': 's3cr3t'}})
        except:
            try:
                thePlatformUrl = self._search_regex(r'data-mediaurl="([^"]+)|var media_url\s*=\s*\'([^\']*)|data-media-url="([^"]+)', webpage, 'ThePlatformUrl')
            except:
                id = self._search_regex(r'player/history\.html\?tpid\=(\d+)', webpage, '')
                data = self._download_json('https://feeds.video.aetnd.com/api/v2/history/videos?filter[id]=' + id, '')
                thePlatformUrl = data['results'][0]['publicUrl'].split('?')[0]

            if thePlatformUrl.find('https') == -1:
                thePlatformUrl.replace('http', 'https')
            dataUrl = thePlatformUrl + '?1=1&switch=hls_med_ak&assetTypes=medium_video_ak&formats=m3u,mpeg4&format=SMIL&embedded=true&tracking=true'
            #https://link.theplatform.com/s/xc6n8B/media/9IUm_8ro4KOM?1=1&switch=hls_med_ak&assetTypes=medium_video_ak&formats=m3u,mpeg4&format=SMIL&embedded=true&tracking=true
            sig = self._download_webpage('https://signature.video.aetnd.com/v2/?' + compat_urllib_parse.urlencode({'url':dataUrl }), 'signature')
            #sig = self._html_search_regex(r'auth"\s*:\s*"([^"]*)', html, 'auth')
            redirectUrl = dataUrl + '&sig=' + sig
            # data = compat_urllib_parse.urlencode({'sig': sig, 'assetTypes': 'medium_video_ak', 'formats': 'm3u,mpeg4',
            #                                'format': 'SMIL', 'embedded': 'true', 'tracking': 'true'})
            # redirectUrl = thePlatformUrl + '?' + sig
            # redirectUrl = smuggle_url(redirectUrl, {'sig': {'key': 'crazyjava', 'secret': sig}})
        if redirectUrl.find('theplatform') == -1:
            return self.url_result(redirectUrl)
        else:
            ie = ThePlatformIE(self._downloader)
            try:
                result = ie.extract(redirectUrl)
            except:
                str = r'(?:link|player)\.theplatform\.com/[sp]/(?P<provider_id>[^/]+)/(?P<media>media/)(?P<id>[^/\?&]+)'
                #str = self._search_regex(r'theplatform', redirectUrl, 'x')
                mobj = re.search(str, redirectUrl)
                provider_id = mobj.group('provider_id')
                video_id = mobj.group('id')
                meta = self._download_xml(redirectUrl, video_id,  headers=self.geo_verification_headers())
                smil_formats = self._parse_smil_formats(
                    meta, redirectUrl, video_id, namespace=default_ns,
                    # the parameters are from syfy.com, other sites may use others,
                    # they also work for nbc.com
                    f4m_params={'g': 'UXWGVKRWHFSP', 'hdcore': '3.0.3'},
                    transform_rtmp_url=lambda streamer, src: (streamer, 'mp4:' + src))

                formats = []
                for _format in smil_formats:
                    if OnceIE.suitable(_format['url']):
                        formats.extend(self._extract_once_formats(_format['url']))
                    else:
                        media_url = _format['url']
                        if determine_ext(media_url) == 'm3u8':
                            hdnea2 = self._get_cookies(media_url).get('hdnea2')
                            if hdnea2:
                                _format['url'] = update_url_query(media_url, {'hdnea3': hdnea2.value})

                        formats.append(_format)
                result = ie._download_theplatform_metadata('%s/media/%s' % (provider_id, video_id), video_id)
                result['formats'] = formats

           # return result
            return {
                'id': result['id'],
                'title': result['title'],
                'description': result['description'],
                'thumbnail': result['thumbnail'] if 'thumbnail' in result else '',
                'duration': result['duration'],
                'formats': result['formats']
            }