# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import tempfile
import os
import io
import sys
import re
from ..extractor.instagram import InstagramIE as OldIe

class instagramIE(OldIe):
    _VALID_URL = r'(?P<url>https?://(?:www\.)?instagram\.com/(?:p|tv|reel)/(?P<id>[^/?#&]+))'

    def _real_extract(self, url):
        try:
            return super(instagramIE, self)._real_extract(url)
        except:
            mobj = re.match(self._VALID_URL, url)
            video_id = mobj.group('id')            
            webpage = self._download_webpage(url, url)
            data = self._parse_json(self._search_regex(r'({"graphql".+})\);', webpage, 'video_url'), '')
            mediaData = data['graphql']['shortcode_media']
            video_url = mediaData['video_url']
            formats = [{
                'url': video_url,
                'ext': 'mp4'
            }]

            return {
                'id': video_id,
                'title': video_id,
                'formats': formats
            }
        