# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import json
from ..extractor.common import InfoExtractor
from ..utilsEX import sleep
from ..compat import compat_urllib_parse_urlencode

class jibjabIE(InfoExtractor):
    _USER_AGENT_IPAD = 'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.101 Mobile Safari/537.36'
    _VALID_URL = r'https?://(?:.+\.)?jibjab\.com/view'

    # https://www.jibjab.com/view/make/revolves_around_you/f63ed47a-ec7f-4a05-9c56-7cf70f167086?utm_campaign=tx_recipient_noti...
    # http://www.jibjab.com/view/xf7riuoigVakeOefkWbN
    def _real_extract(self, url):
        video_id = self._search_regex(r'/([a-z0-9-]{22,})', url, 'token', fatal=False)
        if not video_id:
            # 求token
            token = self._search_regex(r'view/((?:[^?/]+){20,})', url, 'token', fatal=False) or \
                    self._search_regex(r'token=(.+)', url, 'token', fatal=False) or \
                    self._search_regex(r'view/(.+)\?', url, 'token', fatal=False)

            if not token:
                return super(jibjabIE, self)._real_extract(url)

            if len(token) >= 22:
                video_id = token
            else:
                # 求视频id
                url = r'https://origin-prod-phoenix.jibjab.com/v1/legacy/views/%s?external_key=%s' % (token, token)
                js = self._download_json(url, 'video_id')
                if not js or not js['data'] or not js['data']['id']:
                    return super(jibjabIE, self)._real_extract(url)

                video_id = js['data']['id']

        if not video_id:
            return super(jibjabIE, self)._real_extract(url)

        makes = 'makes'
        make_url = r'https://origin-prod-phoenix.jibjab.com/v1/%s/%s' % (makes, video_id)
        js = self._download_json(make_url, 'video_id')
        if not js or not js['data'] or not js['data']['id']:
            return super(jibjabIE, self)._real_extract(make_url)

        if js['data']['attributes']:
            thumbnail = js['data']['attributes'].get('thumbnail', '')
        if js['included'] and js['included'][0]['attributes']:
            title = js['included'][0]['attributes'].get('template-group-name', '')
            # 实在不行，下载其模板吧
            video_url_bak = js['included'][0]['attributes'].get('webgl-feature-video', '')

        # 等它制作完毕
        render_url = r'https://origin-prod-phoenix.jibjab.com/v1/make_events'
        data = {
            'data[type]': 'make-events',
            'data[relationships][make-event-type][data][type]': 'make-event-types',
            'data[relationships][make-event-type][data][id]': 'make_recipient_view',
            'data[relationships][make][data][type]': 'makes',
            'data[relationships][make][data][id]' : video_id
        }
        headers = {'Referer': url,
                   'Origin': 'https://www.jibjab.com',
                   'User-Agent': 'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.101 Mobile Safari/537.36'
                   }

        try:
            self._download_webpage(render_url, video_id, 'Downloading video page', data=compat_urllib_parse_urlencode(data).encode('utf-8'), headers=headers)
        except Exception as ex:
            pass

        ranks = js['included'][1:]
        actors = []
        for item in ranks:
            attrs =item['attributes']
            actors.append({
                "rank": attrs['role-rank'],
                "file": attrs['head-asset'],
                "svg": attrs['jaw-svg']
            })
        templateData = js['included'][0]
        template = {            
            "type":"starring_you",
            "slug": templateData['id'],
            "file": templateData['attributes']['webgl-feature-video'],            
            "position_data": templateData['attributes']['webgl-position-data'],
            "actors": actors
        }
        postdata = { 
            "data" : {
                "attributes" : {
                    "size":"480x270",
                    "template": template
                },
                "type":"fmvr-requests",
                "id": video_id
            }
        }


        headers = {
            'Referer': url,
            'origin': 'https://www.jibjab.com',
            'Accept': 'application/vnd.api+json',  
            'Content-Type': 'application/vnd.api+json',
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36'
        }
        self._downloader.cookiejar.clear()
        jsonData = self._download_json('https://fmvr-prod.serverless.jibjab.com/' + video_id , video_id, '', headers=headers, data=json.dumps(postdata).encode(), fatal=False)

        
        jsonData = {}
        for i in range(50):
            try:
                jsonData = self._download_json('https://fmvr-prod.serverless.jibjab.com/' + video_id , video_id, '', headers=headers)
                if jsonData and jsonData['data']['attributes']['url']:
                    break
            except:
                pass
                sleep(10)
        # 视频地址，如下格式
        video_url = jsonData['data']['attributes']['url']
        formats = [{
            'url': video_url,
            'ext': 'mp4'
        }]

        return {
            'id': '',
            'title': title,
            'thumbnail': thumbnail,
            'formats': formats,
        }