# coding: utf-8
from __future__ import unicode_literals
import json

from ..extractor.common import InfoExtractor
from ..utils import (
    unescapeHTML
)


class linkedinPostsIE(InfoExtractor):
    IE_NAME = 'linkedin:Posts'
    _VALID_URL = r'https?://(?:www\.)?linkedin\.com/posts/.+'    

    def _real_extract(self, url):    
        title =  self._search_regex(r'linkedin\.com/posts/(.+)', url, '')
        webpage = self._download_webpage(url, url)
        try:
            info = self._search_regex(r'(\{&quot;data&quot;:{&quot;entityUrn&quot;:&quot;urn:li:collectionResponse:.*&quot;com\.linkedin\.voyager\.identity\.shared\.MiniProfile&quot;\}\]\})', webpage, 'info')
            info = unescapeHTML(info)
            obj = json.loads(info)
            progressiveStreams = obj['included'][0]['progressiveStreams']
            formats = []
            for stream in progressiveStreams:
                formats.append({
                    'format_id': 'progressive-%dp' % stream['height'],
                    'url': stream['streamingLocations'][0]['url'],
                    'height': stream['height'],
                    'width': stream['width'],
                    'size': stream['size'],
                    'ext': 'mp4'
                })    
        except:
            info = self._search_regex(r'data-sources="(\[\{&quot;src&.*\}\])"data-poster-url=', webpage, 'info')
            info = unescapeHTML(info)
            items = json.loads(info)
            formats = []
            for item in items:                                
                formats.append({
                    'format_id': item['data-bitrate'],
                    'url': item['src'],
                    'tbr': item['data-bitrate'],                    
                    'ext': 'mp4'
                })               
        return {
            'id': title,
            'title': title,
            'formats': formats,             
        }
        
                       