#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..extractor.kaltura import KalturaIE as Old
from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from ..utils import (
    int_or_none,
)

class MotoGPIE(InfoExtractor):    
    _VALID_URL = r'https?://(?:.+\.)?motogp\.com/.+\/(?P<id>\d{6,})'
    #
    def _real_extract(self, url):
        video_id = self._match_id(url)
        if url.find('video_gallery')> -1:
            webpage = self._download_webpage(url, '')
            video_id = self._search_regex(r'<meta property="og:url".+n=(\d+)', webpage, '123123')

        response = self._download_json('https://secure.motogp.com/en/demand/video/' + video_id, '')
        title = response['video_info']['title']
        protocols = response['cdns'][0]['feeds'][0]['protocols']
        formats = []
        for protocol, value in protocols.items():
            if protocol == 'hls':
                formats.extend(self._extract_m3u8_formats(
                        value['url'], video_id, 'mp4',
                        entry_protocol='m3u8', fatal=False))
            else:
                formats.append({
                    'url': url,
                    'ext': 'mp4'
                })  
        self._sort_formats(formats)
        return {
            'id': 'video_id',
            'formats': formats,
            'title': title,
        }                      


