# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json
from datetime import datetime
from ..extractor.nbc import NBCIE as Old
from ..extractor.common import InfoExtractor
from ..extractor.theplatform import ThePlatformIE
from ..utils import (
    smuggle_url,
    update_url_query,
    int_or_none,
    determine_ext,
    urlencode_postdata,
    float_or_none
)

class NBCIE(Old):
    def _parse_smil_formats(self, smil, smil_url, video_id, namespace=None, f4m_params=None, transform_rtmp_url=None):
        base = smil_url
        for meta in smil.findall(self._xpath_ns('./head/meta', namespace)):
            b = meta.get('base') or meta.get('httpBase')
            if b:
                base = b
                break

        formats = []
        rtmp_count = 0
        http_count = 0
        m3u8_count = 0

        srcs = []
        media = smil.findall(self._xpath_ns('.//video', namespace)) + smil.findall(self._xpath_ns('.//audio', namespace))
        for medium in media:
            src = medium.get('src')
            if not src or src in srcs:
                continue
            srcs.append(src)

            bitrate = float_or_none(medium.get('system-bitrate') or medium.get('systemBitrate'), 1000)
            filesize = int_or_none(medium.get('size') or medium.get('fileSize'))
            width = int_or_none(medium.get('width'))
            height = int_or_none(medium.get('height'))
            proto = medium.get('proto')
            ext = medium.get('ext')
            src_ext = determine_ext(src)
            streamer = medium.get('streamer') or base

            if proto == 'rtmp' or streamer.startswith('rtmp'):
                rtmp_count += 1
                formats.append({
                    'url': streamer,
                    'play_path': src,
                    'ext': 'flv',
                    'format_id': 'rtmp-%d' % (rtmp_count if bitrate is None else bitrate),
                    'tbr': bitrate,
                    'filesize': filesize,
                    'width': width,
                    'height': height,
                })
                if transform_rtmp_url:
                    streamer, src = transform_rtmp_url(streamer, src)
                    formats[-1].update({
                        'url': streamer,
                        'play_path': src,
                    })
                continue

            src_url = src if src.startswith('http') else compat_urlparse.urljoin(base, src)
            src_url = src_url.strip()

            if proto == 'm3u8' or src_ext == 'm3u8' or src_url.find('/hls/')>-1:
                m3u8_formats = self._extract_m3u8_formats(
                    src_url, video_id, ext or 'mp4', m3u8_id='hls', fatal=False)
                if len(m3u8_formats) == 1:
                    m3u8_count += 1
                    m3u8_formats[0].update({
                        'format_id': 'hls-%d' % (m3u8_count if bitrate is None else bitrate),
                        'tbr': bitrate,
                        'width': width,
                        'height': height,
                    })
                formats.extend(m3u8_formats)
            elif src_ext == 'f4m':
                f4m_url = src_url
                if not f4m_params:
                    f4m_params = {
                        'hdcore': '3.2.0',
                        'plugin': 'flowplayer-3.2.0.1',
                    }
                f4m_url += '&' if '?' in f4m_url else '?'
                f4m_url += compat_urllib_parse_urlencode(f4m_params)
                formats.extend(self._extract_f4m_formats(f4m_url, video_id, f4m_id='hds', fatal=False))
            elif src_ext == 'mpd':
                formats.extend(self._extract_mpd_formats(
                    src_url, video_id, mpd_id='dash', fatal=False))
            elif re.search(r'\.ism/[Mm]anifest', src_url):
                formats.extend(self._extract_ism_formats(
                    src_url, video_id, ism_id='mss', fatal=False))
            elif src_url.startswith('http') and self._is_valid_url(src, video_id):
                http_count += 1
                formats.append({
                    'url': src_url,
                    'ext': ext or src_ext or 'flv',
                    'format_id': 'http-%d' % (bitrate or http_count),
                    'tbr': bitrate,
                    'filesize': filesize,
                    'width': width,
                    'height': height,
                })

        return formats

    def _real_extract(self, url):
        try:
            result = super(NBCIE, self)._real_extract(url)
            ie = ThePlatformIE()
            ie.set_downloader(self._downloader)
            testResult = ie._real_extract(result['url'])
            return result
        except:
            permalink, video_id = re.match(self._VALID_URL, url).groups()
            webpage = self._download_webpage(url, url).replace('https://schema.org', 'http://schema.org')
            video_data = self._search_json_ld(webpage, '', fatal=False)

            if video_id:
                try:
                    token = self._get_cookies(url).get('park-fr').value
                    mpxAccountId = self._search_regex(r'media/guid/(\d+)/%s'%video_id, webpage, '')

                    headers = {
                        "accept":"application/access-v1+json",
                       "Content-Type": "application/json",
                       "authorization": "NBC-Referrer key=desktop_nbcuniversal,idmToken=%s,version=3.0,time=%s" % (token, datetime.utcnow().isoformat()[:-3]+'Z'),
                       "Referer": url,
                    }

                    data = json.dumps({'device': 'web','mpxAccountId': mpxAccountId}).encode()


                    obj =self._download_json('https://access-cloudpath.media.nbcuni.com/access/vod/nbcuniversal/%s' % video_id, video_id,
                                        data = data, headers = headers)
                    linktheplatformURL = obj['url'] + '&manifest=m3u&autoPlay=true&policy=147097224&fallbackSiteSectionId=9244655&siteSectionId=oneapp_desktop_computer_web_ondemand&switch=HLSOriginSecure&MVPDid=undefined&_fw_vcid2=&_fw_h_referer=www.nbc.com&schema=2.0&params=&format=SMIL&tracking=true&formats=M3U+appleHlsEncryption,M3U+none,MPEG4,MP3'
                    formats = []
                    formats.extend(self._extract_smil_formats(linktheplatformURL, video_id))

                    return {
                        '_type': 'video',
                        'id': video_id,
                        'title': video_data.get('title'),
                        'formats': formats,
                        'description': video_data.get('description'),
                        'keywords': video_data.get('keywords'),
                        'season_number': int_or_none(video_data.get('seasonNumber')),
                        'episode_number': int_or_none(video_data.get('episodeNumber')),
                        'series': video_data.get('showName'),
                    }
                except Exception as ex:
                    query = {
                        'mbr': 'true',
                        'manifest': 'm3u',
                    }
                    theplatform_url = smuggle_url(update_url_query(
                        'http://link.theplatform.com/s/NnzsPC/media/guid/2410887629/' + video_id,
                        query), {'force_smil_url': True})
                    return {
                        '_type': 'url_transparent',
                        'id': video_id,
                        'title': video_data.get('title'),
                        'url': theplatform_url,
                        'description': video_data.get('description'),
                        'keywords': video_data.get('keywords'),
                        'season_number': int_or_none(video_data.get('seasonNumber')),
                        'episode_number': int_or_none(video_data.get('episodeNumber')),
                        'series': video_data.get('showName'),
                        'ie_key': 'ThePlatform',
                    }


class NBCNewsVideoIE(InfoExtractor):
    _VALID_URL = r'(?x)https?://(?:www\.)?nbcnews\.com/video/*(?:.*-)?(?P<id>[^/?]+)'
    def _real_extract(self, url):
        video_id = self._match_id(url)
        data = self._download_json('https://www.nbcnews.com/bentoapi/videos/' + video_id, '')
        videoAsset = data['data']['mmvo' + video_id]['videoAssets'][0]
        link = videoAsset['publicUrl']

        return {
            '_type': 'url_transparent',
            'id': video_id,
            'url': link,            
            'ie_key': 'ThePlatform',
        }

