#encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import json

from ..compat import compat_urlparse
from ..extractor.common import InfoExtractor
from .odnoklassniki import OdnoklassnikiIE
from ..utils import (
    int_or_none,
)
class orztoonsIE(InfoExtractor):   
    #https://www.orztoons.com/clip/3861447/ 
    _VALID_URL = r'https?://(?:.+\.)?orztoons\.com/clip/(?P<id>\d+)'

    def _real_extract(self, url):
        webpage = self._download_webpage(url, '')
        video_id = self._match_id(url)
        for i in range(4):
            try:
                webpage = self._download_webpage('https://www.orztoons.com/clip/play.php?id={0}&n={1}'.format(video_id,i), '')
                title = self._html_search_meta('og:title', webpage)
                thumbail = self._html_search_meta('og:image', webpage)    
                webpage = webpage.replace('<source src="https://www.orztoons.com/clip/loadingx.mp4" type="video/mp4" />', '')
                ok_url = self._search_regex(r'src="(https://www.ok.ru/videoembed/\d+)', webpage, '', default=None, fatal=False)

                if ok_url:
                    ie = OdnoklassnikiIE()
                    ie.set_downloader(self._downloader)
                    try:
                        result = ie._real_extract(ok_url)
                        return {       
                            'id': 'video_id',                   
                            'formats': result['formats'],
                            'title': title,
                            'thumbail': thumbail,                            
                        }
                    except:
                        pass                                        
                else:
                    google_url = self._search_regex(r'src="(https://docs.google.com/.*/preview)', webpage, '', default=None, fatal=False)
                    if google_url:
                        return {
                            '_type': 'url_transparent',                
                            'id': 'video_id',
                            'title': title,
                            'thumbail': thumbail,            
                            'url': google_url,                             
                        }
                    else:
                        embed_url = self._search_regex(r'<source src="([^"]+)?', webpage, '', default=None, fatal=False)
                        if self._is_valid_url(embed_url, '', ''):
                            return {
                                '_type': 'video',                
                                'id': 'video_id',
                                'title': title,
                                'thumbail': thumbail,            
                                'url': embed_url,                
                            }
            except:
                pass
