#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re
import json
import uuid


from ..extractor.common import InfoExtractor
from ..utils import (
    js_to_json
)


class plutoIE(InfoExtractor):
    #http://pluto.tv/on-demand/series/midsomer-murders/season/2/episode/death's-shadow-2-1
    _VALID_URL = r'https?://(?:www\.)?pluto\.tv/(?:on-demand)/series/(?P<series>.+)/season/(?:.+)/episode/(?P<video_id>.+)'

    def _real_extract(self, url):
        mobj = re.search(self._VALID_URL, url)
        if mobj:
            
            data = self._download_json('http://api.pluto.tv/v3/vod/slugs/%s?deviceType=web&sid=%s' % (mobj.group(1), uuid.uuid4()), mobj.group(2))
            for seasion in data['seasons']:
                for episode in seasion['episodes']:
                    if episode['slug'] == mobj.group(2):
                        format_url = episode['stitched']['urls'][0]['url']                        
                        duration = episode['duration']
                        thumbnail = episode['covers'][0]['url']                        
                        formats = []
                        formats.extend(self._extract_m3u8_formats(
                            format_url, '', 'mp4', entry_protocol='m3u8_native',
                            m3u8_id='hls', fatal=False))

                        return {
                            '_type': 'video',
                            'id': mobj.group(1),
                            'title':mobj.group(1),
                            'thumbnail': thumbnail,
                            'duration': duration,
                            'formats': formats,
                        }


class plutoMovieIE(InfoExtractor):
    #http://pluto.tv/on-demand/series/midsomer-murders/season/2/episode/death's-shadow-2-1
    _VALID_URL = r'https?://(?:www\.)?pluto\.tv/(?:on-demand)/movies/(?P<video_id>.+)'

    def _real_extract(self, url):
        mobj = re.search(self._VALID_URL, url)
        if mobj:
            
            data = self._download_json('https://api.pluto.tv/v3/vod/categories?includeItems=true&deviceType=web&sid=%s' % (uuid.uuid4()), '')
            for categorie in data['categories']:
                for item in categorie['items']:
                    if item['slug'] == mobj.group(1):
                        format_url = item['stitched']['urls'][0]['url']                        
                        duration = item['duration']
                        thumbnail = item['covers'][0]['url']                        
                        formats = []
                        formats.extend(self._extract_m3u8_formats(
                            format_url, '', 'mp4', entry_protocol='m3u8_native',
                            m3u8_id='hls', fatal=False))

                        return {
                            '_type': 'video',
                            'id': mobj.group(1),
                            'title':mobj.group(1),
                            'thumbnail': thumbnail,
                            'duration': duration,
                            'formats': formats,
                        }
