# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
from ..extractor.common import InfoExtractor

class PrageruIE(InfoExtractor):
    # https://www.prageru.com/videos/building-resilience-5-ways-better-life
    _VALID_URL = r'https?://(?:www\.)?prageru\.com/videos/(?P<id>[^/]+)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, video_id)
        # 找引用的youtube链接
        # <!-- <video id="video" width="640" height="360" style="max-width: 100%;" controls="control" preload="none" webkit-playsinline="true" playsinline="true">
        #        <source src="https://www.youtube.com/vjMYCnI5kz0" type="video/youtube" >
        #     </video> -->
        video_url = self._search_regex(r'(?s)<video id="video".*?src="([^"]+)', webpage, 'video_url')
        if video_url and 'youtube' in video_url:
            if not 'watch?v=' in video_url:
                video_url = video_url.replace('.com/', '.com/watch?v=')
            return self.url_result(video_url)

        # videoId: 'vjMYCnI5kz0',
        video_id = self._search_regex(r"videoId:\s+'([^']+)", webpage, 'video_id')
        if video_id:
            return self.url_result(r'https://www.youtube.com/watch?v=' + video_id)

        return super(PrageruIE, self)._real_extract(url)