# coding: utf-8
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor

class RumbleIE(InfoExtractor):
    _VALID_URL = r'https?://(?:www\.)?rumble\.com/(?!embed)'
    
    def _real_extract(self, url):
        webpage = self._download_webpage(url, url)
        embedUrl = self._search_regex(r'"embedUrl"\:"([^"]+)', webpage, 'embedUrl')

        return {
            '_type': 'url_transparent',
            'id': 'id',
            'url': embedUrl,
            'ie_key': 'RumbleEmbed',
        }
