# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

import json

import hashlib

from ..extractor.common import (
    InfoExtractor
)

from ..extractor.vimeo import VimeoIE

from ..utils import (
    int_or_none,
    ExtractorError,
    qualities,
    js_to_json,
    unescapeHTML,
    merge_dicts
)

from ..utilsEX import downloadWebPage_BYHeadlessBrowser_localFile

class stumfilmIE(InfoExtractor):
    #https://edu.51cto.com/course/21671.html
    _VALID_URL = r'https?://(?:www\.)?stumfilm\.dk'

    def _real_extract(self, url):
        #video_id = self._match_id(url)
        webpage = self._download_webpage(url, url)
        title = self._html_search_regex(r'<meta property="og:title" content="([^"]+)', webpage, 'title', fatal=True)
        if not title:
            title = self._search_regex(r'<title>(.+)</title>', webpage, 'video title')

        data_video = self._search_regex(r'data-video="([^"]+)', webpage, 'ebm_url')
        data_video = json.loads(unescapeHTML(data_video))
        ebm_url =  data_video['embed']
        video_id = self._search_regex(r'video/(\d+)', ebm_url, ebm_url)
        info={
            '_type': 'url_transparent',
            'title': title,
        }

        return merge_dicts(info, self.url_result(
            VimeoIE._smuggle_referrer(
                ebm_url, url),
                # 'https://player.vimeo.com/video/%s' % vimeo_id, url),
            ie=VimeoIE.ie_key(), video_id=video_id))                