#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re

from ..extractor.common import (
    InfoExtractor,
)

from ..utils import js_to_json


class StupidVideosIE(InfoExtractor):
    IE_NAME = 'stupidvideos.com'
    _VALID_URL = r'https?://(?:www\.)?stupidvideos\.com'

    def _real_extract(self, url):
        webpage = self._download_webpage(url, url)
        id = self._search_regex(r'#([0-9]+)$', url, url, default=None)
        if not id:
            id = self._search_regex(r'var\s+videoID\s*=\s*\'(\d+)', webpage, 'id', fatal=False)
        if id:
            if len(id) < 6:
                id = '0' + id
            play_url = 'http://videos.stupidvideos.com/2/00/%s/%s/%s/%s.flv' % (id[0:2], id[2:4], id[4:6], id)
            title = self._html_search_meta('og:title', webpage)
            thumbail = self._html_search_meta('og:image', webpage)

            return {
                'id': 'xxx',
                'title': title,
                'formats': [{'url': play_url}],
                'thumbnail': thumbail,
            }
        else:
            jwplayer_data = self._find_jwplayer_data(
                webpage, '', transform_source=js_to_json)
            return {
                '_type': 'url_transparent',
                'url': jwplayer_data['playlist']
            }