#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
from ..utilsEX import (
    download_webPage_by_PYCURL,
    downloadWebPage_BYHeadlessBrowser
)
from ..compat import compat_kwargs
from ..extractor.udemy import (
    UdemyIE,
    UdemyCourseIE as OldUdemyCourseIE,
)

class UdemyExIE(UdemyIE):
    def _download_webpage_handle(self, *args, **kwargs):
        headers = kwargs.get('headers', {}).copy()
        headers['User-Agent'] = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.21 (KHTML, like Gecko) Mwendo/1.1.5 Safari/537.21'
        headers['X-Requested-With'] = 'XMLHttpRequest'
        headers['Host'] = 'www.udemy.com'
        # This header is taken from https://github.com/FaisalUmair/udemy-downloader-gui thanks to @FaisalUmair for quick help.
        for cookie in self._downloader.cookiejar:
            if cookie.name == 'access_token':
                headers['Authorization'] = 'Bearer ' + cookie.value
                break
        else:
            headers['Authorization'] = 'Basic YWQxMmVjYTljYmUxN2FmYWM2MjU5ZmU1ZDk4NDcxYTY6YTdjNjMwNjQ2MzA4ODI0YjIzMDFmZGI2MGVjZmQ4YTA5NDdlODJkNQ=='
        kwargs['headers'] = headers
        return super(UdemyIE, self)._download_webpage_handle(
            *args, **compat_kwargs(kwargs))

    def _download_webpage(self, url_or_request, video_id, note=None, errnote=None, fatal=True, tries=1, timeout=5, encoding=None, data=None, headers={}, query={}):
        try:
            return super(UdemyExIE, self)._download_webpage(url_or_request=url_or_request, video_id=video_id, note=note, errnote=errnote, fatal=fatal, tries=tries, timeout= timeout, encoding=encoding, data=data, query=query)
        except Exception as ex:
            # return download_webPage_by_PYCURL(self, url_or_request, timeout, data, headers, query)
            webpage, _ = downloadWebPage_BYHeadlessBrowser(url_or_request)
            return webpage


class UdemyCourseIE(UdemyExIE):
    IE_NAME = 'udemy:course'
    _VALID_URL = r'https?://(?:www\.)?udemy\.com/(?P<id>[^/?#&]+)'
    _TESTS = []

    @classmethod
    def suitable(cls, url):
        return False if UdemyIE.suitable(url) else super(UdemyCourseIE, cls).suitable(url)

    def _real_extract(self, url):
        course_path = self._match_id(url)

        webpage = self._download_webpage(url, course_path)

        course_id, title = self._extract_course_info(webpage, course_path)

        if not title:
            title = self._search_regex(r'course/([^/]+)?', url, 'udemy course', fatal = False).replace('-', ' ')

        self._enroll_course(url, webpage, course_id)


        response = self._download_json(
            'https://www.udemy.com/api-2.0/courses/%s/cached-subscriber-curriculum-items' % course_id,
            course_id, 'Downloading course curriculum', query={
                'fields[chapter]': 'title,object_index',
                'fields[lecture]': 'title,asset',
                'page_size': '1000',
            })
        try:
            url_template = self._search_regex(r'(.+\/)\d+', url, 'x')
        except:
            url_template = url + 'learn/lecture/'
        entries = []
        chapter, chapter_number = [None] * 2
        for entry in response['results']:
            clazz = entry.get('_class')
            if clazz == 'lecture':
                asset = entry.get('asset')
                if isinstance(asset, dict):
                    asset_type = asset.get('asset_type') or asset.get('assetType')
                    if asset_type != 'Video':
                        continue
                lecture_id = entry.get('id')
                if lecture_id:
                    entry = {
                        '_type': 'url_transparent',
                        'url': '%s%s' % (url_template, entry['id']),
                        'title': entry.get('title'),
                        'ie_key': UdemyIE.ie_key(),
                        'duration': entry.get('asset',{}).get('length', 120),
                    }
                    if chapter_number:
                        entry['chapter_number'] = chapter_number
                    if chapter:
                        entry['chapter'] = chapter
                    entries.append(entry)
            elif clazz == 'chapter':
                chapter_number = entry.get('object_index')
                chapter = entry.get('title')

        return self.playlist_result(entries, course_id, title)

OldUdemyCourseIE._real_extract = UdemyCourseIE._real_extract

class UdemyExNewIE(UdemyExIE):
    _VALID_URL = r'https?://(?:[^/]+\.)?udemy\.com/course/[^#]+\/lecture/(?P<id>\d+)'     