# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

from ..extractor.common import InfoExtractor

class VidyardIE(InfoExtractor):
    # http://play.vidyard.com/tF8dPdhMoMgvTBpgcUhstT
    # https://play.vidyard.com/9ngCG5NqECn4FXGEtC9ggi
    # http://play.vidyard.com/Kc9BXQXgGyBYNg7smrRB9G.html?v=3.1&hide_html5_playlist=1&name_overlay=0&eloqua_id=&autoplay=0
    _VALID_URL = r'(?:https?://)?play\.vidyard\.com/(?P<id>\w{22})'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        if not video_id:
            return super(VidyardIE, self)._real_extract(url)

        json_url = r'https://play.vidyard.com/player/%s.json' % video_id
        video_data = self._download_json(json_url, video_id)
        if not video_data:
            return super(VidyardIE, self)._real_extract(url)

        try:
            title = video_data['payload']['vyContext']['metadata']['name']
            thumbnail = video_data['payload']['vyContext']['selectedThumbnail']['url_versions']['normal']
            duration = video_data['payload']['vyContext']['chapterAttributes'][0]['seconds']
            url = video_data['payload']['vyContext']['chapterAttributes'][0]['video_files'][0]['url']

            return {
                'id': video_id,
                'title': title,
                'thumbnail': thumbnail,
                'duration': duration,
                'url': url,
            }
        except:
            return super(VidyardIE, self)._real_extract(url)