# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re
import json
from ..extractor.common import InfoExtractor
from ..utils import (
    ExtractorError,
    int_or_none,
)


class zee5lIE(InfoExtractor):
    IE_NAME = 'zee5'
    _VALID_URL = r'https?://www\.zee5\.com'

    def _real_extract(self, url):
        video_id = url.split('/')[-1]
        dnsURL = 'https://zee5vodnd.akamaized.net'
        j_data = self._download_json('https://b2bapi.zee5.com/v1/country', 'https://b2bapi.zee5.com/v1/country')        
        code = j_data['country_code']
        headers = {'Referer': url}
        token = self._download_json('https://useraction.zee5.com/token/platform_tokens.php?platform_name=web_app', '', headers=headers)['token']

        video_token = self._download_json('https://useraction.zee5.com/tokennd/','', headers=headers)['video_token']

        detail_url = 'https://gwapi.zee5.com/content/details/%s?translation=en&country=%s' %(video_id, code)
        headers['X-ACCESS-TOKEN'] = token
        detail = self._download_json(detail_url, detail_url, headers= headers)
        title = detail['title']
        hls_url = dnsURL + detail['hls'][0].replace('drm', 'hls') + video_token
        formats = []
        formats.extend(self._extract_m3u8_formats_header(hls_url, video_id, 'mp4', 'm3u8_native', fatal=False, headers= {'Referer': url}))
        # video = dnsURL + detail['video'][0] + video_token
        #formats.extend(self._extract_mpd_formats(hls_url, video_id, mpd_id='dash', fatal=False))        

        return {
            'id': video_id,
            'title': title,
            'formats': formats,
        }
