# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os
import time
import re
import sys
from .external import ExternalFD
from ctypes import *
from ..utils import (
    int_or_none,
    encodeFilename,
    handle_youtubedl_headers,
)
import struct
from ..utilsEX import (
    debug,
    sleep
)


class TestCanel(Exception):
    pass


class OldM3u8downloader:
    TestSucess = False

    def __init__(self, strUrl, strSavePath, strCookie, callback, http_headers, libPath):
        if '#' in strUrl:
            strUrl = strUrl.split('#')[0]
        self.strUrl = strUrl
        self.strSavePath = strSavePath
        self.strCookie = strCookie
        self.callback = callback
        dll_path = os.getenv('M3u8DownloaderPath')
        if dll_path is None:
            debug('Find M3u8Downloader.dll Begin-------------------------------')
            import sys
            if sys.platform == 'win32':
                debug('Find M3u8Downloader.dll Win-------------------------------')
                dll_path = r'DownloadRes\M3u8Downloader.dll' if os.path.exists(
                    r'DownloadRes\M3u8Downloader.dll') else 'M3u8Downloader.dll'
                if not os.path.exists(dll_path):
                    try:
                        debug('libPath--------------------------------:' + libPath)
                        dll_path = os.path.join(os.path.dirname(libPath), 'M3u8Downloader.dll')
                        dll_path = os.path.abspath(dll_path)
                    except:
                        print('uses libPath Error')
            else:
                dll_path = 'M3u8Downloader.dll'
            try:
                debug(dll_path)
            except Exception as e:
                debug(e)
            debug('Find M3u8Downloader.dll End-------------------------------')
        self._type32 = struct.calcsize("P") == 4
        if self._type32:
            print(' self._type32')

        self.dll = cdll.LoadLibrary(dll_path)
        if self._type32:
            self.instance = self.dll.MovieDLCreate()
        else:
            MC = self.dll.MovieDLCreate
            MC.restype = c_longlong
            self.instance = MC()
            print(self.instance)
        encodeStr = 'utf-8'

        self.strUrl = self.strUrl.encode(encodeStr)
        self.strSavePath = self.strSavePath.encode(encodeStr)
        self.strCookie = self.strCookie.encode(encodeStr)

        if self._type32:
            self.dll.MovieDLSetUrl(self.instance, self.strUrl)
            self.dll.MovieDLSetSavePath(self.instance, self.strSavePath)
            self.dll.MovieDLSetCookie(self.instance, self.strCookie)
        else:
            MovieDLSetUrl = self.dll.MovieDLSetUrl
            MovieDLSetUrl.argtypes = [c_longlong, c_char_p]
            MovieDLSetUrl(self.instance, self.strUrl)

            MovieDLSetSavePath = self.dll.MovieDLSetSavePath
            MovieDLSetSavePath.argtypes = [c_longlong, c_char_p]
            MovieDLSetSavePath(self.instance, self.strSavePath)

            MovieDLSetCookie = self.dll.MovieDLSetCookie
            MovieDLSetCookie.argtypes = [c_longlong, c_char_p]
            MovieDLSetCookie(self.instance, self.strCookie)

        try:
            if http_headers and re.match(b'^https?://', self.strUrl):
                headers = handle_youtubedl_headers(http_headers).copy()
                if 'Cookie' in headers:
                    headers.pop('Cookie')
                MovieDLSetHeaderFunc = self.dll.MovieDLSetHeader
                if self._type32:
                    MovieDLSetHeaderFunc.argtypes = [c_int, c_char_p, c_char_p]
                else:
                    MovieDLSetHeaderFunc.argtypes = [c_longlong, c_char_p, c_char_p]

                for key, value in http_headers.items():
                    key = key.encode(encodeStr)
                    value = value.encode(encodeStr)
                    # p3，需要bytes类型，因此如是转，可
                    MovieDLSetHeaderFunc(self.instance, key, value)
        except Exception as e:
            debug(e)
            pass

    def start(self, testUrl=False):
        try:
            if testUrl:
                self.TestSucess = False
            start = time.time()
            if self._type32:
                self.dll.MovieDLStart(self.instance, True, False)
            else:
                MovieDLStart = self.dll.MovieDLStart
                MovieDLStart.argtypes = [c_longlong, c_bool, c_bool]
                MovieDLStart(self.instance, True, False)

            while True:
                try:
                    sleep(2)
                    mydata = self.getStatus()
                    if sys.version_info > (3, 0):
                        mydata = mydata.decode('utf-8')
                    # print mydata
                    data = None
                    list = re.findall(r'event=(.+)?,\s*totoalSize=(.+)?,\s*downloadingSize=(.+),', mydata)
                    if list and len(list) > 0:
                        data = {'event': list[0][0], 'totoalSize': list[0][1], 'downloadingSize': list[0][2],
                                'start': start}
                        self.TestSucess = int_or_none(list[0][2]) > 1000
                    else:
                        list = re.findall(r'event=(.+)?}', mydata)
                        if list and len(list) > 0:
                            data = {'event': list[0], 'start': start}
                    if self.callback and data:
                        self.callback(data)
                except Exception as ex:
                    break

                if testUrl and ((time.time() - start > 20) or self.TestSucess):
                    raise TestCanel()
        finally:
            self.stop()
        return

    def stop(self):
        if self._type32:
            self.dll.MovieDLStop(self.instance)
            self.dll.MovieDLRelease(self.instance)
        else:
            MovieDLStop = self.dll.MovieDLStop
            MovieDLStop.argtypes = [c_longlong]
            MovieDLStop(self.instance)

            MovieDLRelease = self.dll.MovieDLRelease
            MovieDLRelease.argtypes = [c_longlong]
            MovieDLRelease(self.instance)

    def getStatus(self):
        if self._type32:
            func = self.dll.MovieDLGetState
            func.restype = c_char_p
            data = func(self.instance)
        else:
            MovieDLGetState = self.dll.MovieDLGetState
            MovieDLGetState.restype = c_char_p
            MovieDLGetState.argtypes = [c_longlong]
            data = MovieDLGetState(self.instance)
        return data


class WSM3u8FD(ExternalFD):
    downloader = None
    tmpfilename = None
    _success = False
    _test = False

    @classmethod
    def supports(cls, info_dict):
        return info_dict['protocol'] in ('m3u8')

    @classmethod
    def available(cls):
        return True

    def HandleDownloading(self, data):
        time_now = time.time()
        start = data['start']
        downloaded_data_len = int_or_none(data['downloadingSize'])
        _50M = 1024 * 1024 * 50
        count = 1
        for i in range(200):
            if (_50M * i > downloaded_data_len):
                count = i
                break
        total_bytes = _50M * count
        percent = float(downloaded_data_len / total_bytes)
        percent = 0.9 if percent > 1 else percent
        data_len = None
        if percent > 0:
            data_len = int(downloaded_data_len * 100 / percent)
        self._hook_progress({
            'status': 'downloading',
            'downloaded_bytes': downloaded_data_len,
            'total_bytes_estimate': data_len,
            'tmpfilename': self.tmpfilename,
            # 'filename': filename,
            # 'eta': eta,
            'elapsed': time_now - start,
            'speed': self.calc_speed(start, time_now, downloaded_data_len),
            'total_bytes': total_bytes
        })

    def getCookies(self, info_dict):
        Cookie = ''
        if 'http_heads' in info_dict:
            if info_dict['http_heads'] and 'Cookie' in info_dict['http_heads'] and info_dict['http_heads']['Cookie']:
                Cookie = info_dict['http_heads']['Cookie']
        return Cookie

    def callback(self, data):
        if 'event' in data:
            if data['event'] == 'downloading':
                self.HandleDownloading(data)
            elif data['event'] == 'download_complete':
                self._success = True
                raise Exception('download_complete')
            elif data['event'] == 'download_error':
                self._success = False
                raise Exception('download_error')

    def real_download(self, filename, info_dict):
        self.report_destination(filename)
        tmpfilename = self.temp_name(filename)

        retval = self._call_downloader(tmpfilename, info_dict)
        if retval == 0:
            if self._test:
                return True

            fsize = os.path.getsize(encodeFilename(tmpfilename))
            self.to_screen('\r[%s] Downloaded %s bytes' % (self.get_basename(), fsize))
            self.try_rename(tmpfilename, filename)
            self._hook_progress({
                'downloaded_bytes': fsize,
                'total_bytes': fsize,
                'filename': filename,
                'status': 'finished',
            })
            return True
        else:
            self.to_stderr('\n')
            self.report_error('%s exited with code %d' % (
                self.get_basename(), retval))
            return False

    def _call_downloader(self, tmpfilename, info_dict):
        self._success = False
        url = info_dict['url']
        self.tmpfilename = tmpfilename
        try:
            self.downloader = OldM3u8downloader(url, tmpfilename, self.getCookies(info_dict), self.callback, info_dict['http_headers'] if 'http_headers' in info_dict else None,
                                                self.ydl.params.get('ffmpeg_location'))
            self.downloader.start(testUrl=self._test)
        except Exception as e:
            debug(e)
        return 0 if self._success or (self._test and self.downloader and self.downloader.TestSucess) else 1

    def testUrl(self, fileName, info):
        self._test = True
        TestSucess = False
        try:
            TestSucess = self.download(fileName, info)
        except:
            pass
        self._test = False
        return TestSucess
