#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os, sys
import threading
import time
import math
import traceback

try:
    import pycurl
except Exception as e:
    print('not surpot curl')


class CurlDownloader:
    def __init__(self, target_address):
        # Set variables of the downloader ########
        '''
        :type target_address: object
        '''
        self.output_file = ''  # Downloaded file is stored here
        self.fileName = ''
        self.targetURL = target_address
        self.curl_obj = ''
        self.fp = None
        self.resumdataerror = False
        self.downloadbyte = 0
        self.resumSize = 0
        self.rang_start = 0
        self.rang_end = sys.maxsize
        self.checkResum = False
        self.checkResumSize = 16
        self.clientError = False
        self.isFinish = False
        self.stop = False
        self.errorCode = 0
        self.initCurl()

    def initCurl(self):
        self.curl_obj = pycurl.Curl()
        self.curl_obj.setopt(pycurl.URL, self.targetURL)
        self.curl_obj.setopt(pycurl.FOLLOWLOCATION, 1)
        self.curl_obj.setopt(pycurl.MAXREDIRS, 5)
        self.curl_obj.setopt(pycurl.SSL_VERIFYPEER, 0)
        self.curl_obj.setopt(pycurl.SSL_VERIFYHOST, 2)


    def checkResumData(self, checkbuf):
        self.checkResumSize = 16
        filesize = os.path.getsize(self.output_file)
        seekpos = filesize - self.checkResumSize
        self.fp.seek(seekpos)
        tmpdata = self.fp.read(self.checkResumSize)

        print('checkbuf -- tmpdata')
        print('checkbuf:%s'%str(checkbuf))
        print('tmpdata:%s'%str(tmpdata))

        if len(checkbuf) != len(tmpdata):
            return False

        for index in range(len(checkbuf)):
            if tmpdata[index] != checkbuf[index]:
                return False

        self.checkResum = False
        self.resumSize = filesize
        self.resumSize -= self.checkResumSize
        return True

    def write(self, buf):
        buflen = len(buf)
        writedlen = self.downloadbyte + buflen
        lastwritelen = 0

        if self.checkResum is True:
            if self.checkResumData(buf[:self.checkResumSize]) is False:
                self.resumSize = 0
                self.resumdataerror = True
                print('resumdataerror restart')
                return 0
            else:
                buf = buf[self.checkResumSize:]
                #win must call seek file end:IOError Errno 0
                self.fp.seek(0, 2)

        if (self.rang_end > 0) and writedlen > self.rang_end:
            lastwritelen = buflen - (writedlen - self.rang_end - 1)
            print('fileName:%s write finish! range:%s-%s tital:%s' % (self.fileName, str(self.rang_start), str(
                self.rang_end), str(self.downloadbyte - self.rang_start)))
        try:
            if lastwritelen > 0:
                if self.fp is not None:
                    self.fp.write(buf[:lastwritelen])
                else:
                    print('unkonw write where###############')
                self.downloadbyte += lastwritelen
                print('file：%s is write finish' % self.fileName)
                return 0
            else:
                if self.fp is not None:
                    self.fp.write(buf)
                self.downloadbyte += buflen
        except:
            print('write file %s error' % self.fileName)
            print(traceback.format_exc())
        if self.stop is True:
            print('file：%s  is Cancel' % self.fileName)
            return 0


    def debugtest(self, debug_type, debug_msg):
        # INFOTYPE_DATA_IN = 3
        # INFOTYPE_DATA_OUT = 4
        #
        # INFOTYPE_HEADER_IN = 1
        # INFOTYPE_HEADER_OUT = 2
        #
        # INFOTYPE_SSL_DATA_IN = 5
        # INFOTYPE_SSL_DATA_OUT = 6
        #
        # INFOTYPE_TEXT = 0
        # print self.fp
        if debug_type == pycurl.INFOTYPE_TEXT:
            print('fileName: %s debug(TEXT): %s' % (self.fileName, debug_msg))
        elif debug_type == pycurl.INFOTYPE_HEADER_IN:
            print('fileName: %s debug(HEADER_IN): %s' % (self.fileName, debug_msg))
        elif debug_type == pycurl.INFOTYPE_HEADER_OUT:
            print('fileName: %s debug(HEADER_OUT): %s' % (self.fileName, debug_msg))

    @staticmethod
    def format_bytes(bytes):
        if bytes is None:
            return 'N/A'
        if type(bytes) is str:
            bytes = float(bytes)
        if bytes == 0.0:
            exponent = 0
        else:
            exponent = int(math.log(bytes, 1024.0))
        suffix = ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'][exponent]
        converted = float(bytes) / float(1024 ** exponent)
        return '%.2f%s' % (converted, suffix)

    def download(self, isResum):
        open_mode = 'wb'
        # Establish possible resume length
        print('fileName: %s isResum: %d' % (self.fileName, isResum))
        resume_len = 0
        new_rang_start = self.rang_start
        if isResum is True:
            if os.path.exists(self.output_file):
                resume_len = os.path.getsize(self.output_file)
                print('fileName:%s resume_len:%d' % (self.fileName, resume_len))
                # 小于 2M 就取消断点续传
                if resume_len < 1 * 1024 * 1024:
                    resume_len = 0
                else:
                    resume_len -= self.checkResumSize
                    new_rang_start += resume_len
            else:
                print('filename:%s is not exist' % self.fileName)
                resume_len = 0

        if resume_len != 0:
            open_mode = 'r+b'
            self.resumSize = resume_len
            self.checkResum = True
        else:
            self.resumSize = 0
            self.checkResum = False

        print('fileName: %s is can Resum: %d' % (self.fileName, self.checkResum))

        downloadrange = ''
        if self.rang_end > 0:
            downloadrange = str(new_rang_start) + '-' + str(self.rang_end)
            self.curl_obj.setopt(pycurl.RANGE, downloadrange)
        elif new_rang_start > 0:
            downloadrange = str(new_rang_start) + '-'
            self.curl_obj.setopt(pycurl.RANGE, downloadrange)
        print('fileName: %s download range:%s ' % (self.fileName, downloadrange))

        self.fp = open(self.output_file, open_mode)
        # self.fp = open(filepath, 'ab')
        self.curl_obj.setopt(pycurl.WRITEDATA, self)

        # Set the progress function #############
        # self.curl_obj.setopt(pycurl.NOPROGRESS, 0)
        # self.curl_obj.setopt(pycurl.PROGRESSFUNCTION, self.progress)

        # 调试回调.调试信息类型是一个调试信 息的整数标示类型.在这个回调被调用时VERBOSE选项必须可用
        self.curl_obj.setopt(pycurl.VERBOSE, 1)  # verbose 详细
        self.curl_obj.setopt(pycurl.DEBUGFUNCTION, self.debugtest)

        print('fileName: %s Start downloading' % (self.fileName))
        # Start downloading
        curlcode = pycurl.E_OK
        try:
            curlcode = self.curl_obj.perform()
        except pycurl.error as e:
            code = e.args[0]
            self.errorCode = code
            print(' pycurl.error code:%d' % code)
            if code != pycurl.E_WRITE_ERROR:
                self.fp.close()
                return False
            if code == pycurl.E_OPERATION_TIMEDOUT:
                self.fp.close()
                return False

            # self.curl_obj.close()

        if self.resumdataerror is True:
            self.fp.close()
            return False

        status = self.curl_obj.getinfo(pycurl.HTTP_CODE)
        if 399 < status < 500:
            print('download error httpCode:%d' % status)
            self.clientError = True
            return False
        elif 499 < status:
            print('download error httpCode:%d' % status)
            return False

        totalTime = self.curl_obj.getinfo(pycurl.TOTAL_TIME)
        Sizedownload = self.curl_obj.getinfo(pycurl.SIZE_DOWNLOAD)
        speed_download = self.curl_obj.getinfo(pycurl.SPEED_DOWNLOAD)

        print('fileName:' + self.fileName + 'Downloaded Total: ' + str(self.downloadbyte / 1024 / 1024) + 'MB')
        print('totalTime: ' + str(totalTime) + 'Sizedownload:' + str(Sizedownload) + 'speed_download:' + str(self.format_bytes(speed_download)))
        if self.fp is not None:
            self.fp.close()  # Close the file


        return True

    def startDownload(self, filepath, d_start, d_end, resum):
        self.stop = False
        self.output_file = filepath
        self.fileName = os.path.basename(filepath)
        self.rang_start = d_start
        self.rang_end = d_end
        self.isFinish = False
        if resum is True:
            if self.download(True) is False:
                if self.stop is False and self.resumdataerror is True:
                    self.isFinish = self.download(False)
            else:
                self.isFinish = True
        else:
            self.isFinish = self.download(False)

        return self.isFinish

    def cancelDownload(self):
        print('fileName:%s cancelDownload' % self.fileName)
        self.stop = True

    def cancelTimeoutDownload(self):
        print('fileName:%s cancelTimeoutDownload' % self.fileName)
        self.stop = True
        fileFp = self.fp
        self.fp = None
        fileFp.close()

    def getDownloadedSize(self):
        tatolsize = self.downloadbyte + self.resumSize
        if tatolsize > 0:
            return tatolsize
        return 0

    def progress(self, download_total, downloaded, uploaded_total, upload):
        '''
        Function to display the progress
        '''
        if self.stop is True:
            return 1
        # filename = ''
        # if self.fp is not None:
        #     filename = os.path.basename(self.fp.name)
        # if self.nextprogress < downloaded:
        #     print filename + 'To be downloaded' + str(self.rang_end - self.rang_start)
        #     print filename + ' Downloaded : %.2f bytes/second' + str(downloaded)
        #     self.nextprogress += 20 * 1024
