from instagram.client import InstagramAPI
from instagram.oauth2 import OAuth2AuthExchangeError
import urllib.parse
from baseau import BaseAU
from oauth2 import *

class InstagramAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = ['basic']

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = '0e70f8618eb94bc29d12f181ac406874'
            self.appSecret = 'fbe89209310945e8b16657a20c271acd'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'

    def GetLoginURL(self):
        try:
            api = InstagramAPI(client_id=self.appId, client_secret=self.appSecret, redirect_uri=self.redirectURL)
            loginURL = api.get_authorize_login_url(scope = self.scope)
            return loginURL
        except Exception as e:
            self.accessToken = str(e)
            return ''

    def Logout(self):
        return

    def VerifyRedirectURL(self,url):
        if url.find(self.redirectURL) == 0:
            uri = urllib.parse.urlparse(url)
            paramlist = urllib.parse.parse_qs(uri.query)
            if paramlist.has_key('code'):
                try:
                    api = InstagramAPI(client_id=self.appId, client_secret=self.appSecret, redirect_uri=self.redirectURL)
                    accessToken = api.exchange_code_for_access_token(paramlist['code'][0])
                    self.accessToken = accessToken[0]
                    self.userName = accessToken[1]['username']
                    return 0
                except OAuth2AuthExchangeError as e:
                    self.accessError = e.description
                except Exception as e:
                    self.accessError = str(e)
            if paramlist.has_key('error'):
                self.accessError = paramlist['error'][0]
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def SetAccessToken(self, token):
        api = InstagramAPI(client_id=self.appId, client_secret=self.appSecret, access_token=token, redirect_uri=self.redirectURL)
        try:
            info = api.user()
            self.userName = info.username
            return True
        except Exception as e:
            self.accessToken = str(e)
        return False

def CreateInstagramInstance():
    return InstagramAU()

# if __name__ == '__main__':
#     intance = CreateInstagramInstance()
#     intance.SetBrand('wondershare')
#     print(intance.GetLoginURL())
#     c = raw_input('input :')
#     intance.VerifyRedirectURL(c)
#     print(intance.GetAccessToken())
#     print(intance.GetUserName())
#     intance.SetAccessToken('34416163.261f753.166410ca00fe4e8b88d09d5ba4da261c')
#     print(intance.GetAccessToken())
