#if UNITY_EDITOR
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEditor;
using System.IO;

[InitializeOnLoad]
public partial class SquareEditor : Editor {
    public static string ExportDir = "";
    const string PrefsFilePath = "prefs.txt";

    static SquareEditor() {
        LoadPrefs();
    }

    public static void LoadPrefs() {
        if (!File.Exists(PrefsFilePath)) {
            return;
        }

        StreamReader reader = new StreamReader(PrefsFilePath);

        string version = reader.ReadLine();
        if (version != "version 1") {
            Debug.LogWarning("Wrong version, can't load prefs file!");
            reader.Close();
            return;
        }

        ExportDir = "exported_levels";

        string line;
        while ((line = reader.ReadLine()) != null) {
            string[] parts = line.Split(' ');

            if (parts[0] == "export_dir") {
                ExportDir = line.Substring(parts[0].Length + 1);
            }
        }

        reader.Close();
    }

    public static void SavePrefs() {
        StreamWriter writer = new StreamWriter(PrefsFilePath, false);

        writer.WriteLine("version 1");
        writer.WriteLine("export_dir "+ExportDir);

        writer.Close();
    }

    [MenuItem("Square/Import txt")]
    public static void ImportTxt() {
        string path = EditorUtility.OpenFilePanel("Import level txt file", "", "");
        if (path != "") {
            LoadLevelToScene.LoadFile(path);
        }
    }

    [MenuItem("Square/Set export dir")]
    public static void SetExportDir() {
        string dir = EditorUtility.OpenFolderPanel("Set export dir", "", "");
        if (dir != "") {
            ExportDir = dir;
            SavePrefs();
            Debug.Log("set export dir "+ExportDir);
            SaveSceneAsLevel.Save(Path.Combine(ExportDir, SceneManager.GetActiveScene().name+".txt"));
        }
    }
}
#endif
