#if UNITY_EDITOR
using UnityEngine;

public class RefBlock : MonoBehaviour {
    [Header("Common")]
    public bool IsExitBlock;
    public bool FlipH;
    public bool Possessable;
    public bool IsPlayer;

    [Header("Other properties")]
    public SceneLevel SubSceneLevel;
    public int PlayerOrder;
    public bool FloatInSpace;
    public int SpecialEffect;
    public bool IsInfExitBlock;
    public int InfExitNum;
    public bool IsInfEnterBlock;
    public int InfEnterNum;
    public SceneLevel InfEnterLevel;

    [Header("Hub")]
    public string HubShortcutAreaPrefix = "_";
    public string HubShortcutAreaName = "_";

    // Used when loading from txt
    [HideInInspector] public int levelID;
    [HideInInspector] public int infEnterLevelID;

    public void UpdateColor() {
        var sprite = GetComponent<SpriteRenderer>();
        if (SubSceneLevel == null) {
            sprite.color = Color.white;
        }
        else {
            var level = SubSceneLevel;
            float hue = level.hue;
            float sat = level.sat;
            //float val = level.val * ValScale(gameObject);
            float val = level.val * SceneBlock.ValScale(gameObject) * 1.25f + 0.5f;
            sprite.color = Color.HSVToRGB(hue, sat, val);
        }
    }

    // The first OnValidate is called when the script is loaded, 
    bool firstValidate = true;

    [ExecuteAlways]
    void OnValidate() {
        if (firstValidate) {
            firstValidate = false;
            return;
        }

        UpdateColor();
    }
}
#endif
