﻿#if UNITY_EDITOR
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEditor;

public class SceneFloor : MonoBehaviour {
    public enum FloorType {
        Button,
        PlayerButton,
        Possess,
        LevelSelectLevel,
        ResetProgress,
        Start,
        Info,
        Item,
        Label,
        BreakFloor,
        FastTravel,
        GalleryFloor,
        DemoEnd,
    }
    public FloorType type = FloorType.Button;

    // For level select levels
    [Header("Portal")]
    public string referenceName = "_";
    public string SceneName;
    public int music;
    public int musicArea = -1;
    public int palette;
    public int hard;
    public bool eyesJump;
    public GameObject[] unlocks = new GameObject[0];
    public bool StartsUnlocked;
    [HideInInspector]
    public int portalSize = 3;

    // Used in computations
    [HideInInspector] public bool visited;

    // For Infos and Texts
    [Header("Info")]
    public string info;

    // For Items
    //public int itemNum;
    //public string itemName;

    // For scene gizmos
    [HideInInspector] public static GUIStyle style;

    void OnDrawGizmos() {
        if (style == null) {
            style = new GUIStyle();
            style.alignment = TextAnchor.MiddleCenter;
            style.fontSize = 15;
            style.normal.textColor = Color.white;
        }

        style.fontSize = 15;

        if (type == FloorType.LevelSelectLevel || type == FloorType.Label) {
            // Don't draw text if the floor is very small relative to the viewport
            //float camSize = SceneView.lastActiveSceneView.size;
            //float ourSize = GetComponent<SpriteRenderer>().bounds.size.x;

            /*
            if (camSize > ourSize * 50f) {
                return;
            }
            */

            //style.fontSize = (int)(ourSize / camSize * 100f);

            //if (type != FloorType.Label &&
            //        transform.parent.GetComponent<SceneLevel>().LevelX(transform.localPosition.x) % 2 != 0) {
            //    offset = Vector3.down * 1.5f;
            //}

            string text;
            Vector3 offset;

            if (type == FloorType.LevelSelectLevel) {
                style.fontSize = 20;

                text = referenceName.Substring(1);
                offset = Vector3.up * transform.lossyScale.y * 0.5f;
                offset += Vector3.left * transform.lossyScale.x * 0.35f;
                Handles.Label(transform.position + offset, text, style);

                //style.normal.textColor = Color.white;
                //if (hard == 1) style.normal.textColor = Color.red;
                //if (hard == 2) style.normal.textColor = new Color(0.3f, 0.5f, 1.0f);//Color.blue;

                /*
                if (hard == 1) {
                    text = "hard";
                    offset = Vector3.up * transform.lossyScale.y * 1.25f;
                    offset += Vector3.left * transform.lossyScale.x * 0.35f;
                    Handles.Label(transform.position + offset, text, style);
                }
                */

                if (hard == 2) {
                    Gizmos.color = Color.blue;//new Color(0.4f, 0.6f, 1.0f);
                    Gizmos.DrawCube(transform.position + Vector3.up * transform.lossyScale.x * 0.7f, transform.lossyScale * 0.7f);
                    //text = "visual";
                    //offset = Vector3.up * transform.lossyScale.y * 1.25f;
                    //offset += Vector3.left * transform.lossyScale.x * 0.35f;
                    //Handles.Label(transform.position + offset, text, style);
                }

                /*
                text = "";
                if (palette == 0) text = "classic";
                else if (palette == 1) text = "pastel";
                else if (palette == 2) text = "blue";
                else if (palette == 3) text = "dark";
                else if (palette == 4) text = "jellybeans";
                else if (palette == 5) text = "grey";
                offset = Vector3.up * transform.lossyScale.y * 1.25f;
                offset += Vector3.left * transform.lossyScale.x * 0.35f;
                Handles.Label(transform.position + offset, text, style);

                text = "";
                if (music == -1) text = "none";
                else if (music == 0) text = "happy";
                else if (music == 1) text = "bells";
                else if (music == 2) text = "calm";
                offset = Vector3.up * transform.lossyScale.y * 2.0f;
                offset += Vector3.left * transform.lossyScale.x * 0.35f;
                Handles.Label(transform.position + offset, text, style);
                */

                /*
                text = SceneName;
                offset = Vector3.up * transform.lossyScale.y * 2.75f;
                offset += Vector3.left * transform.lossyScale.x * 0.35f;
                Handles.Label(transform.position + offset, text, style);
                */
            }
            else if (type == FloorType.Label) {
                style.fontSize = 20;

                style.normal.textColor = Color.white;
                text = info.Replace("#", "\n");
                //offset = Vector3.right * transform.lossyScale.x * 1.5f;
                //offset += Vector3.left * transform.lossyScale.x * 1f;
                offset = Vector3.zero;
                Handles.Label(transform.position + offset, text, style);

                /*
                style.normal.textColor = Color.red;
                text = unlocker.ToString();
                offset = Vector3.up * transform.lossyScale.y * 0.5f;
                offset += Vector3.left * transform.lossyScale.x * 1f;
                Handles.Label(transform.position + offset, text, style);
                */
            }

            // Draw unlock lines
            foreach (var unlock in unlocks) {
                if (unlock == null) {
                    Debug.LogWarning("null unlock. scene name " + SceneName);
                    return;
                }

                //var block = unlock.GetComponent<SceneBlock>();
                //if (block != null && block.dontDrawUnlockerLine) continue;

                Vector3 p1 = transform.position;
                Vector3 p2 = unlock.transform.position;
                DrawArrow(p1, p2);
            }
        }
    }

    public static void DrawArrow(Vector3 p1, Vector3 p2) {
        Gizmos.color = Color.white;
        Gizmos.DrawLine(p1, p2);

        //float t = (float)EditorApplication.timeSinceStartup % 1f;
        float t = 0.5f;
        Vector3 midpt = Vector3.Lerp(p1, p2, t);
        float length = (p1 - p2).magnitude * 0.1f;

        float angle = Util.Vector2ToDegrees(p1 - p2);
        Gizmos.DrawLine(midpt, midpt + (Vector3)(Util.DegreeToVector2(angle + 20)) * length);
        Gizmos.DrawLine(midpt, midpt + (Vector3)(Util.DegreeToVector2(angle - 20)) * length);

        //Gizmos.DrawGUITexture(new Rect(p1.x, p1.y, 1, 1), Texture2D.teTexture);
    }

    public static void AssignScene(SceneFloor floor, string sceneName) {
        Undo.RecordObject(floor, "Change scene");
        PrefabUtility.RecordPrefabInstancePropertyModifications(floor);

        floor.SceneName = sceneName;

        string texturePath = "Assets/Resources/level_thumbnails/" + sceneName + ".png";

        /*
        var tex = (Texture2D)AssetDatabase.LoadAssetAtPath(texturePath, typeof(Texture2D));
        if (tex == null) {
            texturePath = "Assets/Resources/level_thumbnails/no_thumbnail.png";
            tex = (Texture2D)AssetDatabase.LoadAssetAtPath(texturePath, typeof(Texture2D));
        }
        floor.ThumbnailTex = tex;
        */

        var targetSprite = floor.gameObject.GetComponent<SpriteRenderer>();
        targetSprite.sprite = (Sprite)AssetDatabase.LoadAssetAtPath(texturePath, typeof(Sprite));

        targetSprite.color = Color.white; // Incase Check Levels made it red

        floor.GetComponent<Snap>().SnapSelf();
    }
}
#endif
