﻿#if UNITY_EDITOR
using UnityEngine;
using UnityEditor;
using System.Collections.Generic;

public class SceneLevel : MonoBehaviour {
    public float hue;
    public float sat;
    public float val;
    public int width = 3;
    public int height = 3;
    public bool FillWithWalls;
    //public bool CameraFollow;
    public float CamZoomFactor = 1;



    public float ChildLocalScale() {
        return 1f / Mathf.Max(width, height);
    }

    // LocalPosition returns the transform position from
    // level coordinates, e.g. (1, 2)
    // Returns a vector between -0.5 and 0.5 (won't ever touch the edges)
    public Vector3 LocalPosition(int x, int y) {
        return LocalPositionGeneral(x, y, width, height, ChildLocalScale());
    }

    public Vector3 LocalPositionGeneral(int x, int y, int width, int height, float blocksize) {
        return new Vector3(
            -(width - 1) / 2f * blocksize + x * blocksize,
            -(height - 1) / 2f * blocksize + y * blocksize);
    }

    // LevelX and LevelY return level coordinates of a transform position,
    // rounded to the nearest spot.
    public int LevelX(float x) {
        return (int)Mathf.Round((x / ChildLocalScale() + (width - 1) / 2f));
    }

    public int LevelY(float y) {
        return (int)Mathf.Round((y / ChildLocalScale() + (height - 1) / 2f));
    }

    public bool InBounds(int x, int y) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    // The first OnValidate is called when the script is loaded, 
    bool firstValidate = true;

    [ExecuteAlways]
    void OnValidate() {
        if (firstValidate) {
            firstValidate = false;
            return;
        }

        GetComponent<SceneBlock>().UpdateColor();

        // Update child wall colors
        Snap.SnapLevelChildren(gameObject, false);

        // Ref block colors do not get updated, but whatever. Just don't, for performance, maybe
    }
}
#endif
