﻿# 读取文件
$bytes = [System.IO.File]::ReadAllBytes($args[0])

# 判断文件格式
$format = [System.Text.Encoding]::UTF8.GetString($bytes[0..3])
if ($format -eq 'GT1G') {
    Write-Host '文件可直接用gust_g1t.exe解包'
    exit
} elseif ($format -ne 'MRLK') {
    Write-Host '未知的文件格式'
    exit
}

# 读取偏移量和文件大小
$count = [System.BitConverter]::ToInt32($bytes, 4)
$offsets = New-Object -TypeName 'int[]' -ArgumentList $count
$sizes = New-Object -TypeName 'int[]' -ArgumentList $count

for ($i = 0; $i -lt $count; $i++) {
    $offsets[$i] = [System.BitConverter]::ToInt32($bytes, 8 + $i * 8)
    $sizes[$i]   = [System.BitConverter]::ToInt32($bytes, 12 + $i * 8)
}

# 创建新文件夹
$parent = Split-Path -Path $args[0] -Parent
$folder = (Get-Item $args[0]).BaseName
if (Test-Path -Path "$parent\$folder") {
    Write-Output '文件夹已存在'
    exit
}
New-Item -Path "$parent\$folder" -ItemType Directory | Out-Null

# 解包
Write-Host '解包开始'
for ($i = 0; $i -lt $count; $i++) {
    [System.IO.File]::WriteAllBytes("$parent\$folder\$i.g1t", $bytes[($offsets[$i]) .. ($offsets[$i] + $sizes[$i] - 1)])
    & "$PSScriptRoot\gust_g1t.exe" "$parent\$folder\$i.g1t"
}
Write-Host '解包完成'
