(function(){
	window.QGWidget = {
		init: function(id, pid, type) {
			var $el = $('#' + id);
			if ($('#' + id).length == 0) {
				var tpl;
				if (type == 'div') {
					tpl = _.template('<div id="<%= id %>" class="<%= className %>"></div>');
				} else if (type == 'iframe') {
					tpl = _.template('<iframe id="<%= id %>" class="<%= className %>"></iframe>');
				}
				var html = tpl({ id: id, className: QGWidgetClass});
				$QGContainer.append(html);
				$el = $('#' + id);
				$el.hide();
				Communicator.send('init_widget', { id: id, pid: pid, type: type});
			}
			return $el;
		},
		show : function(id) {
			$('#' + id).show();
			Communicator.send('show_widget', { id: id});
		},
		hide: function(id) {
			$('#' + id).hide();
			Communicator.send('hide_widget', { id: id});
		},
		move: function(id, x, y) {
			$('#' + id).css({
				'left': x,
				'top': y
			});
			Communicator.send('move_widget', { id: id, x: x, y: y});
		},
		resize: function(id, width, height) {
			var $el = $('#' + id);
			$el.css({
				'width': width - ($el.outerWidth(true) - $el.width()),
				'height': height - ($el.outerHeight(true) - $el.height())
			});
			Communicator.send('resize_widget', { id: id, width: width, height: height});
		},
		loadCSS: function(url, cb) {
			$('head').append($('<link/>', {
				rel: 'stylesheet',
				type: 'text/css',
				href: url,
				onload: cb
			}));
		}
	};
})();