/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.util.MigrateOption;
import cn.schoolwow.quickdao.domain.util.SynchronizeTableStructureOption;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOUtils {
    private static Logger logger = LoggerFactory.getLogger(DAOUtils.class);

    public static void synchronizeTableStructure(SynchronizeTableStructureOption synchronizeTableStructureOption) {
        if (null == synchronizeTableStructureOption.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == synchronizeTableStructureOption.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        List<Object> sourceEntityList = new ArrayList();
        if (null == synchronizeTableStructureOption.tableNames || synchronizeTableStructureOption.tableNames.length == 0) {
            sourceEntityList = synchronizeTableStructureOption.source.getDbEntityList();
        } else {
            for (String tableName : synchronizeTableStructureOption.tableNames) {
                Entity sourceEntity = synchronizeTableStructureOption.source.getDbEntity(tableName);
                if (null == sourceEntity) {
                    logger.warn("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
                    continue;
                }
                sourceEntityList.add(sourceEntity);
            }
        }
        QuickDAOConfig quickDAOConfig = synchronizeTableStructureOption.target.getQuickDAOConfig();
        AbstractDDLBuilder ddlBuilder = quickDAOConfig.databaseProvider.getDDLBuilderInstance(quickDAOConfig);
        ArrayList<Entity> addEntityList = new ArrayList<Entity>();
        ArrayList<Property> addPropertyList = new ArrayList<Property>();
        HashMap<Property, Property> updatePropertyMap = new HashMap<Property, Property>();
        for (Entity entity : sourceEntityList) {
            Entity entity2 = synchronizeTableStructureOption.target.getDbEntity(entity.tableName);
            if (null == entity2) {
                addEntityList.add(entity);
                continue;
            }
            List<Property> sourcePropertyList = entity.properties;
            for (Property sourceProperty : sourcePropertyList) {
                Property targetProperty = entity2.properties.stream().filter(property -> property.column.equalsIgnoreCase(sourceProperty.column)).findFirst().orElse(null);
                if (null == targetProperty) {
                    addPropertyList.add(sourceProperty);
                    continue;
                }
                if (!synchronizeTableStructureOption.diffPropertyPredicate.test(sourceProperty, targetProperty)) continue;
                updatePropertyMap.put(sourceProperty, targetProperty);
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Entity entity : addEntityList) {
            if (null != synchronizeTableStructureOption.createTablePredicate && !synchronizeTableStructureOption.createTablePredicate.test(entity)) continue;
            builder.append(ddlBuilder.createTable(entity));
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.create(entity);
        }
        for (Property property2 : addPropertyList) {
            if (null != synchronizeTableStructureOption.createPropertyPredicate && !synchronizeTableStructureOption.createPropertyPredicate.test(property2)) continue;
            builder.append(ddlBuilder.createProperty(property2));
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.createColumn(property2.entity.tableName, property2);
        }
        Set set = updatePropertyMap.entrySet();
        for (Map.Entry entry : set) {
            if (null != synchronizeTableStructureOption.updatePropertyPredicate && !synchronizeTableStructureOption.updatePropertyPredicate.test((Property)entry.getKey(), (Property)entry.getValue())) continue;
            builder.append(ddlBuilder.alterColumn((Property)entry.getKey()));
            if (!synchronizeTableStructureOption.executeSQL) continue;
            synchronizeTableStructureOption.target.alterColumn((Property)entry.getKey());
        }
        synchronizeTableStructureOption.sql = builder.toString();
    }

    public static void migrate(MigrateOption migrateOption) {
        if (null == migrateOption.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == migrateOption.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        migrateOption.target.enableForeignConstraintCheck(false);
        try {
            if (migrateOption.source.getEntityMap().isEmpty()) {
                DAOUtils.dbEntityMigrate(migrateOption);
            } else {
                DAOUtils.entityMigrate(migrateOption);
            }
        }
        finally {
            migrateOption.target.enableForeignConstraintCheck(true);
        }
    }

    private static void dbEntityMigrate(MigrateOption migrateOption) {
        List<Entity> sourceEntityList = migrateOption.source.getDbEntityList();
        if (null != migrateOption.tableFilter) {
            sourceEntityList = sourceEntityList.stream().filter(migrateOption.tableFilter).collect(Collectors.toList());
        }
        if (null == sourceEntityList || sourceEntityList.isEmpty()) {
            logger.warn("[\u6570\u636e\u8fc1\u79fb]\u5f53\u524d\u8fc1\u79fb\u6e90\u6570\u636e\u5e93\u8868\u5217\u8868\u4e3a\u7a7a!");
            return;
        }
        for (Entity sourceEntity : sourceEntityList) {
            Entity targetEntity = sourceEntity.clone();
            if (null != migrateOption.tableConsumer) {
                migrateOption.tableConsumer.accept(sourceEntity, targetEntity);
            }
            long count = migrateOption.source.query(sourceEntity.tableName).execute().count();
            int effect = 0;
            if (count > 0L) {
                long totalPage = count / (long)migrateOption.batchCount + 1L;
                logger.info("[\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u8fc1\u79fb\u6570\u636e\u5e93\u8868,\u6e90\u8868:{},\u603b\u8bb0\u5f55\u6570:{},\u8fc1\u79fb\u76ee\u6807\u8868:{}", sourceEntity.tableName, count, targetEntity.tableName);
                int i = 1;
                while ((long)i <= totalPage) {
                    logger.debug("[\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u4f20\u8f93\u7b2c{}/{}\u9875\u6570\u636e,\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", i, totalPage, sourceEntity.tableName, targetEntity.tableName);
                    JSONArray array = migrateOption.source.query(sourceEntity.tableName).page(i, migrateOption.batchCount).execute().getArray();
                    logger.debug("[\u6570\u636e\u8fc1\u79fb]\u7b2c{}/{}\u9875\u6570\u636e\u4f20\u8f93\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", i, totalPage, effect += migrateOption.target.query(targetEntity.tableName).addInsert(array).execute().insertBatch(), count, sourceEntity.tableName, targetEntity.tableName);
                    ++i;
                }
            }
            logger.info("[\u6570\u636e\u8fc1\u79fb]\u8868\u6570\u636e\u8fc1\u79fb\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", effect, count, sourceEntity.tableName, targetEntity.tableName);
        }
    }

    private static void entityMigrate(MigrateOption migrateOption) {
        Map<String, Entity> sourceEntityMap = migrateOption.source.getEntityMap();
        if (null != migrateOption.tableFilter) {
            Iterator<Map.Entry<String, Entity>> iterator = sourceEntityMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next().getValue();
                if (migrateOption.tableFilter.test(entity)) continue;
                iterator.remove();
            }
        }
        if (null == sourceEntityMap || sourceEntityMap.isEmpty()) {
            logger.warn("[\u589e\u91cf\u6570\u636e\u8fc1\u79fb]\u5f53\u524d\u8fc1\u79fb\u6e90\u6570\u636e\u5e93\u8868\u5217\u8868\u4e3a\u7a7a!");
            return;
        }
        migrateOption.target.synchonizedEntityAndDatabase();
        for (Entity sourceEntity : sourceEntityMap.values()) {
            Entity targetEntity = sourceEntity.clone();
            if (null != migrateOption.tableConsumer) {
                migrateOption.tableConsumer.accept(sourceEntity, targetEntity);
            }
            targetEntity.escapeTableName = migrateOption.target.getQuickDAOConfig().databaseProvider.escape(targetEntity.tableName);
            long count = migrateOption.source.query(sourceEntity.tableName).execute().count();
            int effect = 0;
            if (count > 0L) {
                long totalPage = count / (long)migrateOption.batchCount + 1L;
                logger.info("[\u589e\u91cf\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u8fc1\u79fb\u6570\u636e\u5e93\u8868,\u6e90\u8868:{},\u603b\u8bb0\u5f55\u6570:{},\u8fc1\u79fb\u76ee\u6807\u8868:{}", sourceEntity.tableName, count, targetEntity.tableName);
                int i = 1;
                while ((long)i <= totalPage) {
                    logger.debug("[\u589e\u91cf\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u4f20\u8f93\u7b2c{}/{}\u9875\u6570\u636e,\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", i, totalPage, sourceEntity.tableName, targetEntity.tableName);
                    List list = migrateOption.source.query(sourceEntity.clazz).page(i, migrateOption.batchCount).execute().getList();
                    logger.debug("[\u589e\u91cf\u6570\u636e\u8fc1\u79fb]\u7b2c{}/{}\u9875\u6570\u636e\u4f20\u8f93\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", i, totalPage, effect += migrateOption.target.insertIgnore(list), count, sourceEntity.tableName, targetEntity.tableName);
                    ++i;
                }
            }
            logger.info("[\u589e\u91cf\u6570\u636e\u8fc1\u79fb]\u8868\u6570\u636e\u8fc1\u79fb\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", effect, count, sourceEntity.tableName, targetEntity.tableName);
        }
    }
}

