/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.ddl.DDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDDLBuilder
extends AbstractSQLBuilder
implements DDLBuilder {
    protected Logger logger = LoggerFactory.getLogger(DDLBuilder.class);

    public AbstractDDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public void getDatabaseName() throws SQLException {
    }

    @Override
    public List<Entity> getVirtualEntity() {
        return new ArrayList<Entity>();
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        List<Entity> entityList = this.getEntityList();
        for (Entity entity : entityList) {
            entity.properties.clear();
        }
        this.getEntityPropertyList(entityList);
        for (Entity entity : entityList) {
            entity.indexFieldList.clear();
        }
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public abstract String hasTableExists(Entity var1);

    @Override
    public abstract String createTable(Entity var1);

    @Override
    public String createProperty(Property property) {
        StringBuilder createPropertyBuilder = new StringBuilder("alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName) + " add ");
        if (property.id && property.strategy == IdStrategy.AutoIncrement) {
            createPropertyBuilder.append(this.getAutoIncrementSQL(property));
        } else {
            createPropertyBuilder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
            if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                createPropertyBuilder.append(" default " + property.defaultValue);
            }
            if (property.notNull) {
                createPropertyBuilder.append(" not null");
            }
            if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                createPropertyBuilder.append(" check " + property.escapeCheck);
            }
            if (null != property.comment) {
                createPropertyBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
            }
            if (null != property.after) {
                createPropertyBuilder.append(" after " + this.quickDAOConfig.databaseProvider.escape(property.after));
            }
        }
        createPropertyBuilder.append(";");
        return createPropertyBuilder.toString();
    }

    @Override
    public String alterColumn(Property property) {
        StringBuilder builder = new StringBuilder("alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName));
        builder.append(" modify column " + this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
        if (property.notNull) {
            builder.append(" not null");
        } else {
            builder.append(" null");
        }
        if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
            builder.append(" default " + property.defaultValue);
        }
        if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
            builder.append(" check " + property.escapeCheck);
        }
        if (null != property.comment) {
            builder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
        }
        builder.append(";");
        return builder.toString();
    }

    @Override
    public String dropColumn(Property property) {
        StringBuilder builder = new StringBuilder("alter table ");
        if (null != this.quickDAOConfig.databaseName) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.databaseName) + ".");
        }
        builder.append(this.quickDAOConfig.databaseProvider.escape(property.entity.tableName));
        builder.append(" drop column " + this.quickDAOConfig.databaseProvider.escape(property.column) + ";");
        return builder.toString();
    }

    @Override
    public String dropTable(String tableName) {
        String dropTableSQL = "drop table " + this.quickDAOConfig.databaseProvider.escape(tableName) + ";";
        return dropTableSQL;
    }

    @Override
    public abstract String hasIndexExists(String var1, String var2);

    @Override
    public String hasConstraintExists(String tableName, String constraintName) throws SQLException {
        String hasConstraintExistsSQL = "select constraint_name from information_schema.KEY_COLUMN_USAGE where constraint_name='" + constraintName + "';";
        return hasConstraintExistsSQL;
    }

    @Override
    public String createIndex(IndexField indexField) {
        StringBuilder builder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                builder.append(" unique");
                break;
            }
            case FULLTEXT: {
                builder.append(" fulltext");
            }
        }
        builder.append(" index " + this.quickDAOConfig.databaseProvider.escape(indexField.indexName) + " on " + this.quickDAOConfig.databaseProvider.escape(indexField.tableName) + "(");
        for (String column : indexField.columns) {
            builder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != indexField.using && !indexField.using.isEmpty()) {
            builder.append(" using " + indexField.using);
        }
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            builder.append(" " + this.quickDAOConfig.databaseProvider.comment(indexField.comment));
        }
        builder.append(";");
        return builder.toString();
    }

    @Override
    public String dropIndex(String tableName, String indexName) {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.databaseProvider.escape(indexName) + ";";
        return dropIndexSQL;
    }

    @Override
    public String createForeignKey(Property property) throws SQLException {
        String operation = property.foreignKey.foreignKeyOption().getOperation();
        String reference = this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String foreignKeyName = "FK_" + property.entity.tableName + "_" + property.foreignKey.field() + "_" + this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName + "_" + property.name;
        return "alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName) + " add constraint " + this.quickDAOConfig.databaseProvider.escape(foreignKeyName) + " foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references " + reference + ";";
    }

    @Override
    public abstract Map<String, String> getTypeFieldMapping();

    protected abstract String getAutoIncrementSQL(Property var1);

    protected abstract void getIndex(List<Entity> var1) throws SQLException;

    protected abstract void getEntityPropertyList(List<Entity> var1) throws SQLException;

    protected abstract List<Entity> getEntityList() throws SQLException;
}

