/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.AbstractDAOOperation;
import cn.schoolwow.quickdao.dao.DAOOperation;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.ddl.AbstractDDLDAO;
import cn.schoolwow.quickdao.dao.sql.dml.AbstractDMLDAO;
import cn.schoolwow.quickdao.dao.sql.dql.AbstractDQLDAO;
import cn.schoolwow.quickdao.domain.ConnectionExecutor;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.query.AbstractCompositQuery;
import cn.schoolwow.quickdao.query.CompositQuery;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOInvocationHandler
implements InvocationHandler {
    private Logger logger = LoggerFactory.getLogger(DAOInvocationHandler.class);
    private QuickDAOConfig quickDAOConfig;
    private DAOOperation daoOperation;
    private CompositQuery compositQuery;

    public DAOInvocationHandler(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
        this.daoOperation = new AbstractDAOOperation(quickDAOConfig);
        this.compositQuery = new AbstractCompositQuery(quickDAOConfig);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName;
        if (!this.quickDAOConfig.initialized && method.getDeclaringClass().getName().startsWith("cn.schoolwow.quickdao")) {
            this.logger.info("[QuickDAO\u61d2\u52a0\u8f7d\u521d\u59cb\u5316]");
            this.quickDAOConfig.initialized = true;
            this.quickDAOConfig.dao.synchonizedEntityAndDatabase();
        }
        if ("CompositQuery".equals(interfaceName = method.getDeclaringClass().getSimpleName())) {
            return method.invoke((Object)this.compositQuery, args);
        }
        AbstractSQLDAO instance = null;
        switch (interfaceName) {
            case "SQLDAO": 
            case "DMLDAO": {
                instance = new AbstractDMLDAO(this.quickDAOConfig);
                break;
            }
            case "DCLDAO": {
                instance = this.quickDAOConfig.databaseProvider.getDCLDAOInstance(this.quickDAOConfig);
                break;
            }
            case "DDLDAO": {
                instance = new AbstractDDLDAO(this.quickDAOConfig);
                break;
            }
            case "DQLDAO": {
                instance = new AbstractDQLDAO(this.quickDAOConfig);
                break;
            }
            default: {
                return method.invoke((Object)this.daoOperation, args);
            }
        }
        Object result = null;
        try {
            if ("sqlite".equals(this.quickDAOConfig.databaseProvider.name())) {
                this.quickDAOConfig.sqliteLock.lock();
            }
            instance.sqlBuilder.connectionExecutor = new ConnectionExecutor(this.quickDAOConfig);
            instance.sqlBuilder.connectionExecutor.connection = this.quickDAOConfig.dataSource.getConnection();
            result = method.invoke((Object)instance, args);
            if ("DDLDAO".equals(interfaceName) && !method.getName().equals("refreshDbEntityList") && !"refreshDbEntityList".equals(method.getName()) && !"automaticCreateTableAndColumn".equals(method.getName())) {
                this.quickDAOConfig.dao.refreshDbEntityList();
            }
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            if (null != instance.sqlBuilder.connectionExecutor.connection) {
                instance.sqlBuilder.connectionExecutor.connection.close();
            }
            if ("sqlite".equals(this.quickDAOConfig.databaseProvider.name())) {
                this.quickDAOConfig.sqliteLock.unlock();
            }
        }
    }
}

