/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql;

import cn.schoolwow.quickdao.builder.AbstractSQLBuilder;
import cn.schoolwow.quickdao.dao.sql.SQLDAO;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import java.sql.ResultSet;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSQLDAO
implements SQLDAO {
    protected Logger logger = LoggerFactory.getLogger(SQLDAO.class);
    protected QuickDAOConfig quickDAOConfig;
    public AbstractSQLBuilder sqlBuilder;

    public AbstractSQLDAO(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public boolean exist(Object instance) {
        if (null == instance) {
            return false;
        }
        boolean result = false;
        try {
            Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
            ConnectionExecutorItem connectionExecutorItem = null;
            if (!entity.uniqueProperties.isEmpty()) {
                connectionExecutorItem = this.sqlBuilder.selectCountByUniqueKey(instance);
            } else if (null != entity.id) {
                connectionExecutorItem = this.sqlBuilder.selectCountById(instance);
            } else {
                throw new IllegalArgumentException("\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id\u503c,\u65e0\u6cd5\u5224\u65ad!\u7c7b\u540d:" + instance.getClass().getName());
            }
            ResultSet resultSet = this.sqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            if (resultSet.next()) {
                result = resultSet.getLong(1) > 0L;
            }
            resultSet.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean existAny(Object ... instances) {
        for (Object instance : instances) {
            if (!this.exist(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existAll(Object ... instances) {
        for (Object instance : instances) {
            if (this.exist(instance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean existAny(Collection instances) {
        return this.existAny(instances.toArray());
    }

    @Override
    public boolean existAll(Collection instances) {
        return this.existAll(instances.toArray());
    }
}

