/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.dml;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.dml.AbstractDMLBuilder;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.dml.DMLDAO;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SFunction;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.util.LambdaUtils;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class AbstractDMLDAO
extends AbstractSQLDAO
implements DMLDAO {
    private AbstractDMLBuilder dmlBuilder;

    public AbstractDMLDAO(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.dmlBuilder = new AbstractDMLBuilder(quickDAOConfig);
        this.sqlBuilder = this.dmlBuilder;
    }

    @Override
    public int insert(Object instance) {
        if (null == instance) {
            return 0;
        }
        int effect = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.insert(instance);
            effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
            if (effect > 0 && null != entity.id && entity.id.strategy.equals((Object)IdStrategy.AutoIncrement)) {
                this.setAutoIncrementPrimaryKeyValue(instance, entity, connectionExecutorItem.preparedStatement);
            }
            connectionExecutorItem.preparedStatement.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int insert(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        try {
            Entity entity = this.quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
            ConnectionExecutorItem[] connectionExecutorItems = this.dmlBuilder.insert(instances);
            for (int i = 0; i < connectionExecutorItems.length; ++i) {
                if ((effect += this.dmlBuilder.connectionExecutor.executeUpdate(connectionExecutorItems[i])) > 0 && null != entity.id && entity.id.strategy.equals((Object)IdStrategy.AutoIncrement)) {
                    this.setAutoIncrementPrimaryKeyValue(instances[i], entity, connectionExecutorItems[i].preparedStatement);
                }
                connectionExecutorItems[i].preparedStatement.close();
            }
            this.dmlBuilder.connectionExecutor.connection.commit();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int insert(Collection instanceCollection) {
        return this.insert(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int insertIgnore(Object instance) {
        if (null == instance) {
            return 0;
        }
        if (!this.exist(instance)) {
            return this.insert(instance);
        }
        return 0;
    }

    @Override
    public int insertIgnore(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        ArrayList<Object> insertList = new ArrayList<Object>();
        for (Object instance : instances) {
            if (this.exist(instance)) continue;
            insertList.add(instance);
        }
        return this.insert(insertList);
    }

    @Override
    public int insertIgnore(Collection instanceCollection) {
        return this.insertIgnore(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int insertBatch(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        try {
            this.dmlBuilder.connectionExecutor.connection.setAutoCommit(false);
            for (int i = 0; i < instances.length; i += this.quickDAOConfig.perBatchCommit) {
                ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.insertBatch(instances, i, Math.min(i + this.quickDAOConfig.perBatchCommit, instances.length));
                effect = this.dmlBuilder.connectionExecutor.executeBatchUpdate(connectionExecutorItem);
            }
            return effect;
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public int insertBatch(Collection instanceCollection) {
        return this.insertBatch(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int update(Object instance) {
        if (null == instance) {
            return 0;
        }
        int effect = 0;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        try {
            ConnectionExecutorItem connectionExecutorItem = null;
            if (!entity.uniqueProperties.isEmpty()) {
                connectionExecutorItem = this.dmlBuilder.updateByUniqueKey(instance);
            } else if (null != entity.id) {
                connectionExecutorItem = this.dmlBuilder.updateById(instance);
            } else {
                this.logger.warn("[\u5ffd\u7565\u66f4\u65b0\u64cd\u4f5c]\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id,\u5ffd\u7565\u8be5\u5b9e\u4f8b\u7684\u66f4\u65b0\u64cd\u4f5c!");
            }
            if (null != connectionExecutorItem) {
                effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
                connectionExecutorItem.preparedStatement.close();
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int update(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        try {
            Entity entity = this.quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
            ConnectionExecutorItem connectionExecutorItem = null;
            if (!entity.uniqueProperties.isEmpty()) {
                connectionExecutorItem = this.dmlBuilder.updateByUniqueKey(instances);
            } else if (null != entity.id) {
                connectionExecutorItem = this.dmlBuilder.updateById(instances);
            } else {
                this.logger.warn("[\u5ffd\u7565\u66f4\u65b0\u64cd\u4f5c]\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id,\u5ffd\u7565\u8be5\u5b9e\u4f8b\u7684\u66f4\u65b0\u64cd\u4f5c!");
            }
            if (null != connectionExecutorItem) {
                effect = this.dmlBuilder.connectionExecutor.executeBatchUpdate(connectionExecutorItem);
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int update(Collection instanceCollection) {
        return this.update(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int updatePartColumn(Object instance, String ... partColumns) {
        this.dmlBuilder.updatePartColumnThreadLocal.set(partColumns);
        int effect = this.update(instance);
        this.dmlBuilder.updatePartColumnThreadLocal.set(null);
        return effect;
    }

    @Override
    public int updatePartColumn(Object[] instances, String ... partColumns) {
        this.dmlBuilder.updatePartColumnThreadLocal.set(partColumns);
        int effect = this.update(instances);
        this.dmlBuilder.updatePartColumnThreadLocal.set(null);
        return effect;
    }

    @Override
    public int updatePartColumn(Collection instanceCollection, String ... partColumns) {
        return this.updatePartColumn(instanceCollection.toArray(new Object[0]), partColumns);
    }

    @Override
    public int save(Object instance) {
        if (null == instance) {
            return 0;
        }
        if (this.exist(instance)) {
            return this.update(instance);
        }
        return this.insert(instance);
    }

    @Override
    public int save(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        ArrayList<Object> insertList = new ArrayList<Object>();
        ArrayList<Object> updateList = new ArrayList<Object>();
        int effect = 0;
        for (Object instance : instances) {
            if (this.exist(instance)) {
                updateList.add(instance);
                continue;
            }
            insertList.add(instance);
        }
        effect += this.update(updateList);
        return effect += this.insert(insertList);
    }

    @Override
    public int save(Collection instanceCollection) {
        return this.save(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int savePartColumn(Object instance, String ... partColumns) {
        if (null == instance) {
            return 0;
        }
        if (this.exist(instance)) {
            return this.updatePartColumn(instance, partColumns);
        }
        return this.insert(instance);
    }

    @Override
    public int savePartColumn(Object[] instances, String ... partColumns) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        ArrayList<Object> insertList = new ArrayList<Object>();
        ArrayList<Object> updateList = new ArrayList<Object>();
        int effect = 0;
        for (Object instance : instances) {
            if (this.exist(instance)) {
                updateList.add(instance);
                continue;
            }
            insertList.add(instance);
        }
        effect += this.updatePartColumn(updateList, partColumns);
        return effect += this.insert(insertList);
    }

    @Override
    public int savePartColumn(Collection instanceCollection, String ... partColumns) {
        return this.savePartColumn(instanceCollection.toArray(new Object[0]), partColumns);
    }

    @Override
    public int delete(Class clazz, long id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String id) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.delete(clazz, entity.id.column, (Object)id);
    }

    @Override
    public int delete(Class clazz, String field, Object value) {
        int effect = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.deleteByProperty(clazz, field, value);
            effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public <T> int delete(Class<T> clazz, SFunction<T, ?> field, Object value) {
        try {
            String convertField = LambdaUtils.resolveLambdaProperty(field);
            return this.delete(clazz, convertField, value);
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public int delete(String tableName, String field, Object value) {
        int effect = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.deleteByProperty(tableName, field, value);
            effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int delete(Object instance) {
        if (null == instance) {
            return 0;
        }
        int effect = 0;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        try {
            ConnectionExecutorItem connectionExecutorItem = null;
            if (!entity.uniqueProperties.isEmpty()) {
                connectionExecutorItem = this.dmlBuilder.deleteByUniqueKey(instance);
            } else if (null != entity.id) {
                connectionExecutorItem = this.dmlBuilder.deleteById(instance);
            } else {
                this.logger.warn("[\u5ffd\u7565\u5220\u9664\u64cd\u4f5c]\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id,\u5ffd\u7565\u8be5\u5b9e\u4f8b\u7684\u5220\u9664\u64cd\u4f5c!");
            }
            if (null != connectionExecutorItem) {
                effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
                connectionExecutorItem.preparedStatement.close();
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int delete(Object[] instances) {
        if (null == instances || instances.length == 0) {
            return 0;
        }
        int effect = 0;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instances[0].getClass().getName());
        try {
            ConnectionExecutorItem connectionExecutorItem = null;
            if (!entity.uniqueProperties.isEmpty()) {
                connectionExecutorItem = this.dmlBuilder.deleteByUniqueKey(instances);
                if (null != connectionExecutorItem) {
                    effect = this.dmlBuilder.connectionExecutor.executeBatchUpdate(connectionExecutorItem);
                }
            } else if (null != entity.id) {
                connectionExecutorItem = this.dmlBuilder.deleteById(instances);
                effect = this.dmlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            } else {
                this.logger.warn("[\u5ffd\u7565\u5220\u9664\u64cd\u4f5c]\u8be5\u5b9e\u4f8b\u65e0\u552f\u4e00\u6027\u7ea6\u675f\u53c8\u65e0id,\u5ffd\u7565\u8be5\u5b9e\u4f8b\u7684\u5220\u9664\u64cd\u4f5c!");
            }
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int delete(Collection instanceCollection) {
        return this.delete(instanceCollection.toArray(new Object[0]));
    }

    @Override
    public int clear(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.clear(entity.escapeTableName);
    }

    @Override
    public int clear(String tableName) {
        int effect = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.clear(tableName);
            effect = this.sqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int rawUpdate(String updateSQL, Object ... parameters) {
        int effect = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.dmlBuilder.execute(updateSQL, parameters);
            effect = this.dmlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    private void setAutoIncrementPrimaryKeyValue(Object instance, Entity entity, PreparedStatement preparedStatement) throws Exception {
        Field idField = instance.getClass().getDeclaredField(entity.id.name);
        idField.setAccessible(true);
        ResultSet rs = null;
        switch (this.quickDAOConfig.databaseProvider.name()) {
            case "oracle": {
                String getIdValueSQL = "select " + entity.tableName + "_seq.currVal from dual";
                rs = this.sqlBuilder.connectionExecutor.executeQuery("\u83b7\u53d6\u81ea\u589eid", getIdValueSQL);
                break;
            }
            default: {
                rs = preparedStatement.getGeneratedKeys();
            }
        }
        if (rs.next()) {
            switch (idField.getType().getName()) {
                case "int": {
                    idField.setInt(instance, rs.getInt(1));
                    break;
                }
                case "java.lang.Integer": {
                    idField.set(instance, rs.getInt(1));
                    break;
                }
                case "long": {
                    idField.setLong(instance, rs.getLong(1));
                    break;
                }
                case "java.lang.Long": {
                    idField.set(instance, rs.getLong(1));
                    break;
                }
                case "java.lang.String": {
                    idField.set(instance, rs.getString(1));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u5f53\u524d\u4ec5\u652f\u6301int,long,String\u7c7b\u578b\u7684\u81ea\u589e\u4e3b\u952e!\u81ea\u589e\u5b57\u6bb5\u540d\u79f0:" + idField.getName() + ",\u7c7b\u578b:" + idField.getType().getName() + "!");
                }
            }
        }
        rs.close();
    }
}

